/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.messages;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.thymeleaf.lang.support.ThymeleafBundleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DefaultBundleProvider
extends ThymeleafBundleProvider {
    @Override
    @NotNull
    public Collection<PropertiesFile> getPropertiesFile(@NotNull PsiElement contextElement) {
        PsiDirectory directory;
        PsiFile containingFile;
        PsiElement context;
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/lang/support/messages/DefaultBundleProvider", "getPropertiesFile"));
        }
        ArrayList propertiesFiles = ContainerUtil.newArrayList();
        PsiFile thFile = contextElement.getContainingFile();
        if (thFile != null && (context = thFile.getContext()) != null && (containingFile = context.getContainingFile()) != null && (directory = containingFile.getOriginalFile().getContainingDirectory()) != null) {
            PsiFile[] files = directory.getFiles();
            String name = FileUtil.getNameWithoutExtension((String)containingFile.getName());
            for (PsiFile file : files) {
                if (!(file instanceof PropertiesFile) || !file.getName().startsWith(name)) continue;
                propertiesFiles.add((PropertiesFile)file);
            }
        }
        ArrayList arrayList = propertiesFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/messages/DefaultBundleProvider", "getPropertiesFile"));
        }
        return arrayList;
    }
}

