/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.utils;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.thymeleaf.lang.psi.ThymeleafReference;
import com.intellij.thymeleaf.lang.psi.ThymesELMethodCallExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELMultiSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesElStaticMemberSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesOgnlExpression;
import com.intellij.thymeleaf.lang.psi.ThymesOgnlPreprocessingExpression;
import com.intellij.thymeleaf.lang.psi.ThymesSelectionsExpression;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.ThymeleafElementProcessor;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafExpressionVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafResolveUtil {
    public static void processReference(@NotNull ThymeleafReference reference, @NotNull ThymeleafElementProcessor processor) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "processReference"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "processReference"));
        }
        PsiElement element = reference.getElement();
        ThymesElExpression context = ThymeleafResolveUtil.getContextElement(element);
        if (context == null || context == element || ThymeleafResolveUtil.isVariableMap(context) || ThymeleafResolveUtil.isIContext(context)) {
            for (ThymeleafContextVariablesProvider provider : (ThymeleafContextVariablesProvider[])Extensions.getExtensions(ThymeleafContextVariablesProvider.EP_NAME)) {
                PsiMethod psiMethod;
                for (PsiVariable psiVariable : provider.getContextVariables(element)) {
                    if (!processor.processVariable(psiVariable, PsiSubstitutor.EMPTY)) break;
                }
                Iterator<? extends PsiVariable> iterator = provider.getContextMethods(element).iterator();
                while (iterator.hasNext() && processor.processMethod(psiMethod = (PsiMethod)iterator.next(), PsiSubstitutor.EMPTY)) {
                }
            }
            ThymeleafResolveUtil.processDefaultPackages(processor, element);
        } else {
            ThymeleafResolveUtil.processDeclarations(processor, context, element);
        }
    }

    private static boolean processDefaultPackages(@NotNull ThymeleafElementProcessor processor, @Nullable PsiElement element) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "processDefaultPackages"));
        }
        if (element == null) {
            return true;
        }
        GlobalSearchScope scope = ThymeleafResolveUtil.getResolveScope(element);
        if (!ThymeleafResolveUtil.processPackage(processor, JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(""), scope)) {
            return false;
        }
        return ThymeleafResolveUtil.processPackage(processor, JavaPsiFacade.getInstance((Project)element.getProject()).findPackage("java.lang"), scope);
    }

    @NotNull
    private static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "getResolveScope"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        GlobalSearchScope globalSearchScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)element.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "getResolveScope"));
        }
        return globalSearchScope;
    }

    private static boolean processPackage(@NotNull ThymeleafElementProcessor processor, @Nullable PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "processPackage"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "processPackage"));
        }
        if (psiPackage != null) {
            for (PsiPackage psiPackage2 : psiPackage.getSubPackages(scope)) {
                if (processor.processPackage(psiPackage2)) continue;
                return false;
            }
            for (PsiPackage psiPackage3 : psiPackage.getClasses(scope)) {
                if (processor.processClass((PsiClass)psiPackage3)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isVariableMap(@NotNull ThymesElExpression context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "isVariableMap"));
        }
        PsiType contextType = context.getType();
        if (contextType instanceof PsiClassType && contextType.isValid()) {
            return InheritanceUtil.isInheritor((PsiType)contextType, (String)"org.thymeleaf.context.VariablesMap");
        }
        return false;
    }

    private static boolean isIContext(@NotNull ThymesElExpression context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "isIContext"));
        }
        PsiType contextType = context.getType();
        return contextType != null && contextType.isValid() && "org.thymeleaf.context.IContext".equals(contextType.getCanonicalText());
    }

    protected static boolean processDeclarations(@NotNull ThymeleafElementProcessor processor, @NotNull ThymesElExpression context, @NotNull PsiElement element) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "processDeclarations"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "processDeclarations"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "processDeclarations"));
        }
        for (PsiReference ref : context.getReferences()) {
            if (!(ref instanceof ThymeleafReference)) continue;
            ResolveResult[] resolveResultArray = ((ThymeleafReference)ref).multiResolve(false);
            int n = resolveResultArray.length;
            for (int i = 0; i < n; ++i) {
                ResolveResult result = resolveResultArray[i];
                PsiElement resolve = result.getElement();
                if (!(resolve instanceof ThymeleafExpressionVariable ? !((ThymeleafExpressionVariable)resolve).processDeclarations(processor) : resolve instanceof PsiPackage && !ThymeleafResolveUtil.processPackage(processor, (PsiPackage)resolve, ThymeleafResolveUtil.getResolveScope(element)))) continue;
                return false;
            }
        }
        PsiType contextType = context.getType();
        PsiClass psiClass = ThymeleafResolveUtil.getContextClass(contextType, element);
        if (psiClass != null) {
            PsiSubstitutor substitutor = ThymeleafResolveUtil.getSubstitutor(contextType);
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                PsiClass containingClass = psiMethod.getContainingClass();
                if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) || psiMethod.isConstructor() || !psiMethod.hasModifierProperty("public") || processor.processMethod(psiMethod, substitutor)) continue;
                return false;
            }
            for (PsiMethod psiMethod : psiClass.getAllFields()) {
                PsiModifierList modifierList = psiMethod.getModifierList();
                if (modifierList == null || !modifierList.hasModifierProperty("public") || processor.processVariable((PsiVariable)psiMethod, substitutor)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(PsiType contextType) {
        if (contextType instanceof PsiClassType) {
            PsiSubstitutor psiSubstitutor = ((PsiClassType)contextType).resolveGenerics().getSubstitutor();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "getSubstitutor"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Nullable
    private static PsiClass getContextClass(@Nullable PsiType type, @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "getContextClass"));
        }
        if (type == null) {
            return null;
        }
        if (psiElement.getParent() instanceof ThymesELMultiSelectExpression) {
            PsiType itType = null;
            if (type instanceof PsiClassType) {
                itType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Collection", (int)0, (boolean)false);
            } else if (type instanceof PsiArrayType) {
                itType = ((PsiArrayType)type).getComponentType();
            }
            if (itType instanceof PsiClassType) {
                return ((PsiClassType)itType).resolve();
            }
        }
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        return null;
    }

    @Nullable
    protected static ThymesElExpression getContextElement(@Nullable PsiElement psiElement) {
        PsiElement grandParent;
        if (psiElement == null || ThymeleafResolveUtil.isExpressionUtilVariable(psiElement)) {
            return null;
        }
        PsiElement parent = psiElement.getParent();
        if (parent instanceof ThymesELSelectExpression && ((ThymesELSelectExpression)parent).getField() == psiElement) {
            return ThymeleafResolveUtil.getContextSelectExpression((ThymesELSelectExpression)parent);
        }
        if (psiElement instanceof ThymesELSelectExpression) {
            return ((ThymesELSelectExpression)psiElement).getField();
        }
        if (parent instanceof ThymesElStaticMemberSelectExpression) {
            return ((ThymesElStaticMemberSelectExpression)parent).getElStaticSelection().getELSelectExpression();
        }
        if (parent instanceof ThymesELMethodCallExpression && (grandParent = parent.getParent()) instanceof ThymesElStaticMemberSelectExpression) {
            return ((ThymesElStaticMemberSelectExpression)grandParent).getElStaticSelection().getELSelectExpression();
        }
        if (psiElement instanceof ThymesSelectionsExpression) {
            ThymesElExpression thymesElExpression = ThymeleafCommonUtil.findObjectExpression(psiElement);
            if (thymesElExpression instanceof ThymesOgnlExpression) {
                ThymesElExpression expression = ((ThymesOgnlExpression)thymesElExpression).getElExpression();
                return expression instanceof ThymesELVariable ? expression : ThymeleafResolveUtil.getContextElement(expression);
            }
            if (thymesElExpression instanceof ThymesSelectionsExpression) {
                ThymesElExpression expression = ((ThymesSelectionsExpression)thymesElExpression).getElExpression();
                return expression instanceof ThymesELVariable ? expression : ThymeleafResolveUtil.getContextElement(expression);
            }
        }
        if (parent instanceof ThymesELMultiSelectExpression) {
            return ThymeleafResolveUtil.getContextElement(parent);
        }
        ThymesSelectionsExpression expression = (ThymesSelectionsExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, ThymesSelectionsExpression.class, (boolean)true, (Class[])new Class[]{ThymesOgnlExpression.class, ThymesOgnlPreprocessingExpression.class});
        if (expression != null) {
            return ThymeleafResolveUtil.getContextElement(expression);
        }
        return null;
    }

    @Nullable
    private static ThymesElExpression getContextSelectExpression(@NotNull ThymesELSelectExpression psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "getContextSelectExpression"));
        }
        ThymesElExpression from = psiElement.getFrom();
        return from instanceof ThymesELSelectExpression ? ((ThymesELSelectExpression)from).getField() : from;
    }

    private static boolean isExpressionUtilVariable(PsiElement element) {
        return element instanceof ThymesELVariable && element.getText().startsWith("#");
    }

    public static GlobalSearchScope getThymeleafFilesScope(@NotNull Project project, @NotNull GlobalSearchScope effectiveSearchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "getThymeleafFilesScope"));
        }
        if (effectiveSearchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveSearchScope", "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil", "getThymeleafFilesScope"));
        }
        GlobalSearchScope types = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)effectiveSearchScope, (FileType[])new FileType[]{XmlFileType.INSTANCE, XHtmlFileType.INSTANCE, HtmlFileType.INSTANCE});
        Collection files = FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)new IdIndexEntry("thymeleaf", true), types);
        return GlobalSearchScope.filesScope((Project)project, (Collection)files);
    }
}

