/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.inspections.CreateCssClassLocalQuickFix;
import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.gwt.uiBinder.references.QualifiedUiXmlReference;
import com.intellij.gwt.uiBinder.references.QualifiedUiXmlReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateLocalCssClassLocalQuickFix
extends BaseGwtLocalQuickFix {
    private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.local.css.class", new Object[0]);
    private final String myClassName;

    public CreateLocalCssClassLocalQuickFix(String className) {
        super(GwtBundle.message("quickfix.name.create.local.css.class.0", className));
        this.myClassName = className;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = FAMILY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/CreateLocalCssClassLocalQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/CreateLocalCssClassLocalQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/CreateLocalCssClassLocalQuickFix", "applyFix"));
        }
        XmlAttribute attribute = (XmlAttribute)descriptor.getPsiElement().getParent();
        attribute.setValue("{style." + this.myClassName + "}");
        XmlAttributeValue attributeValue = attribute.getValueElement();
        Object[] references = new QualifiedUiXmlReferenceProvider().getReferencesByElement((PsiElement)attributeValue, new ProcessingContext());
        QualifiedUiXmlReference uiXmlReference = (QualifiedUiXmlReference)ContainerUtil.findInstance((Object[])references, QualifiedUiXmlReference.class);
        if (uiXmlReference == null || uiXmlReference.multiResolve(false).length > 0) {
            return;
        }
        UiStyleElement uiStyleElement = uiXmlReference.findStyleElement();
        if (uiStyleElement == null) {
            XmlTag rootTag = ((XmlFile)attributeValue.getContainingFile()).getRootTag();
            if (rootTag == null) {
                return;
            }
            rootTag.addSubTag(rootTag.createChildTag("style", "urn:ui:com.google.gwt.uibinder", "\n." + this.myClassName + "{\n\n}\n", false), true);
        } else {
            List<StylesheetFile> stylesheetFiles = uiStyleElement.getStylesheetFiles();
            if (stylesheetFiles.isEmpty()) {
                XmlTagValue styleValue = uiStyleElement.getTag().getValue();
                styleValue.setText(styleValue.getText() + "\n." + this.myClassName + "{\n\n}\n");
            } else {
                new CreateCssClassLocalQuickFix(uiStyleElement.getTag(), this.myClassName).applyFix(project, descriptor);
            }
        }
    }
}

