/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtUiFieldAssignmentInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection", "checkClass"));
        }
        if (!GwtUiFieldAssignmentInspection.shouldCheck((PsiElement)aClass) || UiBinderMappingService.getUiXmlFilesForClass(aClass).isEmpty()) {
            return null;
        }
        SmartList problems = new SmartList();
        aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)problems, manager, isOnTheFly){
            final /* synthetic */ List val$problems;
            final /* synthetic */ InspectionManager val$manager;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$problems = list;
                this.val$manager = inspectionManager;
                this.val$isOnTheFly = bl;
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                Boolean provided;
                PsiAnnotation annotation;
                PsiField field;
                PsiModifierList modifierList;
                PsiElement element;
                PsiExpression left = expression.getLExpression();
                if (left instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)left).resolve()) instanceof PsiField && (modifierList = (field = (PsiField)element).getModifierList()) != null && (annotation = modifierList.findAnnotation("com.google.gwt.uibinder.client.UiField")) != null && ((provided = (Boolean)AnnotationModelUtil.getBooleanValue((PsiAnnotation)annotation, (String)"provided", (boolean)false).getValue()) == null || !provided.booleanValue())) {
                    String message = "Assignment to @UiField annotated field will be ignored because it is initialized by UiBinder";
                    SetProvidedAttributeQuickFix fix = new SetProvidedAttributeQuickFix(annotation);
                    this.val$problems.add(this.val$manager.createProblemDescriptor((PsiElement)expression, "Assignment to @UiField annotated field will be ignored because it is initialized by UiBinder", (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.val$isOnTheFly));
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }
        });
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Assignment to @UiField fields" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection", "getDisplayName"));
        }
        return "Assignment to @UiField fields";
    }

    @NotNull
    public String getShortName() {
        if ("GwtUiFieldAssignment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection", "getShortName"));
        }
        return "GwtUiFieldAssignment";
    }

    private static class SetProvidedAttributeQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String NAME = GwtBundle.message("quickfix.name.set.provided.to.true", new Object[0]);
        private final PsiAnnotation myAnnotation;

        private SetProvidedAttributeQuickFix(PsiAnnotation annotation) {
            super(NAME);
            this.myAnnotation = annotation;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection$SetProvidedAttributeQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection$SetProvidedAttributeQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection$SetProvidedAttributeQuickFix", "applyFix"));
            }
            PsiExpression trueLiteral = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("true", null);
            this.myAnnotation.setDeclaredAttributeValue("provided", (PsiAnnotationMemberValue)trueLiteral);
        }
    }
}

