/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk;

import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.GwtStudioIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GwtLibraryPresentationProvider
extends LibraryPresentationProvider<DummyLibraryProperties> {
    public static final LibraryKind GWT_LIBRARY_KIND = LibraryKind.create((String)"gwt");

    public GwtLibraryPresentationProvider() {
        super(GWT_LIBRARY_KIND);
    }

    public Icon getIcon() {
        return GwtStudioIcons.Google_small;
    }

    public DummyLibraryProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/gwt/sdk/GwtLibraryPresentationProvider", "detect"));
        }
        for (VirtualFile root : classesRoots) {
            VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(root);
            if (jar == null || !jar.getName().equals("gwt-user.jar")) continue;
            return DummyLibraryProperties.INSTANCE;
        }
        return null;
    }

    public String getDescription(@NotNull DummyLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/gwt/sdk/GwtLibraryPresentationProvider", "getDescription"));
        }
        return "GWT SDK library";
    }
}

