package com.intellij.sql.psi;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Gregory.Shrago
 */
public interface SqlConstraintDefinition extends SqlElement, SqlDefinition {
  enum Type { NULLABLE, NOT_NULL, CHECK, DEFAULT, OTHER }

  Key<SqlExpression> CHECK_EXPRESSION = Key.create("CHECK_EXPRESSION");

  @NotNull
  Type getConstraintType();

  @Nullable
  SqlReferenceExpression getNameElement();

  @Nullable
  <T> T getConstraintParameter(final Key<T> key);

}