/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.web;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * @author Dmitry Avdeev
 */
public abstract class WebContextManager {
  
  public static WebContextManager getInstance(Project project) {
    return ServiceManager.getService(project, WebContextManager.class);
  }

  @Nullable
  public abstract PsiFileSystemItem getContextFolder(@NotNull PsiFile file);

  public abstract void setContextFolder(@NotNull PsiFileSystemItem target, @NotNull PsiFileSystemItem contextFolder);

  public abstract Map<VirtualFile, String> getMappings();

  public abstract void setMappings(Map<VirtualFile, String> mappings);
}
