/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting;

import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.converting.JavaeeConvertingContext;
import com.intellij.javaee.converting.artifacts.PackagingMethod;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMExternalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class JavaeeModuleConvertingUtil {
    @NonNls
    public static final String WEB_ROOTS_ELEMENT = "webroots";
    @NonNls
    public static final String OLD_VALIDATORS_ELEMENT = "AppServerSpecificValidatorsManager";
    @NonNls
    public static final Set<String> CHILD_FACETS_FOR_JAVAEE = new HashSet<String>(Arrays.asList("struts", "jsf"));
    @NonNls
    private static final String COMPONENT_ELEMENT = "component";
    @NonNls
    private static final String NAME_ATTRUBUTE = "name";
    @NonNls
    private static final String J2EE_INTEGRATION_ATTRIBUTE = "j2ee-integration";
    @NonNls
    public static final String MODULE_TYPE_ATTRIBUTE = "type";
    @NonNls
    private static final String JAVA_MODULE_TYPE = "JAVA_MODULE";
    @NonNls
    public static final String ROOT_MANAGER_COMPONENT_NAME = "NewModuleRootManager";
    @NonNls
    public static final String WEB_MODULE_TYPE = "J2EE_WEB_MODULE";
    @NonNls
    public static final String EJB_MODULE_TYPE = "J2EE_EJB_MODULE";
    @NonNls
    public static final String APP_MODULE_TYPE = "J2EE_APPLICATION_MODULE";
    @NonNls
    private static final String CONTENT_ENTRY_ELEMENT = "content";
    @NonNls
    private static final String SOURCE_FOLDER_ELEMENT = "sourceFolder";
    @NonNls
    private static final String TEST_SOURCE_ATTRIBUTE = "isTestSource";
    @NonNls
    private static final String SOURCE_ROOT_URL_ATTRIBUTE = "url";
    @NonNls
    public static final String EXCLUDE_EXPLODED_ELEMENT = "exclude-exploded";
    @NonNls
    public static final String EXPLODED_ELEMENT = "exploded";
    @NonNls
    private static final String[] OBSOLETE_COMPONENTS = new String[]{"WeblogicWebModuleProperties", "WLEjbModuleProperties", "WeblogicApplicationModuleProperties"};
    @NonNls
    public static final String OLD_WEBROOTS_ELEMENT = "webroots";

    private JavaeeModuleConvertingUtil() {
    }

    @Nullable
    public static FacetTypeId<? extends JavaeeFacet> getFacetType(Element root) {
        String type = root.getAttributeValue(MODULE_TYPE_ATTRIBUTE);
        return JavaeeModuleConvertingUtil.getFacetTypeByModuleType(type);
    }

    @Nullable
    public static FacetTypeId<? extends JavaeeFacet> getFacetTypeByModuleType(String type) {
        if (WEB_MODULE_TYPE.equals(type)) {
            return WebFacet.ID;
        }
        if (EJB_MODULE_TYPE.equals(type)) {
            return EjbFacet.ID;
        }
        if (APP_MODULE_TYPE.equals(type)) {
            return JavaeeApplicationFacet.ID;
        }
        return null;
    }

    public static void convertRootElement(Element root, String moduleName, JavaeeConvertingContext context) {
        Element oldValidators;
        Element oldWebRoots;
        FacetTypeId<? extends JavaeeFacet> type = context.getFacetType(moduleName);
        if (type == null) {
            return;
        }
        root.removeAttribute(J2EE_INTEGRATION_ATTRIBUTE);
        root.setAttribute(MODULE_TYPE_ATTRIBUTE, JAVA_MODULE_TYPE);
        for (String name : OBSOLETE_COMPONENTS) {
            Element element = JDomSerializationUtil.findComponent((Element)root, (String)name);
            if (element == null) continue;
            root.removeContent((Content)element);
        }
        Element oldBuildSettings = JDomSerializationUtil.findComponent((Element)root, (String)JavaeeModuleConvertingUtil.getJavaeeBuildPropertiesComponentName(type));
        if (oldBuildSettings == null) {
            return;
        }
        Element newBuildSettings = new Element("building");
        JDomConvertingUtil.copyChildren((Element)oldBuildSettings, (Element)newBuildSettings);
        root.removeContent((Content)oldBuildSettings);
        Element oldProperties = JDomSerializationUtil.findComponent((Element)root, (String)JavaeeModuleConvertingUtil.getJavaeePropertiesComponentName(type));
        Element descriptors = new Element("descriptors");
        JDomConvertingUtil.copyChildren((Element)oldProperties, (Element)descriptors, (Condition)JDomConvertingUtil.createElementNameFilter((String)"deploymentDescriptor"));
        Element rootManager = JDomSerializationUtil.findComponent((Element)root, (String)ROOT_MANAGER_COMPONENT_NAME);
        if (JavaeeApplicationFacet.ID.equals(type)) {
            if (rootManager == null) {
                rootManager = JDomSerializationUtil.createComponentElement((String)ROOT_MANAGER_COMPONENT_NAME);
                JDomSerializationUtil.addComponent((Element)root, (Element)rootManager);
            }
            JavaeeModuleConvertingUtil.addDependencies(rootManager, oldProperties, context);
        }
        JavaeeModuleConvertingUtil.convertExploded(newBuildSettings, rootManager);
        Element packagingSettings = JavaeeModuleConvertingUtil.convertPackagingElements(oldProperties, context, type, moduleName);
        Element facetConfiguration = new Element("configuration");
        Element element = oldWebRoots = oldProperties != null ? oldProperties.getChild("webroots") : null;
        if (oldWebRoots != null) {
            Element webRoots = new Element("webroots");
            JDomConvertingUtil.copyChildren((Element)oldWebRoots, (Element)webRoots);
            facetConfiguration.addContent(webRoots);
        }
        root.removeContent((Content)oldProperties);
        facetConfiguration.addContent(packagingSettings);
        facetConfiguration.addContent(descriptors);
        facetConfiguration.addContent(newBuildSettings);
        if (WebFacet.ID.equals(type)) {
            Element webSourceRoots = JavaeeModuleConvertingUtil.createSourceRootsElement(rootManager, "sourceRoots");
            facetConfiguration.addContent(webSourceRoots);
        }
        if (EjbFacet.ID.equals(type)) {
            Element ejbRoots = JavaeeModuleConvertingUtil.createSourceRootsElement(rootManager, "ejbRoots");
            facetConfiguration.addContent(ejbRoots);
        }
        if ((oldValidators = JDomSerializationUtil.findComponent((Element)root, (String)OLD_VALIDATORS_ELEMENT)) != null) {
            Element newValidators = new Element("validators");
            JDomConvertingUtil.copyChildren((Element)oldValidators, (Element)newValidators);
            root.removeContent((Content)oldValidators);
            facetConfiguration.addContent(newValidators);
        }
        Element facetManager = JDomSerializationUtil.findComponent((Element)root, (String)"FacetManager");
        ArrayList<Element> childFacets = new ArrayList<Element>();
        if (facetManager != null) {
            ArrayList<Element> toRemove = new ArrayList<Element>();
            List facetsList = facetManager.getChildren("facet");
            for (Element e : facetsList) {
                String facetType = e.getAttributeValue(MODULE_TYPE_ATTRIBUTE);
                if (!CHILD_FACETS_FOR_JAVAEE.contains(facetType)) continue;
                childFacets.add(e.clone());
                toRemove.add(e);
            }
            for (Element element2 : toRemove) {
                facetManager.removeContent((Content)element2);
            }
        } else {
            facetManager = new Element(COMPONENT_ELEMENT);
            facetManager.setAttribute(NAME_ATTRUBUTE, "FacetManager");
            root.addContent(facetManager);
        }
        List jpaDescriptors = JDomConvertingUtil.removeChildren((Element)descriptors, (Condition)JDomConvertingUtil.createAttributeValueFilter((String)NAME_ATTRUBUTE, Arrays.asList(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName(), JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA.getFileName())));
        Element facetElement = new Element("facet");
        facetElement.setAttribute(MODULE_TYPE_ATTRIBUTE, JavaeeConvertingContext.getStringId(type));
        facetElement.setAttribute(NAME_ATTRUBUTE, moduleName);
        facetElement.addContent(facetConfiguration);
        for (Element childFacet : childFacets) {
            facetElement.addContent(childFacet);
        }
        facetManager.addContent(facetElement);
        if (!jpaDescriptors.isEmpty()) {
            Element jpaFacetConfiguration = new Element("configuration");
            jpaFacetConfiguration.addContent((Collection)jpaDescriptors);
            Element jpaFacetElement = new Element("facet");
            FacetType jpaFacetType = FacetTypeRegistry.getInstance().findFacetType(JpaFacet.ID);
            jpaFacetElement.setAttribute(MODULE_TYPE_ATTRIBUTE, jpaFacetType.getStringId());
            jpaFacetElement.setAttribute(NAME_ATTRUBUTE, moduleName);
            jpaFacetElement.addContent(jpaFacetConfiguration);
            facetManager.addContent(jpaFacetElement);
        }
    }

    private static void convertExploded(Element newBuildSettings, @Nullable Element rootManager) {
        boolean excludeExploded = false;
        if (rootManager != null) {
            Element excludeExplodedElement;
            Element exploded = rootManager.getChild(EXPLODED_ELEMENT);
            if (exploded != null) {
                rootManager.removeContent((Content)exploded);
            }
            if ((excludeExplodedElement = rootManager.getChild(EXCLUDE_EXPLODED_ELEMENT)) != null) {
                excludeExploded = true;
                rootManager.removeContent((Content)excludeExplodedElement);
            }
        }
        JDOMExternalizer.write((Element)newBuildSettings, (String)"EXCLUDE_EXPLODED_DIRECTORY", (String)String.valueOf(excludeExploded));
    }

    private static Element createSourceRootsElement(@Nullable Element rootManager, String elementName) {
        Element ejbRoots = new Element(elementName);
        if (rootManager != null) {
            List contentRoots = rootManager.getChildren(CONTENT_ENTRY_ELEMENT);
            for (Element contentRoot : contentRoots) {
                List sourceRoots = contentRoot.getChildren(SOURCE_FOLDER_ELEMENT);
                for (Element sourceRoot : sourceRoots) {
                    String value = sourceRoot.getAttributeValue(TEST_SOURCE_ATTRIBUTE);
                    if (!Boolean.FALSE.toString().equals(value)) continue;
                    String url = sourceRoot.getAttributeValue(SOURCE_ROOT_URL_ATTRIBUTE);
                    Element rootElement = new Element("root");
                    rootElement.setAttribute(SOURCE_ROOT_URL_ATTRIBUTE, url);
                    ejbRoots.addContent(rootElement);
                }
            }
        }
        return ejbRoots;
    }

    private static void addDependencies(@NotNull Element rootManager, Element oldProperties, JavaeeConvertingContext context) {
        if (rootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootManager", "com/intellij/javaee/converting/JavaeeModuleConvertingUtil", "addDependencies"));
        }
        List list = oldProperties.getChildren("containerElement");
        for (Element containerElement : list) {
            String moduleName;
            String id;
            Element packagingMethod;
            String type = containerElement.getAttributeValue(MODULE_TYPE_ATTRIBUTE);
            if (!"module".equals(type) || (packagingMethod = JavaeeModuleConvertingUtil.findPackagingElement(containerElement)) == null || PackagingMethod.DO_NOT_PACKAGE.getId().equals(packagingMethod.getAttributeValue("value")) || (id = context.getFacetId(moduleName = containerElement.getAttributeValue(NAME_ATTRUBUTE))) == null || JavaeeModuleConvertingUtil.hasDependency(rootManager, moduleName)) continue;
            Element child = new Element("orderEntry");
            child.setAttribute("module-name", moduleName);
            child.setAttribute(MODULE_TYPE_ATTRIBUTE, "module");
            rootManager.addContent(child);
        }
    }

    @Nullable
    private static Element findPackagingElement(Element containerElement) {
        Condition packagingMethodFilter = JDomConvertingUtil.createElementWithAttributeFilter((String)"attribute", (String)NAME_ATTRUBUTE, (String)"method");
        return JDomConvertingUtil.findChild((Element)containerElement, (Condition)packagingMethodFilter);
    }

    private static boolean hasDependency(Element rootManager, String moduleName) {
        List list = rootManager.getChildren("orderEntry");
        for (Element entry : list) {
            if (!"module".equals(entry.getAttributeValue(MODULE_TYPE_ATTRIBUTE)) || !moduleName.equals(entry.getAttributeValue("module-name"))) continue;
            return true;
        }
        return false;
    }

    private static Element convertPackagingElements(Element oldProperties, JavaeeConvertingContext context, FacetTypeId<? extends JavaeeFacet> type, String moduleName) {
        Element packaging = new Element("packaging");
        List list = oldProperties.getChildren("containerElement");
        if (WebFacet.ID.equals(type)) {
            Element element = new Element("containerElement");
            element.setAttribute(MODULE_TYPE_ATTRIBUTE, "module");
            element.setAttribute(NAME_ATTRUBUTE, moduleName);
            element.addContent(JavaeeModuleConvertingUtil.createPackagingAttribute("method", PackagingMethod.COPY_FILES.getId()));
            element.addContent(JavaeeModuleConvertingUtil.createPackagingAttribute("URI", "/WEB-INF/classes"));
            packaging.addContent(element);
        }
        for (Element containerElement : list) {
            Element newElement = JavaeeModuleConvertingUtil.convertPackagingElement(context, containerElement);
            packaging.addContent(newElement);
        }
        return packaging;
    }

    private static Element createPackagingAttribute(String name, @NonNls String value) {
        Element element = new Element("attribute");
        element.setAttribute(NAME_ATTRUBUTE, name);
        element.setAttribute("value", value);
        return element;
    }

    private static Element convertPackagingElement(JavaeeConvertingContext context, Element packagingElement) {
        String moduleName;
        String id;
        String type = packagingElement.getAttributeValue(MODULE_TYPE_ATTRIBUTE);
        if ("module".equals(type) && (id = context.getFacetId(moduleName = packagingElement.getAttributeValue(NAME_ATTRUBUTE))) != null) {
            Element newElement = new Element("containerElement");
            newElement.setAttribute(MODULE_TYPE_ATTRIBUTE, "facet");
            newElement.setAttribute("facetId", id);
            JDomConvertingUtil.copyChildren((Element)packagingElement, (Element)newElement);
            return newElement;
        }
        return packagingElement.clone();
    }

    @NonNls
    public static String getJavaeeBuildPropertiesComponentName(FacetTypeId<? extends JavaeeFacet> typeId) {
        if (WebFacet.ID.equals(typeId)) {
            return "WebModuleBuildComponent";
        }
        if (EjbFacet.ID.equals(typeId)) {
            return "EjbModuleBuildComponent";
        }
        if (JavaeeApplicationFacet.ID.equals(typeId)) {
            return "ApplicationModuleBuildComponent";
        }
        throw new AssertionError(typeId);
    }

    @NonNls
    public static String getJavaeePropertiesComponentName(FacetTypeId<? extends JavaeeFacet> typeId) {
        if (WebFacet.ID.equals(typeId)) {
            return "WebModuleProperties";
        }
        if (EjbFacet.ID.equals(typeId)) {
            return "EjbModuleProperties";
        }
        if (JavaeeApplicationFacet.ID.equals(typeId)) {
            return "ApplicationModuleProperties";
        }
        throw new AssertionError(typeId);
    }
}

