/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations.ejb;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.facet.FacetManager;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.annotations.ejb.ApplicationExceptionImpl;
import com.intellij.javaee.model.annotations.ejb.InterceptorImpl;
import com.intellij.javaee.model.annotations.ejb.MessageDrivenBeanImpl;
import com.intellij.javaee.model.annotations.ejb.SessionBeanImpl;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanSet;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.InterceptorSet;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SecurityRole;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EjbRootElementImpl
extends CommonModelElement.ModuleBase
implements EjbRootElement {
    private static final Key<CachedValue<Collection<PsiClass>>> INTERCEPTOR_CLASSES_KEY = Key.create((String)"INTERCEPTOR_CLASSES_KEY");
    private final EjbFacet myFacet;
    private final CachedValue<List<SessionBeanImpl>> mySessionBeanValue;
    private final CachedValue<List<MessageDrivenBeanImpl>> myMessageBeanValue;
    private final CachedValue<List<ApplicationExceptionImpl>> myExceptionsValue;

    public EjbRootElementImpl(EjbFacet facet) {
        this.myFacet = facet;
        Project project = this.myFacet.getModule().getProject();
        Factory scopeFactory = this::getScope;
        this.mySessionBeanValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{SessionBeanImpl.STATEFUL_META, SessionBeanImpl.STATELESS_META, SessionBeanImpl.SINGLETON_META});
        this.myMessageBeanValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{MessageDrivenBeanImpl.MDB_META});
        this.myExceptionsValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{ApplicationExceptionImpl.APPLICATION_EXCEPTION_META});
    }

    private GlobalSearchScope getScope() {
        return GlobalSearchScope.moduleWithDependenciesScope((Module)this.myFacet.getModule());
    }

    public GenericValue<String> getVersion() {
        return ReadOnlyGenericValue.getInstance((Object)EjbDescriptorVersion.EJB_VERSION_3_0.getValue());
    }

    public List<ApplicationExceptionImpl> getApplicationExceptions() {
        return (List)this.myExceptionsValue.getValue();
    }

    public EnterpriseBeanSet getEnterpriseBeans() {
        return new MyEnterpriseBeanSet();
    }

    public InterceptorSet getInterceptors() {
        return new MyInterceptorSet();
    }

    public List<SecurityRole> getSecurityRoles() {
        THashSet result = new THashSet();
        for (SessionBean ejb : this.getEnterpriseBeans().getSessions()) {
            for (GenericValue value : ejb.getDeclaredRoles()) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)value.getValue());
            }
        }
        for (SessionBean ejb : this.getEnterpriseBeans().getMessageDrivens()) {
            for (GenericValue value : ejb.getDeclaredRoles()) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)value.getValue());
            }
        }
        return Arrays.asList(result.toArray((Object[])new SecurityRole[result.size()]));
    }

    @NotNull
    public Module getModule() {
        Module module = this.myFacet.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/annotations/ejb/EjbRootElementImpl", "getModule"));
        }
        return module;
    }

    public static Collection<PsiClass> getInterceptorClasses(Project project) {
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, INTERCEPTOR_CLASSES_KEY, () -> new CachedValueProvider.Result(EjbRootElementImpl.calculateInterceptorClasses(project), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}), false);
    }

    private static Collection<PsiClass> calculateInterceptorClasses(Project project) {
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptySet();
        }
        PsiClass annoPsiClass = JavaPsiFacade.getInstance((Project)project).findClass("javax.interceptor.Interceptors", GlobalSearchScope.allScope((Project)project));
        if (annoPsiClass == null) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet();
        for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)annoPsiClass, (SearchScope)GlobalSearchScope.projectScope((Project)project)).findAll()) {
            PsiAnnotation anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (String[])new String[]{"javax.interceptor.Interceptors"});
            PsiNameValuePair attr = anno == null ? null : AnnotationUtil.findDeclaredAttribute((PsiAnnotation)anno, (String)"value");
            if (attr == null) continue;
            PsiAnnotationMemberValue value = attr instanceof PsiNameValuePair.Detachable ? ((PsiNameValuePair.Detachable)attr).getDetachedValue() : attr.getValue();
            JamCommonUtil.processObjectArrayValue((PsiAnnotationMemberValue)value, classRef -> {
                ContainerUtil.addIfNotNull((Collection)result, (Object)JamCommonUtil.getPsiClass((PsiAnnotationMemberValue)classRef));
                return true;
            });
        }
        return result;
    }

    private class MyInterceptorSet
    extends CommonModelElement.ModuleBase
    implements InterceptorSet {
        private MyInterceptorSet() {
        }

        @NotNull
        public Module getModule() {
            Module module = EjbRootElementImpl.this.myFacet.getModule();
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/annotations/ejb/EjbRootElementImpl$MyInterceptorSet", "getModule"));
            }
            return module;
        }

        public List<? extends Interceptor> getInterceptors() {
            GlobalSearchScope scope = EjbRootElementImpl.this.getScope();
            ArrayList result = new ArrayList();
            for (PsiClass psiClass : EjbRootElementImpl.getInterceptorClasses(EjbRootElementImpl.this.myFacet.getModule().getProject())) {
                if (!scope.contains(psiClass.getContainingFile().getVirtualFile())) continue;
                ContainerUtil.addIfNotNull(result, (Object)InterceptorImpl.INTERCEPTOR_META.getJamElement((PsiModifierListOwner)psiClass));
            }
            return result;
        }
    }

    private class MyEnterpriseBeanSet
    extends CommonModelElement.ModuleBase
    implements EnterpriseBeanSet {
        private MyEnterpriseBeanSet() {
        }

        @NotNull
        public Module getModule() {
            Module module = EjbRootElementImpl.this.myFacet.getModule();
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/annotations/ejb/EjbRootElementImpl$MyEnterpriseBeanSet", "getModule"));
            }
            return module;
        }

        public boolean isValid() {
            return FacetManager.getInstance((Module)EjbRootElementImpl.this.myFacet.getModule()).findFacet(EjbRootElementImpl.this.myFacet.getTypeId(), EjbRootElementImpl.this.myFacet.getName()) == EjbRootElementImpl.this.myFacet;
        }

        public List<? extends SessionBean> getSessions() {
            return (List)EjbRootElementImpl.this.mySessionBeanValue.getValue();
        }

        public List<? extends EntityBean> getEntities() {
            return Collections.emptyList();
        }

        public List<? extends MessageDrivenBean> getMessageDrivens() {
            return (List)EjbRootElementImpl.this.myMessageBeanValue.getValue();
        }

        public List<? extends GenericValue<PsiClass>> getDefaultInterceptors() {
            return Collections.emptyList();
        }
    }
}

