/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.components;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=MyPresentationProvider.class)
public abstract class FrameworkElementAsVirtualFileImpl<T extends Facet>
extends VirtualFile {
    private final String myProjectId;
    private final FacetPointer<T> myFacetPointer;
    private String myElementName;
    protected final String myElementType;

    protected FrameworkElementAsVirtualFileImpl(@NotNull FacetPointer<T> facetPointer, String elementType, String elementName) {
        if (facetPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetPointer", "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl", "<init>"));
        }
        this.myProjectId = facetPointer.getProject().getLocationHash();
        this.myElementType = elementType;
        this.myFacetPointer = facetPointer;
        this.myElementName = elementName;
    }

    public abstract String getPresentableName();

    @NotNull
    public FacetPointer<T> getFacetPointer() {
        FacetPointer<T> facetPointer = this.myFacetPointer;
        if (facetPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl", "getFacetPointer"));
        }
        return facetPointer;
    }

    @NotNull
    public String getPath() {
        String string = FrameworkElementAsVirtualFileImpl.getPath(this.myFacetPointer, this.myElementType, this.myElementName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl", "getPath"));
        }
        return string;
    }

    public static String getPath(Facet facet, String elementType, String elementName) {
        return FrameworkVirtualFileSystem.getPath(facet.getModule().getProject(), FacetPointersManager.constructId((Facet)facet), elementType, elementName);
    }

    public static String getPath(@NotNull FacetPointer<? extends Facet> facetPointer, String elementType, String elementName) {
        if (facetPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetPointer", "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl", "getPath"));
        }
        return FrameworkVirtualFileSystem.getPath(facetPointer, elementType, elementName);
    }

    public String getElementName() {
        return this.myElementName;
    }

    public String getModuleName() {
        return this.myFacetPointer.getModuleName();
    }

    public String getFacetName() {
        return this.myFacetPointer.getFacetName();
    }

    @Nullable
    public T findFacet() {
        return (T)this.myFacetPointer.getFacet();
    }

    @NotNull
    public FrameworkVirtualFileSystem getFileSystem() {
        FrameworkVirtualFileSystem frameworkVirtualFileSystem = FrameworkVirtualFileSystem.getJ2EEInstance();
        if (frameworkVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl", "getFileSystem"));
        }
        return frameworkVirtualFileSystem;
    }

    public void setElementName(String elementName) {
        this.myElementName = elementName;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl", "contentsToByteArray"));
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @NotNull
    public String getName() {
        String string = this.getElementName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl", "getName"));
        }
        return string;
    }

    public boolean isValid() {
        Project project = this.getFileSystem().getProject(this.myProjectId);
        return project != null && !project.isDisposed();
    }

    protected abstract Icon getIcon();

    public static class MyPresentationProvider
    extends PresentationProvider<FrameworkElementAsVirtualFileImpl> {
        public Icon getIcon(FrameworkElementAsVirtualFileImpl o) {
            return o.getIcon();
        }
    }
}

