/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFileImpl;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeFacetNodeDescriptor<F extends JavaeeFacet>
extends JamNodeDescriptor<F> {
    public static final DataKey<JavaeeFacet> FACET_NODE_KEY = DataKey.create((String)"javaee.facet.context");
    private final F myFacet;

    protected JavaeeFacetNodeDescriptor(F facet, Object parameters) {
        super(facet.getModule().getProject(), null, parameters, facet);
        this.myFacet = facet;
    }

    protected JavaeeFacetNodeDescriptor(F facet, NodeDescriptor parentDescriptor, Object parameters) {
        super(facet.getModule().getProject(), parentDescriptor, parameters, facet);
        this.myFacet = facet;
    }

    public F getFacet() {
        return this.myFacet;
    }

    public String getNewTooltip() {
        F facet = this.getFacet();
        return facet.getType().getPresentableName();
    }

    public String getNewNodeText() {
        if (this.getFacet().isDisposed()) {
            return null;
        }
        return JavaeeUtil.getFacetWithModuleName(this.getFacet());
    }

    @Nullable
    protected final FacetAsVirtualFileImpl getVirtualFile() {
        return FacetAsVirtualFileImpl.fileByPath(this.getFacet());
    }

    public Object getData(String dataId) {
        if (FACET_NODE_KEY.is(dataId)) {
            return this.getFacet();
        }
        if ("context.Module".equals(dataId)) {
            return ((JavaeeFacet)this.getElement()).getModule();
        }
        if (DataConstants.VIRTUAL_FILE.equals(dataId)) {
            return this.getVirtualFile();
        }
        if (DataConstants.NAVIGATABLE.equals(dataId)) {
            return new OpenFileDescriptor(this.getProject(), (VirtualFile)this.getVirtualFile());
        }
        return null;
    }

    public DeleteProvider getDeleteProvider() {
        return null;
    }

    public boolean isValid() {
        return !((JavaeeFacet)this.getElement()).isDisposed() && !((JavaeeFacet)this.getElement()).getModule().isDisposed() && ((JavaeeFacetEx)this.getFacet()).getCommonPart().isAllDescriptorsValid();
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Nullable
    public Icon getNewIcon() {
        return this.getFacet().getType().getIcon();
    }
}

