/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.transport;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.transport.RemoteServerModelBase;
import com.intellij.javaee.oss.transport.RemoteServerModelDataBase;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportHostTarget;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.javaee.transport.local.LocalTransportService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;

public class RemoteServerModelDelegateBase<D extends RemoteServerModelDataBase, M extends RemoteServerModelBase>
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoteServerModelDelegateBase.class.getName()));
    @NonNls
    private static String WEB_DEPLOYMENT_PLUGIN_ID = "com.jetbrains.plugins.webDeployment";
    private String myTransportHostId;
    private M myParent;

    public String getTransportHostId() {
        return this.myTransportHostId;
    }

    public void setTransportHostId(String transportHostId) {
        this.myTransportHostId = transportHostId;
    }

    public RemoteServerModelDelegateBase init(M parent) {
        this.myParent = parent;
        return this;
    }

    protected final CommonModel getCommonModel() {
        return this.myParent.getCommonModel();
    }

    public void readFromData(D data) {
        this.myTransportHostId = ((RemoteServerModelDataBase)data).getTransportHostId();
    }

    public void writeToData(D data) {
        ((RemoteServerModelDataBase)data).setTransportHostId(this.myTransportHostId);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected final boolean isHostLocal() {
        return LocalTransportService.isHostLocal(this.getTransportHostId());
    }

    protected final String prepareDeployment(TransportTarget transportTarget, String stagingRemotePath, String sourcePath, boolean prepareNameOnly) throws RuntimeConfigurationException {
        if (this.isHostLocal()) {
            return sourcePath;
        }
        File sourceIOFile = new File(FileUtil.toSystemDependentName((String)sourcePath));
        if (!prepareNameOnly) {
            this.transferFileToTarget(transportTarget, LocalFileSystem.getInstance().refreshAndFindFileByPath(sourcePath));
        }
        String lastPathPart = sourceIOFile.getName();
        return FileUtil.toSystemIndependentName((String)(stagingRemotePath + "/" + lastPathPart));
    }

    protected final void checkBaseConfiguration() throws RuntimeConfigurationException {
        if (TransportManager.getInstance().getTypes().isEmpty()) {
            RuntimeConfigurationError warning = new RuntimeConfigurationError(JavaeeBundle.getText("RemoteServerModelDelegateBase.error.noHostTypesAvailable", new Object[0]));
            if (PluginManager.getDisabledPlugins().contains(WEB_DEPLOYMENT_PLUGIN_ID)) {
                warning.setQuickFix((Runnable)new EnableWebDeploymentQuickFix());
            }
            throw warning;
        }
        if (this.getTransportHostId() == null) {
            throw new RuntimeConfigurationError(JavaeeBundle.getText("RemoteServerModelDelegateBase.error.remoteStagingNotSpecified", new Object[0]));
        }
    }

    protected final void transferFileToTarget(TransportTarget transportTarget, VirtualFile sourceFile) throws RuntimeConfigurationException {
        new RemoteOperation(){

            @Override
            protected boolean doOperation(TransportHostTarget target, Project project, VirtualFile sourceFile) {
                return target.transfer(project, Collections.singletonList(sourceFile));
            }
        }.perform(transportTarget, sourceFile);
    }

    protected final void deleteFileFromTarget(TransportTarget transportTarget, VirtualFile sourceFile) throws RuntimeConfigurationException {
        new RemoteOperation(){

            @Override
            protected boolean doOperation(TransportHostTarget target, Project project, VirtualFile sourceFile) {
                return target.delete(project, Collections.singletonList(sourceFile));
            }
        }.perform(transportTarget, sourceFile);
    }

    private abstract class RemoteOperation {
        private RemoteOperation() {
        }

        public void perform(TransportTarget transportTarget, VirtualFile sourceFile) throws RuntimeConfigurationException {
            if (sourceFile == null) {
                throw new RuntimeConfigurationException(JavaeeBundle.getText("RemoteServerModelDelegateBase.error.fileNotFound", new Object[0]));
            }
            TransportHost host = TransportManager.getInstance().findHost(RemoteServerModelDelegateBase.this.getTransportHostId(), RemoteServerModelDelegateBase.this.getCommonModel().getProject());
            if (host == null) {
                throw new RuntimeConfigurationException(JavaeeBundle.getText("RemoteServerModelDelegateBase.error.hostNotFound", new Object[0]));
            }
            if (!this.doOperation(host.findOrCreateHostTarget(transportTarget), RemoteServerModelDelegateBase.this.getCommonModel().getProject(), sourceFile)) {
                throw new RuntimeConfigurationException(JavaeeBundle.getText("RemoteServerModelDelegateBase.error.transferInsuccessful", sourceFile.getPath()));
            }
        }

        protected abstract boolean doOperation(TransportHostTarget var1, Project var2, VirtualFile var3);
    }

    private static class EnableWebDeploymentQuickFix
    implements Runnable {
        private EnableWebDeploymentQuickFix() {
        }

        @Override
        public void run() {
            if (PluginManager.getDisabledPlugins().remove(WEB_DEPLOYMENT_PLUGIN_ID)) {
                try {
                    PluginManager.saveDisabledPlugins((Collection)PluginManager.getDisabledPlugins(), (boolean)false);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                PluginManagerConfigurable.shutdownOrRestartApp();
            }
        }
    }
}

