/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration.view;

import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.ide.browsers.StartBrowserPanel;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersUtil;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServersManagerAdapter;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.run.configuration.ApplicationServerSelectionListener;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.JavaeeRunConfigurationCommonSettingsBean;
import com.intellij.javaee.run.configuration.LogFilesProvider;
import com.intellij.javaee.run.configuration.view.JavaeeRunConfigurationEditorContext;
import com.intellij.javaee.run.execution.update.HotSwapClassesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.ReloadClassesAndResourcesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.serverInstances.ApplicationServersManagerListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class J2EERunCommonConfigurationEditor
extends SettingsEditor<CommonStrategy>
implements PanelWithAnchor {
    private JPanel myPanel;
    private JComboBox myApplicationServers;
    private JButton myConfigureApplicationServersButton;
    private LabeledComponent<RawCommandLineEditor> myVMParameters;
    private JComboBox myUpdatePolicyCombobox;
    private JComboBox myUpdateOnDeactivationComboBox;
    private JCheckBox myShowDialogOnUpdateCheckBox;
    private JPanel myUpdateSettingsPanel;
    private JPanel myApplicationServerPanel;
    private JBLabel myUpdateOnDeactivationLabel;
    private JBLabel myPerformOnUpdateActionLabel;
    private StartBrowserPanel myStartBrowserPanel;
    private JrePathEditor myJrePathEditor;
    private String myPreviousDefault = null;
    private final AppServerIntegration myIntegration;
    private ApplicationServersManagerAdapter myServersManagerListener;
    private final EventDispatcher<ApplicationServerSelectionListener> myServerSelectionDispatcher;
    private ApplicationServer myLastSelectedServer;
    private boolean myInsideAppServersListChange;
    private JComponent anchor;
    private final SortedComboBoxModel<String> myServersListModel;
    private boolean myInsideReset;

    public J2EERunCommonConfigurationEditor(CommonStrategy config, JavaeeRunConfigurationEditorContext editorContext) {
        this.$$$setupUI$$$();
        this.myIntegration = config.getIntegration();
        this.myServerSelectionDispatcher = EventDispatcher.create(ApplicationServerSelectionListener.class);
        ((RawCommandLineEditor)this.myVMParameters.getComponent()).setDialogCaption(J2EEBundle.message((String)"dialog.title.vm.parameters", (Object[])new Object[0]));
        this.myServersListModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.projectSdk((Project)config.getProject()));
        if (config.isApplicationServerNeeded()) {
            this.initApplicationServers();
        } else {
            this.myApplicationServerPanel.setVisible(false);
        }
        if (!config.isLocal()) {
            this.myVMParameters.setVisible(false);
        }
        if (!this.myIntegration.isJreCustomizable() && !config.isJavaPolicy() || !config.isLocal()) {
            this.myJrePathEditor.setVisible(false);
        }
        UpdatingRunningApplicationUtil.setupPolicyCombobox(this.myUpdatePolicyCombobox, config, false);
        UpdatingRunningApplicationUtil.setupPolicyCombobox(this.myUpdateOnDeactivationComboBox, config, true);
        editorContext.addDeploymentSettingsListener(new JavaeeRunConfigurationEditorContext.JavaeeDeploymentSettingsEditorListener(){

            @Override
            public void onDeploymentSettingsChanged(CommonModel snapshot) {
                J2EERunCommonConfigurationEditor.this.showOrHideUpdateOptions(snapshot);
                J2EERunCommonConfigurationEditor.this.updateStartupPage();
            }
        });
        this.showOrHideUpdateOptions(config);
    }

    private void showOrHideUpdateOptions(CommonModel commonModel) {
        boolean haveUpdateOptions = UpdatingRunningApplicationUtil.updatePolicyCombobox(this.myUpdatePolicyCombobox, commonModel, false);
        boolean haveUpdateOnDeactivation = UpdatingRunningApplicationUtil.updatePolicyCombobox(this.myUpdateOnDeactivationComboBox, commonModel, true);
        this.myUpdateSettingsPanel.setVisible(haveUpdateOptions);
        this.myUpdateOnDeactivationLabel.setVisible(haveUpdateOnDeactivation);
        this.myUpdateOnDeactivationComboBox.setVisible(haveUpdateOnDeactivation);
        this.settingAnchor();
    }

    private void settingAnchor() {
        JBLabel tempAnchor = null;
        if (this.anchor == null || this.anchor == this.myUpdateOnDeactivationLabel || this.anchor == this.myPerformOnUpdateActionLabel || this.anchor == this.myVMParameters.getLabel()) {
            if (this.myUpdateSettingsPanel.isVisible()) {
                tempAnchor = this.myUpdateOnDeactivationLabel.isVisible() ? this.myUpdateOnDeactivationLabel : this.myPerformOnUpdateActionLabel;
            } else if (this.myVMParameters.isVisible()) {
                tempAnchor = this.myVMParameters.getLabel();
            }
            this.setAnchor((JComponent)tempAnchor);
        }
    }

    private void initApplicationServers() {
        this.myApplicationServers.setRenderer(new ColoredListCellRendererWrapper<String>(){

            protected void doCustomize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                SimpleTextAttributes attributes = ApplicationServersManager.getInstance().findByName(value, J2EERunCommonConfigurationEditor.this.myIntegration) == null ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                this.append(StringUtil.notNullize((String)value), attributes);
            }
        });
        this.myApplicationServers.setModel(this.myServersListModel);
        this.myConfigureApplicationServersButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationServer newSelection;
                ApplicationServer selectedServer = J2EERunCommonConfigurationEditor.this.getSelectedServer();
                ApplicationServersManager serversManager = ApplicationServersManager.getInstance();
                if (selectedServer == null) {
                    ApplicationServersManager.ApplicationServersManagerModifiableModel modifiableModel = serversManager.createModifiableModel();
                    newSelection = ApplicationServersUtil.createNewApplicationServer(J2EERunCommonConfigurationEditor.this.myIntegration, modifiableModel, serversManager.getApplicationServers(new AppServerIntegration[]{J2EERunCommonConfigurationEditor.this.myIntegration}), J2EERunCommonConfigurationEditor.this.myPanel, J2EERunCommonConfigurationEditor.this.getSelectedServerName());
                    AccessToken token = WriteAction.start();
                    try {
                        modifiableModel.commit();
                    }
                    finally {
                        token.finish();
                    }
                } else {
                    newSelection = serversManager.editApplicationServers(J2EERunCommonConfigurationEditor.this.myPanel, J2EERunCommonConfigurationEditor.this.getIntegration(), selectedServer);
                }
                J2EERunCommonConfigurationEditor.this.fillApplicationServers(newSelection);
            }
        });
        this.myServersManagerListener = new ApplicationServersManagerAdapter(){

            @Override
            protected void serversListChanged() {
                J2EERunCommonConfigurationEditor.this.fillApplicationServers(null);
            }
        };
        ApplicationServersManager.getInstance().addServersListener((ApplicationServersManagerListener)this.myServersManagerListener);
        this.fillApplicationServers(null);
        this.myApplicationServers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!J2EERunCommonConfigurationEditor.this.myInsideAppServersListChange) {
                    J2EERunCommonConfigurationEditor.this.onServerChanged();
                }
            }
        });
        this.onServerChanged();
    }

    @Nullable
    private ApplicationServer getSelectedServer() {
        String item = this.getSelectedServerName();
        return ApplicationServersManager.getInstance().findByName(item, this.myIntegration);
    }

    private String getSelectedServerName() {
        return (String)this.myServersListModel.getSelectedItem();
    }

    private void onServerChanged() {
        ApplicationServer server = this.getSelectedServer();
        if (server != this.myLastSelectedServer) {
            ((ApplicationServerSelectionListener)this.myServerSelectionDispatcher.getMulticaster()).serverSelected(server);
            if (!this.myInsideReset) {
                this.updateStartupPage();
            }
        } else {
            ((ApplicationServerSelectionListener)this.myServerSelectionDispatcher.getMulticaster()).serverProbablyEdited(server);
        }
        this.myLastSelectedServer = server;
    }

    public void addServerSelectionListener(ApplicationServerSelectionListener listener) {
        this.myServerSelectionDispatcher.addListener((EventListener)listener);
    }

    public void removeServerSelectionListener(ApplicationServerSelectionListener listener) {
        this.myServerSelectionDispatcher.removeListener((EventListener)listener);
    }

    private AppServerIntegration getIntegration() {
        return this.myIntegration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillApplicationServers(@Nullable ApplicationServer newSelection) {
        try {
            this.myInsideAppServersListChange = true;
            String selectedItem = this.getSelectedServerName();
            LinkedHashSet<String> allItems = new LinkedHashSet<String>();
            for (ApplicationServer applicationServer : ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{this.getIntegration()})) {
                allItems.add(applicationServer.getName());
            }
            if (selectedItem != null) {
                allItems.add(selectedItem);
            }
            this.myServersListModel.setAll(allItems);
            if (newSelection != null) {
                this.myApplicationServers.setSelectedItem(newSelection.getName());
            } else {
                this.myApplicationServers.setSelectedItem(selectedItem);
            }
        }
        finally {
            this.myInsideAppServersListChange = false;
        }
        this.onServerChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditorFrom(CommonStrategy configuration) {
        this.myInsideReset = true;
        try {
            String serverName = configuration.getApplicationServerName();
            if (serverName != null && !this.myServersListModel.getItems().contains(serverName)) {
                this.myServersListModel.add((Object)serverName);
            }
            this.myApplicationServers.setSelectedItem(serverName);
            JavaeeRunConfigurationCommonSettingsBean settingsBean = configuration.getSettingsBean();
            this.myStartBrowserPanel.setSelected(settingsBean.OPEN_IN_BROWSER);
            this.myStartBrowserPanel.getStartJavaScriptDebuggerCheckBox().setSelected(settingsBean.START_JAVASCRIPT_DEBUGGER);
            this.updateStartupPage(configuration);
            ((RawCommandLineEditor)this.myVMParameters.getComponent()).setText(settingsBean.COMMON_VM_ARGUMENTS);
            this.myStartBrowserPanel.getBrowserSelector().setSelected(WebBrowserManager.getInstance().findBrowserById(settingsBean.BROWSER_ID));
            this.myShowDialogOnUpdateCheckBox.setSelected(settingsBean.SHOW_DIALOG_ON_UPDATE);
            this.myUpdatePolicyCombobox.setSelectedItem(UpdatingRunningApplicationUtil.findPolicy(settingsBean.UPDATING_POLICY));
            this.myUpdateOnDeactivationComboBox.setSelectedItem(CommonStrategy.getUpdateOnFrameDeactivationPolicy(settingsBean));
            this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJreEnabled());
            this.showOrHideUpdateOptions(configuration);
        }
        finally {
            this.myInsideReset = false;
        }
    }

    private void updateStartupPage() {
        try {
            this.updateStartupPage((CommonStrategy)((Object)this.getSnapshot()));
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private void updateStartupPage(CommonStrategy commonStrategy) {
        String url = commonStrategy.getUrlToOpenInBrowser();
        String newDefaultUrl = commonStrategy.getDefaultUrlForBrowser();
        this.myStartBrowserPanel.setUrl(this.getStartupPage(url, newDefaultUrl));
        this.myPreviousDefault = newDefaultUrl;
    }

    private String getStartupPage(String url, String newDefaultUrl) {
        if (url.equals(newDefaultUrl) || this.myPreviousDefault == null || this.myPreviousDefault.equals(newDefaultUrl)) {
            return url;
        }
        if (url.trim().length() == 0) {
            return newDefaultUrl;
        }
        try {
            String file;
            int port;
            String host;
            String protocol;
            URL parsedPreviousDefaultUrl = new URL(this.myPreviousDefault);
            if (StringUtil.startsWithChar((CharSequence)url, (char)'/')) {
                if (url.equals(parsedPreviousDefaultUrl.getFile())) {
                    return newDefaultUrl;
                }
                URL parsedNewDefaultUrl = new URL(newDefaultUrl);
                protocol = parsedNewDefaultUrl.getProtocol();
                host = parsedNewDefaultUrl.getHost();
                port = parsedNewDefaultUrl.getPort();
                file = url;
            } else {
                URL parsedUrl = new URL(url);
                URL parsedNewDefaultUrl = new URL(newDefaultUrl);
                UrlPartUpdater urlPartUpdater = new UrlPartUpdater(parsedUrl, parsedNewDefaultUrl, parsedPreviousDefaultUrl);
                protocol = parsedUrl.getProtocol();
                host = urlPartUpdater.getUpdatedPart(new UrlPartGetter<String>(){

                    @Override
                    public String getPart(URL url) {
                        return url.getHost();
                    }
                });
                port = urlPartUpdater.getUpdatedPart(new UrlPartGetter<Integer>(){

                    @Override
                    public Integer getPart(URL url) {
                        return url.getPort();
                    }
                });
                file = urlPartUpdater.getUpdatedPart(new UrlPartGetter<String>(){

                    @Override
                    public String getPart(URL url) {
                        return url.getFile();
                    }
                });
            }
            return new URL(protocol, host, port, file).toString();
        }
        catch (MalformedURLException ignored) {
            return url;
        }
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/configuration/view/J2EERunCommonConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public void applyEditorTo(CommonStrategy configuration) throws ConfigurationException {
        LogFilesProvider logProvider;
        boolean forceDefaultLogsChanged = false;
        ApplicationServer selectedServer = this.getSelectedServer();
        if (configuration.getApplicationServer() != selectedServer) {
            forceDefaultLogsChanged = true;
        }
        if (selectedServer != null) {
            configuration.setApplicationServer(selectedServer);
        } else {
            configuration.setApplicationServerName(this.getSelectedServerName());
        }
        configuration.setAlternativeJreEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        JavaeeRunConfigurationCommonSettingsBean settingsBean = configuration.getSettingsBean();
        settingsBean.OPEN_IN_BROWSER = this.myStartBrowserPanel.isSelected();
        configuration.setUrlToOpenInBrowser(this.myStartBrowserPanel.getUrl());
        settingsBean.START_JAVASCRIPT_DEBUGGER = this.myStartBrowserPanel.getStartJavaScriptDebuggerCheckBox().isSelected();
        settingsBean.COMMON_VM_ARGUMENTS = ((RawCommandLineEditor)this.myVMParameters.getComponent()).getTextField().getText();
        settingsBean.BROWSER_ID = this.myStartBrowserPanel.getBrowserSelector().getSelectedBrowserId();
        UpdatingPolicy selectedPolicy = (UpdatingPolicy)this.myUpdatePolicyCombobox.getSelectedItem();
        if (selectedPolicy != null) {
            settingsBean.UPDATING_POLICY = selectedPolicy.getId();
        }
        settingsBean.SHOW_DIALOG_ON_UPDATE = this.myShowDialogOnUpdateCheckBox.isSelected();
        UpdatingPolicy onDeactivation = (UpdatingPolicy)this.myUpdateOnDeactivationComboBox.getSelectedItem();
        settingsBean.UPDATE_ON_FRAME_DEACTIVATION = onDeactivation != null;
        settingsBean.UPDATE_CLASSES_ON_FRAME_DEACTIVATION = onDeactivation == ReloadClassesAndResourcesUpdatingPolicy.getInstance();
        boolean bl = settingsBean.HOT_SWAP_CLASSES_ON_FRAME_DEACTIVATION = onDeactivation == HotSwapClassesUpdatingPolicy.getInstance();
        if (forceDefaultLogsChanged && (logProvider = configuration.getLogProvider()) != null) {
            logProvider.fireDefaultLogsChanged();
        }
    }

    public void disposeEditor() {
        if (this.myServersManagerListener != null) {
            ApplicationServersManager.getInstance().removeServersListener((ApplicationServersManagerListener)this.myServersManagerListener);
        }
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myVMParameters.setAnchor(null);
        this.myPerformOnUpdateActionLabel.setAnchor(null);
        this.myUpdateOnDeactivationLabel.setAnchor(null);
        this.myVMParameters.setAnchor(anchor);
        this.myPerformOnUpdateActionLabel.setAnchor(anchor);
        this.myUpdateOnDeactivationLabel.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JrePathEditor jrePathEditor;
        StartBrowserPanel startBrowserPanel;
        JComboBox jComboBox;
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JComboBox jComboBox2;
        JBLabel jBLabel2;
        JPanel jPanel;
        LabeledComponent labeledComponent;
        JButton jButton;
        JComboBox jComboBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myApplicationServerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.run.configuration.properties.application.server"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplicationServers = jComboBox3 = new JComboBox();
        jPanel2.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigureApplicationServersButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/J2EEBundle").getString("button.configure.acclication.server"));
        jButton.setActionCommand(ResourceBundle.getBundle("messages/J2EEBundle").getString("button.configure.application.server"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myVMParameters = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("run.configuration.java.vm.parameters.label"));
        labeledComponent.setLabelLocation("West");
        jPanel3.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, new Dimension(0, -1), new Dimension(400, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUpdateSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 5, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPerformOnUpdateActionLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("On 'Update' action:");
        jBLabel2.setDisplayedMnemonic('U');
        jBLabel2.setDisplayedMnemonicIndex(4);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUpdatePolicyCombobox = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myShowDialogOnUpdateCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show dialog");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUpdateOnDeactivationLabel = jBLabel = new JBLabel();
        jBLabel.setText("On frame deactivation:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUpdateOnDeactivationComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myStartBrowserPanel = startBrowserPanel = new StartBrowserPanel();
        JComponent jComponent = startBrowserPanel.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel3.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jComboBox3);
        jBLabel2.setLabelFor(jComboBox2);
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static interface UrlPartGetter<T> {
        public T getPart(URL var1);
    }

    private static class UrlPartUpdater {
        private final URL myUrl;
        private final URL myNewDefaultUrl;
        private final URL myPreviousDefaultUrl;

        public UrlPartUpdater(URL url, URL newDefaultUrl, URL previousDefaultUrl) {
            this.myUrl = url;
            this.myNewDefaultUrl = newDefaultUrl;
            this.myPreviousDefaultUrl = previousDefaultUrl;
        }

        public <T> T getUpdatedPart(UrlPartGetter<T> getter) {
            T previousDefaultUrlPart;
            T urlPart = getter.getPart(this.myUrl);
            return urlPart.equals(previousDefaultUrlPart = getter.getPart(this.myPreviousDefaultUrl)) ? getter.getPart(this.myNewDefaultUrl) : urlPart;
        }
    }
}

