/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.tree.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.toolwindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.javaee.toolwindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationTypeNode
extends PsiMemberSimpleNode {
    protected Module myModule;
    protected PsiClass myAnnoClass;

    public AnnotationTypeNode(@NotNull Module module, @NotNull PsiClass annoClass, SimpleNode parent) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/toolwindow/tree/nodes/AnnotationTypeNode", "<init>"));
        }
        if (annoClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoClass", "com/intellij/javaee/toolwindow/tree/nodes/AnnotationTypeNode", "<init>"));
        }
        super(parent, annoClass);
        this.myModule = module;
        this.myAnnoClass = annoClass;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        if (!this.myAnnoClass.isValid()) {
            return;
        }
        presentation.addText(new PresentableNodeDescriptor.ColoredFragment(this.myAnnoClass.getName(), this.myAnnoClass.getQualifiedName(), this.getPlainAttributes()));
        presentation.setIcon(PlatformIcons.ANNOTATION_TYPE_ICON);
    }

    public SimpleNode[] getChildren() {
        Collection<PsiMemberSimpleNode> children = AnnotationTypeNode.createSortedList();
        if (this.myAnnoClass.isValid()) {
            for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)this.myAnnoClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule)).findAll()) {
                children.add(new AnnotatedMembersNode<PsiMember>(this.myModule, psiMember, this));
            }
        }
        return children.toArray(new SimpleNode[children.size()]);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myAnnoClass, this.myModule};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/toolwindow/tree/nodes/AnnotationTypeNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    protected List<PsiClass> findAnnotatedClasses() {
        return this.findAnnotatedMembers(PsiClass.class);
    }

    protected List<PsiMethod> findAnnotatedMethods() {
        return this.findAnnotatedMembers(PsiMethod.class);
    }

    protected <T extends PsiModifierListOwner> List<T> findAnnotatedMembers(Class<T> clazz) {
        ArrayList result = ContainerUtil.newArrayList();
        Processor processor = t -> {
            ContainerUtil.addIfNotNull((Collection)result, (Object)t);
            return true;
        };
        JamCommonUtil.findAnnotatedElements(clazz, (String)this.myAnnoClass.getQualifiedName(), (PsiManager)PsiManager.getInstance((Project)this.myModule.getProject()), (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule), (Processor)processor);
        return result;
    }
}

