/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.javaee.model.common.persistence.mapping.RelationAttributeBase;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaVersion;
import com.intellij.jpa.RelationshipEditorDialog;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.persistence.diagram.DefaultDiagramSupport;
import com.intellij.persistence.diagram.PersistenceDiagram;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.psi.PsiNameHelper;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;

public class JpaDiagramSupport
extends DefaultDiagramSupport {
    public JpaDiagramSupport(PersistenceFacet facet) {
        super(facet);
    }

    protected boolean getData(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram, DataKey key, DataSink sink) {
        if (super.getData(diagram, key, sink)) {
            return true;
        }
        if (PlatformDataKeys.HELP_ID.equals(key)) {
            sink.put(PlatformDataKeys.HELP_ID, (Object)"reference.persistencediagram");
            return true;
        }
        return false;
    }

    public Icon getAttributeIcon(PersistentAttribute persistentAttribute, boolean forceId) {
        if (forceId) {
            return JpaAttributeType.ID.getIcon();
        }
        return super.getAttributeIcon(persistentAttribute, forceId);
    }

    public boolean processEditEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram) {
        RelationshipEditorDialog dialog;
        PersistentAttribute selectedAttribute = (PersistentAttribute)persistenceDiagram.getSelectedAttribute();
        if (selectedAttribute instanceof RelationAttributeBase && this.getModelBrowser().queryTargetPersistentObjects((PersistentRelationshipAttribute)((RelationAttributeBase)selectedAttribute)).findFirst() != null && (dialog = new RelationshipEditorDialog(persistenceDiagram.getProject(), (PersistentRelationshipAttribute)((RelationAttributeBase)selectedAttribute))).isOkToShow()) {
            dialog.show();
            return true;
        }
        return false;
    }

    public void processCreateEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram, PersistentObject sourceEntity, PersistentObject targetEntity) {
        boolean jpa2OrGt;
        PersistenceFacet facet = this.getFacet();
        boolean bl = jpa2OrGt = facet instanceof JpaFacet && JpaUtil.getJpaVersion((JpaFacet)facet).compareTo(JpaVersion.JPA_2_0) >= 0;
        if (targetEntity instanceof PersistentEntity) {
            if (sourceEntity instanceof PersistentEntityBase || jpa2OrGt) {
                RelationshipEditorDialog dialog = new RelationshipEditorDialog(persistenceDiagram.getProject(), sourceEntity, targetEntity);
                dialog.show();
            }
        } else if (targetEntity instanceof PersistentEmbeddable && (sourceEntity instanceof PersistentEntityBase || jpa2OrGt)) {
            JpaDiagramSupport.createEmbeddedAttribute(sourceEntity, (PersistentEmbeddable)targetEntity);
        }
    }

    private static void createEmbeddedAttribute(PersistentObject entity, PersistentEmbeddable embeddable) {
        Project project = entity.getPsiManager().getProject();
        final PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        THashSet existingNames = new THashSet((Collection)ContainerUtil.mapNotNull((Collection)entity.getObjectModelHelper().getAttributes(), (Function)new NullableFunction<PersistentAttribute, String>(){

            public String fun(PersistentAttribute attributeBase) {
                return (String)attributeBase.getName().getValue();
            }
        }));
        String attributeName = Messages.showInputDialog((Project)project, (String)JpaMessages.message((String)"dialog.embedded.attribute.label", (Object[])new Object[0]), (String)JpaMessages.message((String)"dialog.embedded.title.create", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator((Set)existingNames){
            final /* synthetic */ Set val$existingNames;
            {
                this.val$existingNames = set;
            }

            public boolean checkInput(String inputString) {
                return JpaUtil.isAttributeName(nameHelper, inputString) && !this.val$existingNames.contains(inputString);
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (attributeName != null) {
            RelationshipEditorDialog.createEmbeddableAttribute(entity, attributeName, embeddable);
        }
    }
}

