/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ide.DataManager;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.UnitSettingMapConfigurable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignDataSourcesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/actions/AssignDataSourcesAction", "update"));
        }
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
        boolean enabled = facet != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/actions/AssignDataSourcesAction", "actionPerformed"));
        }
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
        if (facet == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)facet.getModule().getProject()).commitAllDocuments();
        AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet);
    }

    public static void showUnitDataSourceMappingDialog(@NotNull PersistenceFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/jpa/actions/AssignDataSourcesAction", "showUnitDataSourceMappingDialog"));
        }
        ShowSettingsUtil.getInstance().editConfigurable(facet.getModule().getProject(), (Configurable)new MyComponent(facet));
    }

    private static class MyComponent
    extends UnitSettingMapConfigurable<PersistenceFacet, DatabaseSystem>
    implements DataProvider {
        private final DbPsiFacade myManager;
        private final DatabaseSystem myMissingValue = new LocalDataSource("<missing>", null, null, null, null);

        public MyComponent(PersistenceFacet facet) {
            super(facet);
            this.myManager = DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
            DataManager.registerDataProvider((JComponent)this.getComponent(), (DataProvider)this);
        }

        public void apply() throws ConfigurationException {
            super.apply();
            Project project = this.myFacet.getModule().getProject();
            DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        protected void configureValueEditorCombo(ComboBox comboBox) {
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
            DbUIUtil.configureDataSourceComboBox((JComboBox)comboBox, (Iterable)facade.getDataSources(), (boolean)true);
        }

        @NotNull
        protected String getValueColumnName() {
            if ("Data Source" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent", "getValueColumnName"));
            }
            return "Data Source";
        }

        protected void customizeValueRenderer(ComboBox renderer, DatabaseSystem value) {
            if (value == this.myMissingValue) {
                renderer.setForeground((Color)JBColor.RED);
            }
        }

        @Nullable
        protected DatabaseSystem getSettingValue(PersistencePackage unit) {
            String id = this.myFacet.getDataSourceId(unit);
            DbDataSource result = this.myManager.findDataSource(id);
            return result == null && id != null ? this.myMissingValue : result;
        }

        protected void setSettingValue(PersistencePackage unit, DatabaseSystem value) {
            this.myFacet.setDataSourceId(unit, value instanceof DbDataSource ? value.getUniqueId() : null);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                DatabaseSystem value = (DatabaseSystem)this.getSelectedValue();
                return ObjectUtils.tryCast((Object)value, DbDataSource.class);
            }
            if (DatabaseDataKeys.DB_PSI_FACADE.is(dataId)) {
                return this.myManager;
            }
            return null;
        }

        @Nls
        public String getDisplayName() {
            return JpaHighlightingMessages.message("fix.edit.unit.datasource.name", new Object[0]);
        }

        @Nullable
        public String getHelpTopic() {
            return null;
        }
    }
}

