/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.Nullable;

public abstract class JpaModelValidatorBase
implements ModelValidator {
    protected PersistenceModelBrowser myBrowser;

    public JpaModelValidatorBase(PersistenceModelBrowser browser) {
        this.myBrowser = browser;
    }

    @Nullable
    public String getAttributeTypeProblem(PersistentAttributeType type, JavaTypeInfo typeInfo, boolean isLob) {
        boolean acceptsSingle = type.accepts(PersistentAttributeType.AttributeComponent.SINGLE, PersistentAttributeType.ComponentType.ANY);
        if (typeInfo.containerType == null || isLob || typeInfo.containerType == JavaContainerType.ARRAY && acceptsSingle) {
            if (!acceptsSingle) {
                return JpaHighlightingMessages.message("attribute.should.be.collection", type.getTypeName());
            }
            return this.getComponentTypeProblem(type, PersistentAttributeType.AttributeComponent.SINGLE, typeInfo.baseType, isLob);
        }
        if (typeInfo.containerType == JavaContainerType.MAP) {
            String keyProblem;
            String valueProblem;
            if (!type.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY, PersistentAttributeType.ComponentType.ANY)) {
                return JpaHighlightingMessages.message("attribute.should.not.be.map", type.getTypeName());
            }
            String containerProblem = this.getContainerTypeProblem(type, typeInfo);
            if (containerProblem != null) {
                return containerProblem;
            }
            String string = valueProblem = typeInfo.parameters.length == 0 ? null : this.getComponentTypeProblem(type, PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, typeInfo.parameters[0], false);
            if (valueProblem != null) {
                return valueProblem;
            }
            String string2 = keyProblem = typeInfo.parameters.length == 1 ? null : this.getComponentTypeProblem(type, PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY, typeInfo.parameters[1], false);
            if (keyProblem != null) {
                return keyProblem;
            }
        } else {
            if (!type.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY)) {
                return JpaHighlightingMessages.message("attribute.should.not.be.collection", type.getTypeName());
            }
            String containerProblem = this.getContainerTypeProblem(type, typeInfo);
            if (containerProblem != null) {
                return containerProblem;
            }
            return typeInfo.parameters.length == 0 ? null : this.getComponentTypeProblem(type, PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, typeInfo.parameters[0], false);
        }
        return null;
    }

    @Nullable
    protected String getContainerTypeProblem(PersistentAttributeType type, JavaTypeInfo typeInfo) {
        return null;
    }

    @Nullable
    protected String getComponentTypeProblem(PersistentAttributeType type, PersistentAttributeType.AttributeComponent component, PsiType psiType, boolean isLob) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        PersistenceClassRole[] roles = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
        if (roles.length > 0) {
            boolean accepted = false;
            for (PersistenceClassRole role : roles) {
                if (!this.myBrowser.acceptsRole(role)) continue;
                boolean bl = accepted = role.getType() == PersistenceClassRoleEnum.EMBEDDABLE && type.accepts(component, PersistentAttributeType.ComponentType.EMBEDDABLE) || role.getType() == PersistenceClassRoleEnum.ENTITY && type.accepts(component, PersistentAttributeType.ComponentType.ENTITY);
                if (accepted) break;
            }
            if (!accepted) {
                return JpaHighlightingMessages.message("attribute.0.component.1.should.not.be.2", type.getTypeName(), this.getComponentDisplayName(component), roles[0].getTitle());
            }
        } else if (psiType == null || !type.accepts(component, PersistentAttributeType.ComponentType.BASIC) || !JpaUtil.isBasicPersistentAttributeType(psiType, isLob)) {
            return JpaHighlightingMessages.message("attribute.0.component.1.should.not.be.2", type.getTypeName(), this.getComponentDisplayName(component), psiType == null ? "null" : psiType.getPresentableText());
        }
        return null;
    }

    protected boolean doesAttributeReferenceMappedClasses(JavaTypeInfo typeInfo) {
        if (typeInfo.containerType == null && this.myBrowser.queryPersistentObjects(PsiTypesUtil.getPsiClass((PsiType)typeInfo.baseType)).findFirst() != null) {
            return true;
        }
        for (PsiType parameter : typeInfo.parameters) {
            if (this.myBrowser.queryPersistentObjects(PsiTypesUtil.getPsiClass((PsiType)parameter)).findFirst() == null) continue;
            return true;
        }
        return false;
    }

    protected String getComponentDisplayName(PersistentAttributeType.AttributeComponent component) {
        switch (component) {
            case SINGLE: {
                return "";
            }
            case COLLECTION_VALUE: {
                return "value ";
            }
            case COLLECTION_VALUE_KEY: {
                return "key ";
            }
        }
        throw new AssertionError(component);
    }

    public String getRelationshipProblem(PersistentRelationshipAttribute source, PersistentRelationshipAttribute target) {
        RelationshipType targetType;
        RelationshipType sourceType = source.getAttributeModelHelper().getRelationshipType();
        if (sourceType.corresponds(targetType = target.getAttributeModelHelper().getRelationshipType())) {
            return null;
        }
        String targetAttributeTypeName = AttributeType.getAttributeType((PersistentAttribute)target).getTypeName();
        String sourceAttributeTypeName = AttributeType.getAttributeType((PersistentAttribute)source).getTypeName();
        return JpaHighlightingMessages.message("attribute.opposite.type.incorrect", sourceAttributeTypeName, targetAttributeTypeName, target.getName().getValue());
    }
}

