/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.JamClassAttributeElement;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentCollectionAttribute;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaAttributeTypeInspection
extends AbstractJpaInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.jpa.attribute.type", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaAttributeTypeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JpaAttributeTypeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaAttributeTypeInspection", "getShortName"));
        }
        return "JpaAttributeTypeInspection";
    }

    @Override
    protected void checkClass(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        PersistentObject object = role.getPersistentObject();
        if (object != null) {
            JpaAttributeTypeInspection.checkIdClassAnnotation(holder, object);
            JpaAttributeTypeInspection.checkObjectMembers(aClass, object, role, holder);
        }
    }

    private static void checkIdClassAnnotation(ProblemsHolder holder, PersistentObject object) {
        GenericValue value;
        JamClassAttributeElement element;
        if (object instanceof PersistentEntityBase && (element = (JamClassAttributeElement)ModelMergerUtil.getImplementation((Object)(value = ((PersistentEntityBase)object).getIdClassValue()), JamClassAttributeElement.class)) != null) {
            JpaInspectionUtil.checkClassExtends(element.getValue(), "java.io.Serializable", true, JpaAttributeTypeInspection.getGenericValueAnchor(element), holder);
        }
    }

    private static void checkObjectMembers(PsiClass aClass, PersistentObject object, PersistenceClassRole role, ProblemsHolder holder) {
        Processor processor = psiMember -> {
            JpaAttributeTypeInspection.checkObjectMember(psiMember, object, role, holder);
            return true;
        };
        ContainerUtil.process(Arrays.asList(aClass.getFields()), (Processor)processor);
        ContainerUtil.process(Arrays.asList(aClass.getMethods()), (Processor)processor);
    }

    private static void checkObjectMember(PsiMember member, PersistentObject object, PersistenceClassRole role, ProblemsHolder holder) {
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
        List attributes = browser.getPersistenceAttributes(object, member);
        ModelValidator validator = role.getFacet().getModelValidator(role.getPersistenceUnit());
        for (PersistentAttribute attribute : attributes) {
            JpaAttributeTypeInspection.checkAttributeJavaType(member, attribute, validator, browser, holder);
        }
    }

    private static void checkAttributeJavaType(PsiMember psiMember, PersistentAttribute attribute, ModelValidator validator, PersistenceModelBrowser browser, ProblemsHolder holder) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"org.hibernate.annotations.Type", (boolean)false)) {
            return;
        }
        AttributeType attributeType = AttributeType.getAttributeType((PersistentAttribute)attribute);
        PsiType type = PropertyUtil.getPropertyType((PsiMember)psiMember);
        PsiTypeElement propertyTypeElement = PropertyUtil.getPropertyTypeElement((PsiMember)psiMember);
        PsiIdentifier propertyIdentifier = PropertyUtil.getPropertyNameIdentifier((PsiMember)psiMember);
        if (propertyIdentifier == null) {
            return;
        }
        JavaTypeInfo typeInfo = JpaAttributeTypeInspection.checkTypeAnnotationsAndSubstitute(psiMember, type, attributeType, attribute, browser, holder);
        if (typeInfo != null) {
            boolean isLob = attribute.getAttributeModelHelper().isLob();
            String errorMessage = validator.getAttributeTypeProblem(typeInfo, (PersistentAttributeType)attributeType, isLob);
            if (errorMessage != null) {
                JpaAttributeTypeInspection.registerProblem(holder, (PsiElement)(propertyTypeElement == null ? propertyIdentifier : propertyTypeElement), errorMessage);
            } else if (attribute instanceof PersistentRelationshipAttribute) {
                PersistentRelationshipAttribute relationAttribute = (PersistentRelationshipAttribute)attribute;
                browser.queryTheOtherSideAttributes(relationAttribute, false).forEach(targetAttribute -> {
                    String message = validator.getRelationshipProblem(relationAttribute, targetAttribute);
                    if (message != null) {
                        JpaAttributeTypeInspection.registerProblem(holder, (PsiElement)propertyIdentifier, message);
                        return false;
                    }
                    return true;
                });
            } else if (attribute.getAttributeModelHelper().isIdAttribute()) {
                JpaInspectionUtil.checkClassExtends(PsiTypesUtil.getPsiClass((PsiType)type), "java.io.Serializable", true, (PsiElement)propertyTypeElement, holder);
            }
        }
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @Nullable PsiElement element, @NotNull String message) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jpa/inspections/JpaAttributeTypeInspection", "registerProblem"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/jpa/inspections/JpaAttributeTypeInspection", "registerProblem"));
        }
        if (element != null && element.isValid() && element.isPhysical()) {
            holder.registerProblem(element, message, new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static JavaTypeInfo checkTypeAnnotationsAndSubstitute(PsiMember psiMember, PsiType type, AttributeType attributeType, PersistentAttribute attribute, PersistenceModelBrowser browser, ProblemsHolder holder) {
        PsiClassType boxedType;
        PsiClass targetClass;
        GenericValue typeValue;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiMember.getProject());
        JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)type);
        PsiClassType mapKeyType = null;
        GenericValue mapKeyClassValue = attribute.getAttributeModelHelper().getMapKeyClass();
        PsiClass mapKeyClass = (PsiClass)mapKeyClassValue.getValue();
        if (mapKeyClass != null && !(mapKeyClass instanceof PsiTypeParameter)) {
            if (!JpaAttributeTypeInspection.checkContainerComponentType(typeInfo, mapKeyClassValue, mapKeyClass, PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY, holder)) {
                return null;
            }
            mapKeyType = elementFactory.createType(mapKeyClass);
        }
        PsiType targetType = null;
        if (attribute instanceof PersistentRelationshipAttribute) {
            PersistentRelationshipAttribute relationshipAttribute = (PersistentRelationshipAttribute)attribute;
            GenericValue targetClassValue = relationshipAttribute.getTargetEntityClass();
            PsiClass targetClass2 = (PsiClass)targetClassValue.getValue();
            if (targetClass2 != null) {
                PsiType psiType;
                GenericValue mapKeyValue;
                PersistentAttribute keyAttr;
                PsiElement anchor;
                targetType = elementFactory.createType(targetClass2);
                if (!JpaAttributeTypeInspection.checkContainerComponentType(typeInfo, targetClassValue, targetClass2, JavaContainerType.isCollectionOrMap((JavaContainerType)typeInfo.containerType) ? PersistentAttributeType.AttributeComponent.COLLECTION_VALUE : PersistentAttributeType.AttributeComponent.SINGLE, holder)) {
                    return null;
                }
                PersistentObject persistentObject = (PersistentObject)browser.queryPersistentObjects(targetClass2, PersistenceClassRoleEnum.ENTITY).findFirst();
                if (persistentObject == null && (anchor = JpaAttributeTypeInspection.getGenericValueAnchor(targetClassValue)) != null) {
                    holder.registerProblem(anchor, JpaHighlightingMessages.message("attribute.should.be.entity", attributeType.getTypeName()), new LocalQuickFix[0]);
                }
                Object object = (keyAttr = (PersistentAttribute)(mapKeyValue = relationshipAttribute.getAttributeModelHelper().getMapKey()).getValue()) != null ? keyAttr.getPsiType() : (psiType = persistentObject instanceof PersistentEntityBase && mapKeyValue instanceof JamAttributeElement && ((JamAttributeElement)mapKeyValue).getPsiElement() == null && ((JamAttributeElement)mapKeyValue).getParentAnnotationElement().getPsiElement() != null ? PersistenceCommonUtil.getPrimaryKeyClass((PersistentEntityBase)((PersistentEntityBase)persistentObject), (PersistenceModelBrowser)browser) : null);
                if (psiType != null) {
                    if (!JpaAttributeTypeInspection.checkContainerComponentType(typeInfo, mapKeyValue, PsiTypesUtil.getPsiClass((PsiType)psiType), PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY, holder)) {
                        return null;
                    }
                    mapKeyType = psiType;
                }
                if (mapKeyValue instanceof JamAttributeElement && ((JamAttributeElement)mapKeyValue).getPsiElement() != null) {
                    JpaAttributeTypeInspection.registerAnnotationProblem(mapKeyClassValue, JpaHighlightingMessages.message("attribute.mapkeyclass.with.mapkey.conflict", new Object[0]), holder);
                }
            }
        } else if (attribute instanceof PersistentCollectionAttribute && (targetType = (PsiType)(typeValue = ((PersistentCollectionAttribute)attribute).getComponentType()).getValue()) != null && (targetClass = targetType instanceof PsiPrimitiveType ? ((boxedType = ((PsiPrimitiveType)targetType).getBoxedType((PsiElement)psiMember)) == null ? null : boxedType.resolve()) : PsiTypesUtil.getPsiClass((PsiType)targetType)) != null && !JpaAttributeTypeInspection.checkContainerComponentType(typeInfo, typeValue, targetClass, JavaContainerType.isCollectionOrMap((JavaContainerType)typeInfo.containerType) ? PersistentAttributeType.AttributeComponent.COLLECTION_VALUE : PersistentAttributeType.AttributeComponent.SINGLE, holder)) {
            return null;
        }
        if (mapKeyType != null || targetType != null) {
            if (mapKeyType != null && typeInfo.containerType == JavaContainerType.MAP && typeInfo.parameters.length > 1) {
                typeInfo.parameters[1] = mapKeyType;
            }
            if (targetType != null) {
                if (JavaContainerType.isCollectionOrMap((JavaContainerType)typeInfo.containerType) && typeInfo.parameters.length > 0) {
                    typeInfo.parameters[0] = targetType;
                } else {
                    typeInfo = new JavaTypeInfo(typeInfo.containerType, targetType, new PsiType[0]);
                }
            }
        }
        return typeInfo;
    }

    private static boolean checkContainerComponentType(JavaTypeInfo typeInfo, GenericValue<?> value, PsiClass valueClass, PersistentAttributeType.AttributeComponent component, ProblemsHolder holder) {
        PsiElement anchor;
        if (component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY && typeInfo.containerType != JavaContainerType.MAP || component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE && typeInfo.containerType == null) {
            JpaAttributeTypeInspection.registerAnnotationProblem(value, JpaHighlightingMessages.message("attribute.with.wrong.collection.type", new Object[0]), holder);
            return false;
        }
        PsiClass realClass = PsiTypesUtil.getPsiClass((PsiType)(component == PersistentAttributeType.AttributeComponent.SINGLE ? typeInfo.baseType : typeInfo.parameters[PersistentAttributeType.AttributeComponent.COLLECTION_VALUE == component ? 0 : 1]));
        if (!(realClass == null || valueClass == null || realClass instanceof PsiTypeParameter || realClass.getManager().areElementsEquivalent((PsiElement)realClass, (PsiElement)valueClass) || valueClass.isInheritor(realClass, true) || (anchor = JpaAttributeTypeInspection.getGenericValueAnchor(value)) == null)) {
            holder.registerProblem(anchor, JpaHighlightingMessages.message("attribute.types.should.be.compatible", valueClass.getQualifiedName(), realClass.getQualifiedName()), new LocalQuickFix[0]);
        }
        return true;
    }

    private static boolean registerAnnotationProblem(GenericValue<?> value, String errorMessage, ProblemsHolder holder) {
        PsiAnnotation annotation;
        if (value instanceof JamClassAttributeElement && (annotation = (PsiAnnotation)((JamClassAttributeElement)value).getParentAnnotationElement().getPsiElement()) != null) {
            holder.registerProblem((PsiElement)annotation.getNameReferenceElement(), errorMessage, new LocalQuickFix[0]);
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getGenericValueAnchor(GenericValue<?> value) {
        JamAttributeElement attributeElement;
        PsiAnnotationMemberValue element;
        if (value instanceof JamAttributeElement && (element = (attributeElement = (JamAttributeElement)value).getPsiElement()) != null && !(element instanceof PsiCompiledElement)) {
            return element;
        }
        return null;
    }
}

