/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation.valueresolvers.property.specialcases;

import com.intellij.tapestry.core.model.presentation.valueresolvers.AbstractValueResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverContext;
import java.util.regex.Pattern;
import org.apache.commons.chain.Context;

public class SpecialCaseNumericResolver
extends AbstractValueResolver {
    private static final Pattern LONG_PATTERN = Pattern.compile("\\d+");
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("\\d+((\\.|,)\\d+)");

    public boolean execute(Context context) throws Exception {
        String cleanValue = SpecialCaseNumericResolver.getCleanValue(((ValueResolverContext)context).getValue()).trim().toLowerCase();
        if (LONG_PATTERN.matcher(cleanValue).matches()) {
            ((ValueResolverContext)context).setResultType(((ValueResolverContext)context).getProject().getJavaTypeFinder().findType("java.lang.Long", true));
            return true;
        }
        if (DOUBLE_PATTERN.matcher(cleanValue).matches()) {
            ((ValueResolverContext)context).setResultType(((ValueResolverContext)context).getProject().getJavaTypeFinder().findType("java.lang.Double", true));
            return true;
        }
        return false;
    }
}

