/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.toolwindow.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.PsiField;
import com.intellij.tapestry.core.model.presentation.InjectedElement;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.core.java.IntellijJavaField;
import com.intellij.tapestry.intellij.toolwindow.nodes.EmbeddedComponentNode;
import com.intellij.tapestry.intellij.toolwindow.nodes.InjectedPageNode;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class NavigateToUsageAction
extends AnAction {
    private final JTree _tree;

    public NavigateToUsageAction(JTree tree) {
        super("Navigate to Usage", "Navigate to part of code where the selected element is used", AllIcons.Nodes.EjbReference);
        this._tree = tree;
    }

    public void actionPerformed(AnActionEvent event) {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this._tree.getSelectionPath().getLastPathComponent();
        Object selectedObject = selectedNode.getUserObject();
        if (selectedObject instanceof PresentationLibraryElement || selectedObject instanceof InjectedElement) {
            PsiField field = null;
            if (selectedNode instanceof EmbeddedComponentNode) {
                field = ((IntellijJavaField)((EmbeddedComponentNode)selectedNode).getInjectedComponent().getField()).getPsiField();
            }
            if (selectedNode instanceof InjectedPageNode) {
                field = ((IntellijJavaField)((InjectedPageNode)selectedNode).getInjectedPage().getField()).getPsiField();
            }
            if (field != null) {
                field.navigate(true);
            }
        }
    }
}

