/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DefaultDuplicatesSettingsEditor;
import com.intellij.dupLocator.DefaultDuplocatorState;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.JSDuplicatesProfile;
import com.intellij.dupLocator.resultUI.BaseDuplicatesView;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.FileBasedCodeFragmentType;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDuplicatesPresentation
implements DuplicatesPresentation {
    private final JSDuplicatesProfile myProfile;

    public JSDuplicatesPresentation(JSDuplicatesProfile profile) {
        this.myProfile = profile;
    }

    @NotNull
    public DuplicatesProfile getProfile() {
        JSDuplicatesProfile jSDuplicatesProfile = this.myProfile;
        if (jSDuplicatesProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JSDuplicatesPresentation", "getProfile"));
        }
        return jSDuplicatesProfile;
    }

    @Nullable
    public CodeFragmentType getType(@NotNull CodeNode node) throws InvalidatedException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JSDuplicatesPresentation", "getType"));
        }
        return new FileBasedCodeFragmentType(node.getVirtualFile(), node.getProject());
    }

    public boolean isFixAbilityProvided() {
        return false;
    }

    public boolean isFixAvailable(@NotNull CodeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JSDuplicatesPresentation", "isFixAvailable"));
        }
        return false;
    }

    public void applyFix(@NotNull CodeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/JSDuplicatesPresentation", "applyFix"));
        }
    }

    @NotNull
    public DuplicatesView createView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/JSDuplicatesPresentation", "createView"));
        }
        BaseDuplicatesView baseDuplicatesView = new BaseDuplicatesView(project);
        if (baseDuplicatesView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JSDuplicatesPresentation", "createView"));
        }
        return baseDuplicatesView;
    }

    @NotNull
    public DuplocatorSettingsEditor createEditor(@NotNull DuplocatorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/dupLocator/JSDuplicatesPresentation", "createEditor"));
        }
        DefaultDuplicatesSettingsEditor defaultDuplicatesSettingsEditor = new DefaultDuplicatesSettingsEditor((DefaultDuplocatorState)state);
        if (defaultDuplicatesSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JSDuplicatesPresentation", "createEditor"));
        }
        return defaultDuplicatesSettingsEditor;
    }
}

