/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.validation.JavaScriptAnnotatingVisitor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ES6AnnotatingVisitor
extends JavaScriptAnnotatingVisitor {
    public ES6AnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/ecmascript6/validation/ES6AnnotatingVisitor", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ecmascript6/validation/ES6AnnotatingVisitor", "<init>"));
        }
        super(psiElement, holder);
    }

    public static void highlightOfKeyword(JSForInStatement node, AnnotationHolder holder) {
        ASTNode ofKeyword = node.getNode().findChildByType(JSTokenTypes.OF_KEYWORD);
        if (ofKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(ofKeyword, holder);
        }
    }

    @Override
    public void visitJSForInStatement(JSForInStatement node) {
        super.visitJSForInStatement(node);
        ES6AnnotatingVisitor.highlightOfKeyword(node, this.myHolder);
    }

    @Override
    public void visitJSAttributeList(JSAttributeList attributeList) {
        super.visitJSAttributeList(attributeList);
        ES6AnnotatingVisitor.highlightAsync(attributeList, this.myHolder);
    }

    public static void highlightAsync(JSAttributeList attributeList, AnnotationHolder holder) {
        PsiElement async = attributeList.findModifierElement(JSAttributeList.ModifierType.ASYNC);
        if (async != null) {
            JSSemanticHighlightingUtil.highlightKeyword(async.getNode(), holder);
        }
    }

    @Override
    public void visitJSPrefixExpression(JSPrefixExpression node) {
        super.visitJSPrefixExpression(node);
        ES6AnnotatingVisitor.highlightAwait(node, this.myHolder);
    }

    public static void highlightAwait(JSPrefixExpression node, AnnotationHolder holder) {
        ASTNode awaitKeyword = node.getNode().findChildByType(JSTokenTypes.AWAIT_KEYWORD);
        if (awaitKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(awaitKeyword, holder);
        }
    }

    @Override
    protected boolean needsInitializer(JSParameterListElement parameter) {
        return false;
    }

    public void visitTypeScriptType(TypeScriptType type) {
        super.visitTypeScriptType(type);
        this.checkElementInCurrentLanguageLevel((PsiElement)type, JSLanguageFeature.TYPES);
    }
}

