/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class FlowJSContextType
extends TemplateContextType {
    protected FlowJSContextType() {
        super("Flow JS", JSBundle.message((String)"flowjs.template.context.type", (Object[])new Object[0]), JavaScriptCodeContextType.class);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/FlowJSContextType", "isInContext"));
        }
        Language language = JSLanguageUtil.getLanguage(file, offset);
        if (!(language instanceof JSLanguageDialect)) {
            return false;
        }
        DialectOptionHolder optionHolder = ((JSLanguageDialect)language).getOptionHolder();
        if (optionHolder.isFlow) {
            PsiElement parent;
            PsiElement at = file.findElementAt(offset);
            if (at == null && offset == file.getTextLength()) {
                at = file.findElementAt(offset - 1);
            }
            PsiElement psiElement = parent = at == null ? null : at.getParent();
            if (!(parent instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != null) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            return grandParent instanceof JSExpressionStatement;
        }
        return false;
    }
}

