/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSConditionalCompilationDefinitionsProvider;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.completion.JSReferenceCompletionProvider;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class JSReferenceCompletionUtil {
    JSReferenceCompletionUtil() {
    }

    @NotNull
    public static Iterable calcDefaultVariants(@NotNull JSReferenceExpression expression, PsiFile containingFile, boolean ecma, @NotNull Set<String> pushedSmartVariants, @NotNull CompletionResultSet resultSet) {
        Object processor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
        }
        if (pushedSmartVariants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushedSmartVariants", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
        }
        JSExpression qualifier = expression instanceof JSReferenceExpressionImpl ? ((JSReferenceExpressionImpl)expression).getResolveQualifier() : expression.getQualifier();
        CompletionResultSink sink = new CompletionResultSink((PsiElement)expression);
        PsiElement parent = expression.getParent();
        if (JSReferenceExpressionImpl.isLocalResolveQualifier(qualifier)) {
            if (JSResolveUtil.isSelfReference(parent, (PsiElement)expression)) {
                if (parent instanceof JSQualifiedNamedElement && !(parent instanceof JSPackageStatement)) {
                    SmartList results = new SmartList();
                    if (!(parent instanceof JSVariable) || !(JSResolveUtil.findParent(parent) instanceof JSClass)) {
                        results.add(containingFile.getOriginalFile().getVirtualFile().getNameWithoutExtension());
                    }
                    Iterable iterable = JSReferenceCompletionUtil.pushVariants((Iterable)results, pushedSmartVariants, resultSet);
                    if (iterable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                    }
                    return iterable;
                }
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                }
                return list;
            }
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)expression, qualifier, localProcessor, ecma, true, null);
            if (ecma && !localProcessor.processingEncounteredAnyTypeAccess() && !localProcessor.isEncounteredDynamicClasses()) {
                List<LookupElement> results = sink.getResultsAsObjects();
                Iterable concat = ContainerUtil.concat((Iterable[])new Iterable[]{results, JSReferenceCompletionUtil.conditionalCompilationVars(expression)});
                Iterable iterable = JSReferenceCompletionUtil.pushVariants(concat, pushedSmartVariants, resultSet);
                if (iterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                }
                return iterable;
            }
            if (DialectDetector.isTypeScript((PsiElement)containingFile) && (!(qualifier instanceof JSThisExpression) || JSContextResolver.findContextElement((JSThisExpression)qualifier) instanceof JSClass)) {
                Iterable iterable = JSReferenceCompletionUtil.pushVariants(sink.getResultsAsObjects(), pushedSmartVariants, resultSet);
                if (iterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                }
                return iterable;
            }
        } else {
            boolean useProcessorResults;
            processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).createCompletionItemProcessor(sink, containingFile);
            JSTypeEvaluator.evaluateTypes(BaseJSSymbolProcessor.getOriginalQualifier(qualifier), containingFile.getOriginalFile(), processor);
            boolean bl = useProcessorResults = ((QualifiedItemProcessor)processor).resolved == QualifiedItemProcessor.TypeResolveState.Resolved || ((QualifiedItemProcessor)processor).resolved == QualifiedItemProcessor.TypeResolveState.Undefined && (DialectDetector.isTypeScript((PsiElement)containingFile) || ecma) || ((QualifiedItemProcessor)processor).resolved == QualifiedItemProcessor.TypeResolveState.PrefixUnknown && ecma;
            if (useProcessorResults) {
                Iterable iterable = JSReferenceCompletionUtil.pushVariants(sink.getResultsAsObjects(), pushedSmartVariants, resultSet);
                if (iterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                }
                return iterable;
            }
        }
        processor = new VariantsProcessor(null, containingFile, (PsiElement)expression, BaseJSSymbolProcessor.MatchMode.Strict, JSRootConfiguration.getInstance(containingFile.getProject()).isOnlyTypeBasedCompletion());
        List<PsiElement> processorResults = sink.getResults();
        if (processorResults != null) {
            List<LookupElement> sinkLookupElements = sink.resultsToLookupElements(processorResults);
            ((VariantsProcessor)processor).populateCompletionList(sinkLookupElements, DialectDetector.isTypeScript((PsiElement)containingFile), resultSet);
        }
        if (!ecma) {
            ((VariantsProcessor)processor).collectReferencesUsedInCurrentScope((PsiElement)expression, qualifier != null);
        }
        JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        Collection<? extends LookupElement> completeMatchResults = ((VariantsProcessor)processor).getCurrentResults();
        ((VariantsProcessor)processor).populateCompletionList(completeMatchResults, false, resultSet);
        JSReferenceCompletionContributor.processIndexedSymbols((PsiElement)expression, (JSCompletionProcessor)processor, ((BaseJSSymbolProcessor)processor).addOnlyCompleteMatches());
        if (qualifier == null && ecma) {
            JSReferenceCompletionUtil.pushVariants(JSReferenceCompletionUtil.conditionalCompilationVars(expression), pushedSmartVariants, resultSet);
        }
        Collection<? extends LookupElement> results = ((VariantsProcessor)processor).getFinalResults();
        ((VariantsProcessor)processor).populateCompletionList(results, false, resultSet);
        Collection<? extends LookupElement> collection = results;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
        }
        return collection;
    }

    @NotNull
    private static Collection conditionalCompilationVars(JSReferenceExpression expression) {
        JSReferenceExpression namespaceReference = JSReferenceExpressionImpl.getNamespaceReference(expression);
        List<String> list = namespaceReference != null && namespaceReference.resolve() == namespaceReference ? JSReferenceCompletionUtil.getConditionalCompilationConstantNamesForNamespace((PsiElement)expression, namespaceReference.getReferenceName()) : JSReferenceCompletionUtil.getAllConditionalCompilationConstants((PsiElement)expression);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "conditionalCompilationVars"));
        }
        return list;
    }

    @NotNull
    private static List getAllConditionalCompilationConstants(PsiElement context) {
        ArrayList<Object> names = new ArrayList<Object>();
        for (JSConditionalCompilationDefinitionsProvider provider : (JSConditionalCompilationDefinitionsProvider[])JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()) {
            for (String conditional : provider.getAllConstants(ModuleUtilCore.findModuleForPsiElement((PsiElement)context))) {
                LookupItem lookupElement = new LookupItem((Object)conditional, conditional);
                JSCompletionUtil.setJSLookupPriority(lookupElement, JSLookupPriority.CONDITIONAL_COMPILATION_CONSTANTS_PRIORITY);
                names.add(lookupElement);
            }
            names.addAll(provider.getAllConstants(ModuleUtilCore.findModuleForPsiElement((PsiElement)context)));
        }
        ArrayList<Object> arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "getAllConditionalCompilationConstants"));
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getConditionalCompilationConstantNamesForNamespace(PsiElement context, String namespace) {
        ArrayList<String> names = new ArrayList<String>();
        for (JSConditionalCompilationDefinitionsProvider provider : (JSConditionalCompilationDefinitionsProvider[])JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()) {
            names.addAll(provider.getConstantNamesForNamespace(ModuleUtilCore.findModuleForPsiElement((PsiElement)context), namespace));
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "getConditionalCompilationConstantNamesForNamespace"));
        }
        return arrayList;
    }

    @NotNull
    private static Iterable pushVariants(@NotNull Iterable variants, Set<String> populatedVariants, @NotNull CompletionResultSet result) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "pushVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "pushVariants"));
        }
        JSInsertHandler insertHandler = new JSInsertHandler();
        for (Object variant : variants) {
            LookupElement element = CompletionData.objectToLookupItem(variant);
            if (populatedVariants.contains(element.getLookupString())) continue;
            JSReferenceCompletionProvider.addVariant(insertHandler, element, result);
        }
        Iterable iterable = variants;
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "pushVariants"));
        }
        return iterable;
    }
}

