/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSTextReferenceCompletion {
    static void addVariants(JSTextReference reference, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/javascript/completion/JSTextReferenceCompletion", "addVariants"));
        }
        PsiElement element = reference.getElement();
        PsiFile containingFile = element.getContainingFile();
        List<LookupElement> localResults = null;
        boolean newResolveAndCompletion = reference.useActionScriptIndex(containingFile);
        if (newResolveAndCompletion) {
            CompletionResultSink resultSink = new CompletionResultSink((PsiElement)containingFile);
            Collection<String> baseClassFqns = reference.getBaseClassFqns();
            if (baseClassFqns != null && !baseClassFqns.isEmpty()) {
                JSTextReferenceCompletion.setCompletionFilter(resultSink, baseClassFqns, containingFile);
            }
            reference.processToSink(containingFile, resultSink);
            List<PsiElement> results = resultSink.getResults();
            if (results != null) {
                localResults = resultSink.resultsToLookupElements(results);
                resultSet.addAllElements(localResults);
                JSTextReferenceCompletion.forceQualifyIfNeeded(reference, localResults);
            } else {
                localResults = Collections.emptyList();
            }
        }
        if (!newResolveAndCompletion || element instanceof JSLiteralExpression) {
            List<LookupElement> stringLiteralVariants;
            if (element instanceof JSLiteralExpression && (stringLiteralVariants = JSSmartCompletionContributor.getStringLiteralVariants((JSExpression)element, false)) != null) {
                resultSet.addAllElements(stringLiteralVariants);
            }
            JSTextReferenceCompletion.calcDefaultVariants(reference, containingFile, localResults, resultSet);
            if (reference instanceof JSDocReference) {
                JSTextReferenceCompletion.addJSDocTags(reference, resultSet);
            }
        }
    }

    private static void addJSDocTags(JSTextReference reference, CompletionResultSet set) {
        if (reference.getElement() instanceof JSDocTagValue) {
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"boolean"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"function"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"number"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"string"), JSLookupPriority.SMART_PRIORITY));
        }
    }

    public static List<LookupElement> calcDefaultVariants(JSTextReference reference, PsiFile containingFile, List<LookupElement> localResults, @NotNull CompletionResultSet resultSet) {
        PsiReference ref;
        PsiElement context;
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/javascript/completion/JSTextReferenceCompletion", "calcDefaultVariants"));
        }
        List<String> contextNames = reference.fillContextNames();
        VariantsProcessor processor = new VariantsProcessor(contextNames != null ? ArrayUtil.toStringArray(contextNames) : BaseJSSymbolProcessor.EMPTY_CONTEXT, containingFile, reference.getElement(), BaseJSSymbolProcessor.MatchMode.Any);
        processor.setAddOnlyCompleteMatches(contextNames != null || !(reference.getElement() instanceof JSLiteralExpression));
        if (localResults != null) {
            processor.populateCompletionList(localResults, false, resultSet);
        }
        if ((context = containingFile.getContext()) != null || reference.isPrimary()) {
            CompletionResultSink sink = new CompletionResultSink(reference.getElement());
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            reference.processLocalVariants(containingFile, localProcessor, context);
            List<PsiElement> processorResults = sink.getResults();
            if (processorResults != null) {
                processor.populateCompletionList(sink.resultsToLookupElements(processorResults), false, resultSet);
            }
        }
        JSReferenceCompletionContributor.processIndexedSymbols(reference.getElement(), processor);
        String name = null;
        PsiElement originalElement = PsiUtilBase.getOriginalElement((PsiElement)reference.getElement(), reference.getElement().getClass());
        if (originalElement != null && (ref = originalElement.findReferenceAt(reference.getRangeInElement().getStartOffset())) != null) {
            name = ref.getCanonicalText();
        }
        List<LookupElement> results = processor.getResults(name);
        processor.populateCompletionList(results, false, resultSet);
        return results;
    }

    private static void forceQualifyIfNeeded(JSTextReference reference, List<LookupElement> results) {
        if (reference.isOnlyFqns() && reference.isPrimary()) {
            for (LookupElement result : results) {
                if (!(result instanceof LookupItem)) continue;
                ((LookupItem)result).forceQualify();
            }
        }
    }

    private static void setCompletionFilter(CompletionResultSink resultSink, Collection<String> baseClassFqns, PsiFile containingFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
        if (module != null) {
            Condition filter;
            GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
            if (baseClassFqns.size() == 1) {
                filter = new PublicInheritorFilter(module.getProject(), baseClassFqns.iterator().next(), scope, false);
            } else {
                List conditions = ContainerUtil.map(baseClassFqns, fqn -> new PublicInheritorFilter(module.getProject(), (String)fqn, scope, false));
                filter = aClass -> {
                    for (Condition condition : conditions) {
                        if (!condition.value(aClass)) continue;
                        return true;
                    }
                    return false;
                };
            }
            resultSink.setPlaceFilter(CompletionResultSink.createFilter((Condition<JSClass>)filter));
        }
    }
}

