/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportHandler
extends JSImportHandler {
    private static final TypeScriptImportHandler INSTANCE = new TypeScriptImportHandler();
    private static final Condition<PsiElement> FILTER_EXTERNAL_MODULES = TypeScriptPsiUtil::isExternalModule;

    protected TypeScriptImportHandler() {
    }

    public static TypeScriptImportHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeName"));
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
    }

    @Override
    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        JSTypeResolveResult jSTypeResolveResult = TypeScriptImportHandler.resolveNameImpl(type, source, false, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        return jSTypeResolveResult;
    }

    @NotNull
    private static JSTypeResolveResult resolveNameImpl(@NotNull String type, @NotNull PsiElement sourceRaw, boolean typeContext, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited) {
        String qName;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        if (sourceRaw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRaw", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        PsiElement source = TypeScriptImportHandler.getSourceElement(sourceRaw);
        if (source == null) {
            source = sourceRaw;
        }
        if (!DialectDetector.isTypeScript(source)) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
            }
            return jSTypeResolveResult;
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(type);
        Collection<Object> elements = TypeScriptImportHandler.resolveTypeElements(qualifiedName, source, visited, typeContext);
        final PsiElement finalSource = source;
        if ((elements = ContainerUtil.filter(elements, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return TypeScriptImportHandler.checkModulesAccess(finalSource, element) && TypeScriptConfigService.Provider.isAccessible(finalSource, element);
            }
        })).isEmpty()) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
            }
            return jSTypeResolveResult;
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : "";
        if (qName == null) {
            qName = "";
        }
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(qName, elements);
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        return jSTypeResolveResult;
    }

    private static PsiElement getSourceElement(@NotNull PsiElement sourceRaw) {
        if (sourceRaw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRaw", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getSourceElement"));
        }
        PsiElement type = PsiTreeUtil.getContextOfType((PsiElement)sourceRaw, (boolean)false, (Class[])new Class[]{JSSourceElement.class});
        if (type instanceof TypeScriptType) {
            type = TypeScriptImportHandler.getSourceElement(sourceRaw.getParent());
        }
        if (type instanceof TypeScriptModule || type instanceof JSFile || type == null) {
            return type;
        }
        PsiElement parent = type.getContext();
        if (type instanceof JSBlockStatement) {
            if (parent instanceof JSFunction) {
                return parent;
            }
            return type;
        }
        if (parent != null && TypeScriptPsiUtil.isTopLevelContainer(parent)) {
            return parent;
        }
        return type;
    }

    @Override
    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameResolvedType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameResolvedType"));
        }
        final Ref resultValue = new Ref();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.source = context;
        visitor.visited = (Set)new THashSet();
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                if (qualifierResult instanceof JSQualifiedNamedElement) {
                    resultValue.set((Object)((JSQualifiedNamedElement)qualifierResult));
                    return true;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                return resultValue.get() != null;
            }
        };
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(type);
        visitor.processQualifier(name);
        return resultValue.get() == null ? "" : ((JSQualifiedNamedElement)resultValue.get()).getQualifiedName();
    }

    @NotNull
    private static Set<? extends PsiElement> resolveTypeElements(@NotNull JSQualifiedName qualifiedName, @NotNull PsiElement source, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited, boolean typeContext) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        final THashSet result = new THashSet();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.source = source;
        visitor.typeContext = typeContext;
        visitor.visited = visited;
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                result.add((Object)qualifierResult);
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }
        };
        visitor.processQualifier(qualifiedName);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        return tHashSet;
    }

    private static boolean findReferencedElements(@NotNull String name, @NotNull PsiElement source, boolean localResolve, TypeScriptElementVisitor accumulatedElementsVisitor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "findReferencedElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "findReferencedElements"));
        }
        boolean strictTypeContext = accumulatedElementsVisitor.isStrictTypeContext();
        Collection<? extends PsiElement> localResults = TypeScriptImportHandler.getLocalResults(name, source, localResolve, accumulatedElementsVisitor);
        boolean methodAccepted = false;
        for (PsiElement psiElement : localResults) {
            if (strictTypeContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(psiElement)) continue;
            boolean accepted = false;
            if (psiElement instanceof TypeScriptImportStatement) {
                TypeScriptExternalModuleReference externalModuleReference = ((TypeScriptImportStatement)psiElement).getExternalModuleReference();
                TypeScriptEntityName internalModuleReference = ((TypeScriptImportStatement)psiElement).getInternalModuleReference();
                if (externalModuleReference != null) {
                    Collection resolveResults = externalModuleReference.multiResolve();
                    for (PsiElement resolve : resolveResults) {
                        if (resolve == null || !TypeScriptPsiUtil.isTopLevelContainer(resolve)) continue;
                        TypeScriptExportAssignment exportAssignment = TypeScriptPsiUtil.findExportAssignment(resolve);
                        if (exportAssignment != null) {
                            accepted = TypeScriptImportHandler.processAssignExpression((JSExportAssignment)exportAssignment, accumulatedElementsVisitor);
                            continue;
                        }
                        if (accumulatedElementsVisitor.accept(resolve)) {
                            return true;
                        }
                        accepted = true;
                    }
                } else if (internalModuleReference != null) {
                    accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(internalModuleReference.multiResolve(false)), accumulatedElementsVisitor, ContainerUtil.newHashSet());
                }
            } else if (psiElement instanceof TypeScriptModule) {
                String qName = ((TypeScriptModule)psiElement).getQualifiedName();
                if (qName != null) {
                    accumulatedElementsVisitor.accept(psiElement);
                    accepted = true;
                }
            } else if (TypeScriptImportHandler.isImport(psiElement)) {
                accepted = TypeScriptImportHandler.resolveImport(psiElement, accumulatedElementsVisitor, ContainerUtil.newHashSet());
            } else if (psiElement instanceof TypeScriptGlobalModuleExportDeclaration) {
                for (PsiElement module : ((TypeScriptGlobalModuleExportDeclaration)psiElement).getModules()) {
                    if (accumulatedElementsVisitor.accept(module)) {
                        return true;
                    }
                    accepted = true;
                }
            }
            if (!accepted && accumulatedElementsVisitor.accept(psiElement)) {
                return true;
            }
            methodAccepted = true;
        }
        return methodAccepted;
    }

    @NotNull
    private static TypeScriptModuleDeclarationsProcessor createProcessor(@NotNull String name, TypeScriptElementVisitor accumulatedElementsVisitor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "createProcessor"));
        }
        TypeScriptModuleDeclarationsProcessor typeScriptModuleDeclarationsProcessor = new TypeScriptModuleDeclarationsProcessor(name, accumulatedElementsVisitor.isStrictTypeContext());
        if (typeScriptModuleDeclarationsProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "createProcessor"));
        }
        return typeScriptModuleDeclarationsProcessor;
    }

    private static Collection<PsiElement> convertToPsiElements(ResolveResult[] results) {
        return ContainerUtil.mapNotNull((Object[])results, ResolveResult::getElement);
    }

    private static boolean isImport(PsiElement element) {
        return element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof JSExportAssignment;
    }

    private static boolean resolveImport(PsiElement element, TypeScriptElementVisitor accumulatedElementsVisitor, Set<PsiElement> visited) {
        if (visited != null && !visited.add(element)) {
            return false;
        }
        boolean accepted = false;
        if (element instanceof TypeScriptImportStatement) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(((TypeScriptImportStatement)element).findReferencedElements(), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportExportSpecifier) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(((ES6ImportExportSpecifier)element).resolveOverAliases(visited)), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportedBinding) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(((ES6ImportedBinding)element).findReferencedElements(visited), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportExportSpecifierAlias) {
            ES6ImportExportSpecifier specifier = ((ES6ImportExportSpecifierAlias)element).findSpecifierElement();
            if (specifier != null) {
                accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(specifier.resolveOverAliases()), accumulatedElementsVisitor, visited);
            } else {
                if (accumulatedElementsVisitor.accept(element)) {
                    return true;
                }
                accepted = true;
            }
        } else if (element instanceof JSExportAssignment) {
            accepted = TypeScriptImportHandler.processAssignExpression((JSExportAssignment)element, accumulatedElementsVisitor);
        }
        return accepted;
    }

    private static boolean processWithResolveImportReferences(Collection<? extends PsiElement> elements, TypeScriptElementVisitor accumulatedElementsVisitor, Set<PsiElement> visited) {
        boolean accepted = false;
        for (PsiElement psiElement : elements) {
            if (TypeScriptImportHandler.isImport(psiElement)) {
                accepted = TypeScriptImportHandler.resolveImport(psiElement, accumulatedElementsVisitor, visited);
                continue;
            }
            if (accumulatedElementsVisitor.accept(psiElement)) {
                return true;
            }
            accepted = true;
        }
        return accepted;
    }

    @NotNull
    private static Collection<? extends PsiElement> getLocalResults(@NotNull String name, @NotNull PsiElement source, boolean localResolve, TypeScriptElementVisitor accumulatedElementsVisitor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
        }
        PsiElement moduleParent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)source, (Class[])new Class[]{TypeScriptModule.class, PsiFile.class});
        PsiElement module = moduleParent;
        boolean isExternalModule = module instanceof JSFile && ((JSFile)module).isCommonJSModule();
        boolean isModule = module instanceof TypeScriptModule || isExternalModule;
        PsiElement parent = source.getParent();
        Collection<? extends PsiElement> localElements = TypeScriptImportHandler.getLocalClassesIfExists(name, source, localResolve, accumulatedElementsVisitor, module, parent);
        if (localElements != null) {
            ArrayList elements = ContainerUtil.newArrayList(localElements);
            TypeScriptImportHandler.addMergedAndGlobalElements(source, accumulatedElementsVisitor, elements, TypeScriptImportHandler.getQualifiedNameForModule(name, module), true);
            ArrayList arrayList = elements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
            }
            return arrayList;
        }
        TypeScriptModuleDeclarationsProcessor processor = TypeScriptImportHandler.createProcessor(name, accumulatedElementsVisitor);
        PsiElement realPlace = accumulatedElementsVisitor.getSource();
        if (realPlace == null) {
            realPlace = source;
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        while (module != null) {
            if (!(module instanceof JSElement)) {
                LinkedHashSet linkedHashSet = result;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
                }
                return linkedHashSet;
            }
            ES6PsiUtil.processES6DeclarationsInScope((JSElement)module, processor, ResolveState.initial(), moduleParent, realPlace, !accumulatedElementsVisitor.isQualifier());
            List<PsiElement> possibleResults = processor.getResults();
            if (localResolve) {
                List list = ContainerUtil.notNullize(possibleResults);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
                }
                return list;
            }
            if (possibleResults != null) {
                ArrayList notPublic = null;
                if (isExternalModule && !possibleResults.isEmpty()) {
                    List<PsiElement> list = possibleResults;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
                    }
                    return list;
                }
                for (PsiElement element : possibleResults) {
                    JSAttributeList list;
                    if (TypeScriptModuleAccessibilityChecker.checkElementCanBeExported(element) || TypeScriptImportHandler.isImportOrBinding(element)) {
                        result.add(element);
                    }
                    if (!(element instanceof JSAttributeListOwner) || (list = ((JSAttributeListOwner)element).getAttributeList()) == null || list.getAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptImportHandler.isRealModuleOfImplicitModule(module, element)) continue;
                    if (notPublic == null) {
                        notPublic = ContainerUtil.newArrayList();
                    }
                    notPublic.add(element);
                }
                if (!accumulatedElementsVisitor.isQualifier() && isModule && !ContainerUtil.isEmpty(notPublic)) {
                    ArrayList arrayList = notPublic;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
                    }
                    return arrayList;
                }
            }
            String qName = TypeScriptImportHandler.getQualifiedNameForModule(name, module);
            TypeScriptImportHandler.addMergedAndGlobalElements(source, accumulatedElementsVisitor, result, qName, false);
            if (!accumulatedElementsVisitor.isQualifier() && !result.isEmpty()) break;
            module = TypeScriptImportHandler.getParentModuleOrFile(module);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
        }
        return linkedHashSet;
    }

    private static String getQualifiedNameForModule(@NotNull String name, PsiElement module) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameForModule"));
        }
        return module instanceof TypeScriptModule ? ((TypeScriptModule)module).getQualifiedName() + "." + name : name;
    }

    @Nullable
    public static JSElement getParentModuleOrFile(PsiElement module) {
        return ES6PsiUtil.getExportScope(module);
    }

    private static boolean isImportOrBinding(PsiElement element) {
        return element instanceof ES6ImportSpecifier || element instanceof ES6ImportSpecifierAlias || element instanceof ES6ImportedBinding;
    }

    private static void addMergedAndGlobalElements(final @NotNull PsiElement currentSource, final TypeScriptElementVisitor accumulatedElementsVisitor, final Collection<PsiElement> result, String qName, final boolean modulesOnly) {
        if (currentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "addMergedAndGlobalElements"));
        }
        Collection<JSQualifiedNamedElement> elementsByQName = TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(qName, currentSource);
        List filteredElements = ContainerUtil.filter(elementsByQName, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                if (result.contains(element)) {
                    return false;
                }
                PsiElement source = accumulatedElementsVisitor.getSource();
                if (source == null) {
                    source = currentSource;
                }
                if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
                    return TypeScriptConfigService.Provider.isAccessible(currentSource, element);
                }
                if (modulesOnly && !(element instanceof TypeScriptModule)) {
                    return false;
                }
                if (!TypeScriptModuleAccessibilityChecker.checkElementCanBeExported(element)) {
                    return false;
                }
                if (element instanceof JSClass && !((JSClass)element).isNamespaceExplicitlyDeclared()) {
                    return false;
                }
                PsiElement module = TypeScriptPsiUtil.getTopLevelContainer(element);
                if (module == null || !TypeScriptPsiUtil.isExternalModule(module)) {
                    return TypeScriptImportHandler.checkModulesAccess(source, element) && TypeScriptConfigService.Provider.isAccessible(source, element);
                }
                if (!TypeScriptImportHandler.checkQNames(element, module, source)) {
                    return false;
                }
                return TypeScriptImportHandler.checkModulesAccess(source, element) && TypeScriptConfigService.Provider.isAccessible(source, element) && ES6ImportHandler.isExported(element);
            }
        });
        result.addAll(filteredElements);
        if (result.size() > 0) {
            result.addAll(TypeScriptAugmentationUtil.getAugmentations(currentSource, ContainerUtil.filter(result, FILTER_EXTERNAL_MODULES)));
        }
    }

    private static boolean checkModulesAccess(PsiElement source, PsiElement element) {
        return TypeScriptModuleAccessibilityChecker.INSTANCE.check(source, element) == null;
    }

    public static boolean checkQNames(PsiElement element, PsiElement module, PsiElement source) {
        if (TypeScriptImportHandler.isNotAugmentationModule(element)) {
            PsiElement sourceContainer;
            if (source instanceof TypeScriptModule) {
                sourceContainer = source;
            } else {
                PsiElement psiElement = sourceContainer = source == null ? null : TypeScriptPsiUtil.getTopLevelContainer(source);
            }
            if (!(module.isEquivalentTo(sourceContainer) || module instanceof JSQualifiedNamedElement && sourceContainer instanceof JSQualifiedNamedElement && StringUtil.equals((CharSequence)((JSQualifiedNamedElement)module).getQualifiedName(), (CharSequence)((JSQualifiedNamedElement)sourceContainer).getQualifiedName()) || !TypeScriptImportHandler.isNotAugmentationModule(module) || !TypeScriptImportHandler.isNotAugmentationModule(sourceContainer))) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static Collection<? extends PsiElement> getLocalClassesIfExists(@NotNull String name, @NotNull PsiElement source, boolean localResolve, TypeScriptElementVisitor accumulatedElementsVisitor, PsiElement module, PsiElement parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalClassesIfExists"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalClassesIfExists"));
        }
        if (localResolve || module == parent || module == source || accumulatedElementsVisitor.isQualifier()) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement currentParent = source; currentParent != module && currentParent != null && !TypeScriptPsiUtil.isTopLevelContainerMember(currentParent); currentParent = currentParent.getParent()) {
            if (currentParent instanceof JSClass && StringUtil.equals((CharSequence)((JSClass)currentParent).getName(), (CharSequence)name)) {
                result.add(currentParent);
            } else if (currentParent instanceof JSElement && TypeScriptImportHandler.isClassScopeElement(currentParent)) {
                for (JSElement element : JSResolveUtil.findNamedElementsInScope(name, (JSElement)currentParent)) {
                    if (!(element instanceof JSClass)) continue;
                    result.add(element);
                }
            }
            if (result.isEmpty()) continue;
            return result;
        }
        return null;
    }

    private static boolean isClassScopeElement(PsiElement currentParent) {
        return currentParent instanceof JSBlockStatement || currentParent instanceof TypeScriptModule || currentParent instanceof JSFile || currentParent instanceof TypeScriptFunction && !(currentParent instanceof TypeScriptTypeMember);
    }

    private static boolean isRealModuleOfImplicitModule(PsiElement module, PsiElement element) {
        return module instanceof TypeScriptImplicitModule && ((TypeScriptImplicitModule)module).getRealModule() == element;
    }

    private static boolean processAssignExpression(JSExportAssignment assignment, TypeScriptElementVisitor accumulatedElementsVisitor) {
        boolean accepted = false;
        String referenceName = assignment.getInitializerReference();
        if (referenceName != null) {
            JSTypeResolveResult result = TypeScriptImportHandler.resolveNameImpl(referenceName, (PsiElement)assignment, accumulatedElementsVisitor.isStrictTypeContext(), accumulatedElementsVisitor.visited());
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(result.getElements(), accumulatedElementsVisitor, ContainerUtil.newHashSet());
        } else {
            JSExpression assignmentExpression = assignment.getExpression();
            if (assignmentExpression instanceof JSClassExpression) {
                accumulatedElementsVisitor.accept((PsiElement)assignmentExpression);
                return true;
            }
            if (assignmentExpression instanceof JSReferenceExpression) {
                return TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(((JSReferenceExpression)assignmentExpression).multiResolve(false)), accumulatedElementsVisitor, null);
            }
        }
        return accepted;
    }

    private static boolean isNotAugmentationModule(PsiElement element) {
        return !(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isAugmentation();
    }

    private static class TypeScriptModuleDeclarationsProcessor
    extends JSResolveProcessorBase {
        private final boolean myStrictTypeContext;
        private List<PsiElement> myResults;

        public TypeScriptModuleDeclarationsProcessor(@NotNull String name, boolean strictTypeContext) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler$TypeScriptModuleDeclarationsProcessor", "<init>"));
            }
            super(name);
            this.myStrictTypeContext = strictTypeContext;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler$TypeScriptModuleDeclarationsProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler$TypeScriptModuleDeclarationsProcessor", "execute"));
            }
            if (!this.myName.equals(ResolveProcessor.getName(element))) {
                return true;
            }
            if (this.myStrictTypeContext && !(!(element instanceof ES6ImportExportSpecifier) ? TypeScriptPsiUtil.isNamedTypeContainerDefinition(element) : TypeScriptPsiUtil.referencesNamedTypeContainer((ES6ImportExportSpecifier)element))) {
                return true;
            }
            if (this.myResults == null) {
                this.myResults = ContainerUtil.newSmartList();
            }
            this.myResults.add(element);
            return true;
        }

        @Nullable
        public List<PsiElement> getResults() {
            return this.myResults;
        }
    }

    private static final class SubTypeVisitor
    implements TypeScriptHierarchyVisitor {
        private TypeScriptHierarchyVisitor parent;
        private PsiElement source;
        private String name;
        private Set<Pair<JSQualifiedName, PsiElement>> visited;
        private boolean typeContext;
        private boolean isQualifier = false;

        private SubTypeVisitor() {
        }

        private TypeScriptElementVisitor createSimpleExpressionVisitor() {
            return new TypeScriptElementVisitor(){
                private THashSet<PsiElement> accepted;

                @Override
                public boolean accept(PsiElement element) {
                    if (this.accepted == null) {
                        this.accepted = new THashSet();
                    }
                    if (!this.accepted.add((Object)element)) {
                        return false;
                    }
                    return parent.accept(element);
                }

                @Override
                public PsiElement getSource() {
                    return source;
                }

                @Override
                public boolean isStrictTypeContext() {
                    return typeContext;
                }

                @Override
                public boolean isQualifier() {
                    return isQualifier;
                }

                @Override
                public Set<Pair<JSQualifiedName, PsiElement>> visited() {
                    return visited;
                }
            };
        }

        @Override
        public boolean accept(PsiElement qualifierResult) {
            if (qualifierResult instanceof TypeScriptModule || qualifierResult instanceof JSFile) {
                TypeScriptImportHandler.findReferencedElements(this.name, qualifierResult, true, this.createSimpleExpressionVisitor());
            }
            return this.parent.isDone();
        }

        public SubTypeVisitor createSubVisitor() {
            SubTypeVisitor visitor = new SubTypeVisitor();
            visitor.parent = this;
            visitor.source = this.source;
            visitor.visited = this.visited;
            visitor.isQualifier = true;
            return visitor;
        }

        public void processQualifier(JSQualifiedName qualifiedName) {
            if (!this.visited.add((Pair<JSQualifiedName, PsiElement>)Pair.create((Object)qualifiedName, (Object)this.source))) {
                return;
            }
            this.name = qualifiedName.getName();
            JSQualifiedName qualifier = qualifiedName.getParent();
            if (qualifier != null) {
                this.createSubVisitor().processQualifier(qualifier);
            } else {
                TypeScriptImportHandler.findReferencedElements(this.name, this.source, false, this.createSimpleExpressionVisitor());
            }
        }

        @Override
        public boolean isDone() {
            return this.parent.isDone();
        }
    }

    private static interface TypeScriptHierarchyVisitor {
        public boolean accept(PsiElement var1);

        public boolean isDone();
    }

    private static interface TypeScriptElementVisitor {
        public boolean accept(PsiElement var1);

        @Nullable
        public PsiElement getSource();

        public boolean isStrictTypeContext();

        public boolean isQualifier();

        public Set<Pair<JSQualifiedName, PsiElement>> visited();
    }
}

