/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;

public class FlowJSAnnotation {
    public static boolean isFlowAnnotation(@NotNull PsiFile file) {
        PsiElement psiElement;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSAnnotation", "isFlowAnnotation"));
        }
        boolean containsFlowAnnotation = false;
        if (psiElement != null) {
            for (psiElement = file.getFirstChild(); psiElement != null && (psiElement instanceof PsiWhiteSpace || JSPsiImplUtils.isUseStrictStatement(psiElement)); psiElement = psiElement.getNextSibling()) {
                if (!JSPsiImplUtils.isUseStrictStatement(psiElement) || !psiElement.getText().contains("@flow")) continue;
                return true;
            }
            if (psiElement != null) {
                PsiElement firstComment = psiElement;
                while (firstComment.getFirstChild() != null) {
                    firstComment = firstComment.getFirstChild();
                }
                if (firstComment instanceof PsiComment || firstComment.getParent() instanceof PsiComment) {
                    if (firstComment.getParent() instanceof PsiComment) {
                        firstComment = firstComment.getParent();
                    }
                    PsiElement parent = firstComment.getParent();
                    for (PsiElement element = parent.getFirstChild(); element != null; element = element.getNextSibling()) {
                        if (element instanceof PsiComment || element instanceof PsiWhiteSpace) {
                            if (!element.getText().contains("@flow")) continue;
                            containsFlowAnnotation = true;
                            break;
                        }
                        if (!JSPsiImplUtils.isUseStrictStatement(element)) break;
                    }
                }
            }
        }
        return containsFlowAnnotation;
    }
}

