/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.ecmascript6.ES6SpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptReferenceExpressionResolver;
import com.intellij.lang.javascript.flow.FlowJSGoToDeclaration;
import com.intellij.lang.javascript.flow.FlowSettings;
import com.intellij.lang.javascript.flow.FlowSettingsManager;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSSpecificHandlersFactory
extends ES6SpecificHandlersFactory {
    @Override
    @NotNull
    public JSResolveUtil.Resolver<JSReferenceExpressionImpl> createReferenceExpressionResolver(final JSReferenceExpressionImpl referenceExpression, final PsiFile containingFile) {
        JSReferenceExpressionResolver jSReferenceExpressionResolver = new JSReferenceExpressionResolver(referenceExpression, containingFile){

            @Override
            public ResolveResult[] doResolve() {
                FlowSettings settings = FlowSettingsManager.getInstance(referenceExpression.getProject()).getFlowSettings();
                if (settings != null && settings.getFlowResolveEnable()) {
                    ArrayList resolveResults = ContainerUtil.newArrayList();
                    PsiElement element = FlowJSGoToDeclaration.getGotoDeclarationTarget((PsiElement)referenceExpression, PsiDocumentManager.getInstance((Project)containingFile.getProject()).getDocument(containingFile));
                    if (element != null) {
                        JSQualifiedNamedElement parent = (JSQualifiedNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSQualifiedNamedElement.class);
                        JSResolveResult result = new JSResolveResult((PsiElement)(parent != null ? parent : element));
                        resolveResults.add(result);
                    }
                    if (resolveResults.isEmpty()) {
                        return super.doResolve();
                    }
                    return resolveResults.toArray(new ResolveResult[0]);
                }
                return super.doResolve();
            }

            @Override
            @Nullable
            protected String adjustReferencedName(@NotNull JSReferenceExpression ref) {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/flow/FlowJSSpecificHandlersFactory$1", "adjustReferencedName"));
                }
                return TypeScriptReferenceExpressionResolver.adjustPrimitiveTypes(ref);
            }
        };
        if (jSReferenceExpressionResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSpecificHandlersFactory", "createReferenceExpressionResolver"));
        }
        return jSReferenceExpressionResolver;
    }
}

