/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSToolWindowProvider {
    private final JSLanguageServiceToolWindowManager myToolWindow;

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        FlowJSToolWindowProvider provider = (FlowJSToolWindowProvider)ServiceManager.getService((Project)project, FlowJSToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public FlowJSToolWindowProvider(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider", "<init>"));
        }
        AnAction checkAllFiles = new AnAction(JSBundle.message((String)"javascript.flow.error.panel.all.errors", (Object[])new Object[0]), JSBundle.message((String)"javascript.flow.error.panel.all.errors", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile1){

            public void actionPerformed(AnActionEvent e) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$1", "lambda$actionPerformed$1"));
                    }
                    ArrayList results = ContainerUtil.newArrayList();
                    FlowJSServerService service = FlowJSServerService.getService(project);
                    if (service != null) {
                        results.addAll(service.getAllErrors());
                    }
                    ApplicationManager.getApplication().invokeLater(() -> FlowJSToolWindowProvider.this.myToolWindow.logProjectErrors((ImmutableList<JSLanguageServiceAnnotationResult>)ContainerUtil.immutableList((List)results), true));
                });
            }
        };
        this.myToolWindow = new JSLanguageServiceToolWindowManager(project, "Flow", "FlowJS", JavaScriptLanguageIcons.Flowjs.Flowjs, checkAllFiles);
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
    }

    public JSLanguageServiceToolWindowManager getToolWindow() {
        return this.myToolWindow;
    }
}

