/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsFlowSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FlowSettingsManager
implements PersistentStateComponent<Element> {
    private static final String EXE_PATH = "exe-path";
    private static final String RESOLVE_ENABLE = "annotation-enable";
    private FlowSettings myFlowSettings;

    public FlowSettingsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowSettingsManager", "<init>"));
        }
        this.myFlowSettings = new FlowSettings.Builder().setFlowResolveEnable(false).build();
    }

    @Nullable
    public Element getState() {
        FlowSettings settings = this.myFlowSettings;
        Element root = new Element("js-flow-settings");
        Element exePathElement = new Element(EXE_PATH);
        exePathElement.addContent((Content)new Text(settings.getFlowExecutablePath()));
        root.addContent(exePathElement);
        Element resolveEnableElement = new Element(RESOLVE_ENABLE);
        resolveEnableElement.addContent((Content)new Text(Boolean.toString(settings.getFlowResolveEnable())));
        root.addContent(resolveEnableElement);
        return root;
    }

    public void loadState(Element state) {
        if (state != null) {
            Element resolveEnable;
            FlowSettings.Builder builder = this.myFlowSettings.createBuilder();
            Element exePathElement = state.getChild(EXE_PATH);
            if (exePathElement != null) {
                builder.setFlowExecutablePath(exePathElement.getText());
            }
            if ((resolveEnable = state.getChild(RESOLVE_ENABLE)) != null) {
                builder.setFlowResolveEnable(resolveEnable.getText().toLowerCase().equals("true"));
            }
            this.myFlowSettings = builder.build();
        }
    }

    public static JCheckBox createFlowCheckBox() {
        JBCheckBox checkBox = new JBCheckBox(JSBundle.message((String)"js.flow.enable.flow.resolve", (Object[])new Object[0]), false);
        checkBox.setToolTipText(JSBundle.message((String)"js.flow.enable.flow.resolve.description", (Object[])new Object[0]));
        return checkBox;
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createFlowExecutable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowSettingsManager", "createFlowExecutable"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)"Select Flow executable", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowSettingsManager", "lambda$createFlowExecutable$0"));
            }
            return FlowSettingsManager.calcPossibleFlowExecutableFiles(project);
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowSettingsManager", "createFlowExecutable"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    public static List<String> calcPossibleFlowExecutableFiles(Project project) {
        ArrayList paths = ContainerUtil.newArrayList();
        String basename = FlowSettingsManager.getFlowExecutableFilename();
        List files = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)basename);
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        ArrayList infos = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName(infos, "flow-bin", project.getBaseDir(), null, false);
        for (CompletionModuleInfo info : infos) {
            File exe;
            File bowerPackageDir;
            String path = info.getAbsolutePath();
            if (info.getType() != ModuleType.NODE_MODULES_DIR || path == null || !(bowerPackageDir = new File(FileUtil.toSystemDependentName((String)path))).isDirectory() || !(exe = new File(bowerPackageDir, "vendor" + File.separator + basename)).isFile()) continue;
            paths.add(exe.getAbsolutePath());
        }
        return paths;
    }

    @Contract(pure=true)
    @NotNull
    static String getFlowExecutableFilename() {
        String string = SystemInfo.isWindows ? "flow.exe" : "flow";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowSettingsManager", "getFlowExecutableFilename"));
        }
        return string;
    }

    public FlowSettings getFlowSettings() {
        return this.myFlowSettings;
    }

    public void setFlowSettings(@NotNull FlowSettings flowSettings) {
        if (flowSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowSettings", "com/intellij/lang/javascript/flow/FlowSettingsManager", "setFlowSettings"));
        }
        this.myFlowSettings = flowSettings;
    }

    public static FlowSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowSettingsManager", "getInstance"));
        }
        return (FlowSettingsManager)ServiceManager.getService((Project)project, FlowSettingsManager.class);
    }
}

