/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.editing.JavascriptCommenter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nullable;

public class JSXCommentProvider
implements MultipleLangCommentProvider {
    @Nullable
    public Commenter getLineCommenter(PsiFile file, Editor editor, Language lineStartLanguage, Language lineEndLanguage) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)at, XmlTag.class, (boolean)false);
        if (tag != null) {
            return new JSXCommenter();
        }
        return new JavascriptCommenter();
    }

    public boolean canProcess(PsiFile file, FileViewProvider viewProvider) {
        return DialectDetector.isJSX((PsiElement)file);
    }

    private static class JSXCommenter
    extends JavascriptCommenter {
        private JSXCommenter() {
        }

        @Override
        public String getLineCommentPrefix() {
            return null;
        }

        @Override
        public String getBlockCommentPrefix() {
            return "{/*";
        }

        @Override
        public String getBlockCommentSuffix() {
            return "*/}";
        }
    }
}

