/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSSubclassIndex;
import com.intellij.lang.javascript.psi.stubs.JSTypedefIndex;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.TreeItem;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluateManager {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.index.JSTypeEvaluateManager");

    public static String getBaseArrayType(String type) {
        if (JSTypeEvaluateManager.isArrayType(type) && type.contains("[]")) {
            return "Array";
        }
        return type;
    }

    public static Collection<JSPsiElementBase> findNearestExtendedJSTypes(JSPsiElementBase function, @NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "findNearestExtendedJSTypes"));
        }
        final LinkedList extendedTypes = new LinkedList();
        THashSet hasNonImplicitNamespaceElement = new THashSet();
        final JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)function).getClassResolver();
        final PsiFile psiFile = function.getContainingFile();
        JSTypeEvaluateManager.iterateTypeHierarchy((PsiElement)function, Collections.singletonList(qName), false, false, new NamespaceProcessor((Set)hasNonImplicitNamespaceElement){
            final /* synthetic */ Set val$hasNonImplicitNamespaceElement;
            {
                this.val$hasNonImplicitNamespaceElement = set;
            }

            @Override
            public boolean process(String serializedType, VirtualFile file) {
                JSType type = JSTypeUtils.createType(serializedType, JSTypeSource.EMPTY);
                if (type == null || type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC) {
                    return true;
                }
                String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
                if (qName == null) {
                    return true;
                }
                for (JSPsiElementBase element : resolver.findElementsByQNameIncludingImplicit(qName, JSResolveUtil.getResolveScope((PsiElement)psiFile))) {
                    extendedTypes.add(Pair.create((Object)element, (Object)qName));
                    if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance()) continue;
                    this.val$hasNonImplicitNamespaceElement.add(qName);
                }
                return true;
            }
        }, null);
        ArrayList<JSPsiElementBase> result = new ArrayList<JSPsiElementBase>(extendedTypes.size());
        for (Pair type : extendedTypes) {
            JSPsiElementBase element = (JSPsiElementBase)type.first;
            if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() && hasNonImplicitNamespaceElement.contains(type.second)) continue;
            result.add(element);
        }
        return result;
    }

    public static boolean iterateTypeHierarchy(@NotNull PsiElement context, @Nullable String type, @NotNull NamespaceProcessor namespaceProcessor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateTypeHierarchy"));
        }
        if (namespaceProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceProcessor", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateTypeHierarchy"));
        }
        return type != null && JSTypeEvaluateManager.iterateTypeHierarchy(context, Collections.singletonList(type), true, namespaceProcessor);
    }

    public static boolean iterateTypeHierarchy(@NotNull PsiElement context, @NotNull Collection<String> initialTypes, boolean processObjectClass, @NotNull NamespaceProcessor namespaceProcessor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateTypeHierarchy"));
        }
        if (initialTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialTypes", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateTypeHierarchy"));
        }
        if (namespaceProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceProcessor", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateTypeHierarchy"));
        }
        return JSTypeEvaluateManager.iterateTypeHierarchy(context, initialTypes, processObjectClass, true, namespaceProcessor, null);
    }

    public static boolean iterateTypeHierarchy(@NotNull PsiElement context, @NotNull Collection<String> initialTypes, boolean processObjectClass, boolean withGrandparents, @NotNull NamespaceProcessor namespaceProcessor, @Nullable Processor<JSObjectLiteralExpression> elementsProcessor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateTypeHierarchy"));
        }
        if (initialTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialTypes", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateTypeHierarchy"));
        }
        if (namespaceProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceProcessor", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateTypeHierarchy"));
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        ArrayList<String> descendants = new ArrayList<String>(initialTypes);
        SmartList currentTypeBaseElements = new SmartList();
        THashMap visited = new THashMap();
        for (int at = 0; at != descendants.size(); ++at) {
            String currentTypeName = (String)descendants.get(at);
            List virtualFiles = (List)visited.get((Object)currentTypeName);
            if (virtualFiles != null) {
                JSResolveUtil.sortFiles(virtualFiles);
                for (VirtualFile file : virtualFiles) {
                    if (namespaceProcessor.process(currentTypeName, file)) continue;
                    return false;
                }
                virtualFiles.clear();
            }
            if (at == 0 || withGrandparents) {
                currentTypeBaseElements.clear();
                String nsName = JSBaseTypesIndex.getTypeToSearchBaseTypes(currentTypeName);
                boolean result = StubIndex.getInstance().processElements(JSBaseTypesIndex.KEY, (Object)nsName, context.getProject(), scope, JSElement.class, arg_0 -> JSTypeEvaluateManager.lambda$iterateTypeHierarchy$0(nsName, visited, descendants, (List)currentTypeBaseElements, arg_0));
                if (!result) {
                    return false;
                }
            }
            if (elementsProcessor == null) continue;
            for (JSObjectLiteralExpression element : currentTypeBaseElements) {
                if (elementsProcessor.process((Object)element)) continue;
                return false;
            }
        }
        if (processObjectClass && !visited.contains((Object)"Object") && !initialTypes.contains("Object")) {
            PsiFile containingFile = context.getContainingFile().getOriginalFile();
            return namespaceProcessor.process("Object", containingFile.getVirtualFile());
        }
        return true;
    }

    @NotNull
    public static TreeItem<String> buildSuperClassesHierarchy(@NotNull String type, @NotNull GlobalSearchScope scope) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "buildSuperClassesHierarchy"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "buildSuperClassesHierarchy"));
        }
        TreeItem root = new TreeItem((Object)type);
        THashSet visited = new THashSet();
        visited.add(type);
        JSTypeEvaluateManager.addSuperClasses((TreeItem<String>)root, (Set<String>)visited, scope);
        TreeItem treeItem = root;
        if (treeItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "buildSuperClassesHierarchy"));
        }
        return treeItem;
    }

    private static void addSuperClasses(TreeItem<String> node, Set<String> visited, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "addSuperClasses"));
        }
        String nsName = JSTypeUtils.getTypeMatchingNamespace((String)node.getData());
        StubIndex.getInstance().processElements(JSBaseTypesIndex.KEY, (Object)nsName, scope.getProject(), scope, JSElement.class, element -> {
            Collection baseTypes;
            JSElementIndexingData indexingData;
            JSElementIndexingData jSElementIndexingData = indexingData = element instanceof JSImplicitElementProvider ? ((JSImplicitElementProvider)element).getIndexingData() : null;
            if (indexingData != null && (baseTypes = indexingData.getBaseTypes()) != null) {
                for (Pair baseType : baseTypes) {
                    if (!nsName.equals(baseType.first)) continue;
                    node.addChild(new TreeItem(baseType.second));
                }
            }
            return true;
        });
        for (TreeItem child : node.getChildren()) {
            if (!visited.add((String)child.getData())) continue;
            JSTypeEvaluateManager.addSuperClasses((TreeItem<String>)child, visited, scope);
        }
    }

    @Nullable
    public static TreeItem<String> findSuperClass(@NotNull TreeItem<String> root, @NotNull String parentClassName) {
        String rootQName;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "findSuperClass"));
        }
        if (parentClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClassName", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "findSuperClass"));
        }
        JSType type = JSTypeUtils.createType((String)root.getData(), JSTypeSource.EXPLICITLY_DECLARED);
        String string = rootQName = type != null ? JSTypeUtils.getQualifiedNameMatchingType(type, true) : null;
        if (parentClassName.equals(rootQName)) {
            return root;
        }
        for (TreeItem child : root.getChildren()) {
            TreeItem<String> childSuper = JSTypeEvaluateManager.findSuperClass((TreeItem<String>)child, parentClassName);
            if (childSuper == null) continue;
            return childSuper;
        }
        return null;
    }

    @Nullable
    public static JSType expandTypedefs(@Nullable PsiElement context, @NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "expandTypedefs"));
        }
        THashMap visited = new THashMap();
        THashSet notVisited = new THashSet();
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor((Map)visited, (Set)notVisited){
            final /* synthetic */ Map val$visited;
            final /* synthetic */ Set val$notVisited;
            {
                this.val$visited = map;
                this.val$notVisited = set;
            }

            public void visitJSTypeImpl(JSType type) {
                String resolvedTypeText;
                if (((JSTypeImpl)type).isExplicitlyDeclared() && !this.val$visited.containsKey(resolvedTypeText = type.getResolvedTypeText())) {
                    this.val$notVisited.add(resolvedTypeText);
                }
            }
        };
        notVisited.add(typeName);
        while (!notVisited.isEmpty()) {
            String next = (String)notVisited.iterator().next();
            notVisited.remove(next);
            JSType value = JSTypeEvaluateManager.getTypedefValue(context, next);
            visited.put(next, value);
            if (value == null) continue;
            value.accept(visitor);
        }
        Ref substitutionsLeft = Ref.create((Object)30);
        Function mapping = arg_0 -> JSTypeEvaluateManager.lambda$expandTypedefs$2((Map)visited, substitutionsLeft, arg_0);
        JSType typedefValue = (JSType)visited.get(typeName);
        return typedefValue != null ? JSTypeUtils.applyCompositeMapping(typedefValue, (Function<JSType, JSType>)mapping) : null;
    }

    @Nullable
    public static JSType getTypedefValue(@Nullable PsiElement context, String typeName) {
        if (context == null) {
            return null;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        Ref associatedType = Ref.create(null);
        Ref associatedTypeSource = Ref.create(null);
        StubIndex.getInstance().processElements(JSTypedefIndex.KEY, (Object)typeName, context.getProject(), scope, JSElement.class, element -> {
            if (!(element instanceof JSImplicitElementProvider)) {
                LOG.error("only JSImplicitElementProviders should add info to typedef index");
                return true;
            }
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            if (data == null) {
                LOG.error("JSElementIndexingData mustn't be null for element referenced in typedef index");
                return true;
            }
            Collection typedefs = data.getTypedefs();
            if (typedefs == null || typedefs.isEmpty()) {
                LOG.error("JSElementIndexingData.getTypedef() mustn't be null");
                return true;
            }
            for (Pair typedef : typedefs) {
                if (!typeName.equals(typedef.first)) continue;
                associatedType.set((Object)JSTypedefIndex.getTypeByIndexValue((String)typedef.second));
                JSElement sourceElement = element;
                Collection implicitElements = data.getImplicitElements();
                if (implicitElements != null) {
                    for (JSImplicitElement implicitElement : implicitElements) {
                        if (!((String)typedef.first).equals(implicitElement.getQualifiedName())) continue;
                        sourceElement = implicitElement;
                        break;
                    }
                }
                associatedTypeSource.set((Object)sourceElement);
            }
            return false;
        });
        if (!associatedType.isNull()) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)associatedTypeSource.get(), true);
            return JSTypeUtils.createType((String)associatedType.get(), source);
        }
        return null;
    }

    public static boolean iterateSubclasses(@NotNull PsiElement context, @NotNull String typeName, NamespaceProcessor processor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateSubclasses"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/lang/javascript/index/JSTypeEvaluateManager", "iterateSubclasses"));
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        THashMap indexValues = new THashMap();
        Collection elements = StubIndex.getElements(JSSubclassIndex.KEY, (Object)typeName, (Project)context.getProject(), (GlobalSearchScope)scope, JSElement.class);
        for (JSElement element : elements) {
            Collection baseTypes;
            JSElementIndexingData indexingData = element instanceof JSImplicitElementProvider ? ((JSImplicitElementProvider)element).getIndexingData() : null;
            if (indexingData == null || (baseTypes = indexingData.getBaseTypes()) == null) continue;
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            Set fileBaseTypes = (Set)indexValues.get(virtualFile);
            if (fileBaseTypes == null) {
                fileBaseTypes = new THashSet();
                indexValues.put(virtualFile, fileBaseTypes);
            }
            for (Pair baseType : baseTypes) {
                fileBaseTypes.add(baseType.first);
            }
        }
        Collection<VirtualFile> files = JSResolveUtil.sortFiles(indexValues.keySet());
        for (VirtualFile file : files) {
            for (String s : (Set)indexValues.get(file)) {
                if (processor.process(s, file)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isArrayType(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith("[]") || s.indexOf(91) != -1 || s.startsWith("...") || s.indexOf(60) != -1 && (s.startsWith("Vector") || s.startsWith("Array") || s.startsWith("Object"));
    }

    public static String getComponentType(String s) {
        JSType type;
        if (s.endsWith("[]")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.startsWith("...")) {
            return s.substring(3);
        }
        int i = s.indexOf(91);
        if (i != -1) {
            return s.substring(i + 1);
        }
        if (s.indexOf(60) != -1 && (s.startsWith("Vector") || s.startsWith("Array") || s.startsWith("Object")) && (type = new JSTypeParser(s, JSTypeSource.EMPTY).parse()) instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            List<JSType> genericArguments = genericType.getArguments();
            JSType lastGenericType = genericArguments.get(genericArguments.size() - 1);
            return lastGenericType.getResolvedTypeText();
        }
        return s;
    }

    private static /* synthetic */ JSType lambda$expandTypedefs$2(Map visited, Ref substitutionsLeft, JSType type) {
        JSType typedefValue;
        if (type instanceof JSTypeImpl && (typedefValue = (JSType)visited.get(type.getResolvedTypeText())) != null && (Integer)substitutionsLeft.get() > 0) {
            substitutionsLeft.set((Object)((Integer)substitutionsLeft.get() - 1));
            return typedefValue;
        }
        return type;
    }

    private static /* synthetic */ boolean lambda$iterateTypeHierarchy$0(String nsName, THashMap visited, List descendants, List currentTypeBaseElements, JSElement element) {
        VirtualFile file = element.getContainingFile().getVirtualFile();
        if (element instanceof JSImplicitElementProvider) {
            Collection baseTypes;
            JSElementIndexingData indexingData = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = baseTypes = indexingData != null ? indexingData.getBaseTypes() : null;
            if (baseTypes != null) {
                for (Pair inheritance : baseTypes) {
                    if (!nsName.equals(inheritance.first)) continue;
                    String inherited = (String)inheritance.second;
                    List virtualFiles1 = (List)visited.get((Object)inherited);
                    if (virtualFiles1 == null) {
                        virtualFiles1 = new SmartList();
                        visited.put((Object)inherited, (Object)virtualFiles1);
                        descendants.add(inherited);
                    }
                    if (virtualFiles1.contains(file)) continue;
                    virtualFiles1.add(file);
                }
            }
        } else if (element instanceof JSObjectLiteralExpression) {
            currentTypeBaseElements.add((JSObjectLiteralExpression)element);
        }
        return true;
    }

    public static interface NamespaceProcessor {
        public boolean process(String var1, VirtualFile var2);
    }
}

