/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexedFilesFilterProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSNameIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.SoftValueHashMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaScriptIndex
extends AbstractProjectComponent {
    public static final FileBasedIndex.InputFilter ourIndexedFilesFilter = new FileBasedIndex.FileTypeSpecificInputFilter(){
        private final int MAX_JS_FILESIZE_LIMIT = Math.max(FileUtilRt.getUserFileSizeLimit(), 0xA00000);
        final JSIndexedFilesFilterProvider[] additionalFilters = (JSIndexedFilesFilterProvider[])Extensions.getExtensions(JSIndexedFilesFilterProvider.EP_NAME);

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JavaScriptIndex$1", "acceptInput"));
            }
            FileType fileType = file.getFileType();
            if (!JavaScriptIndex.getFileTypesForJSCompletion().contains(fileType)) {
                return false;
            }
            if (fileType == HtmlFileType.INSTANCE && file.getFileSystem().getProtocol().equals("jar")) {
                return false;
            }
            String name = file.getName();
            int cacheIndex = name.indexOf(".cache.");
            if (cacheIndex != -1 && name.endsWith(".js")) {
                boolean justHexDigits = cacheIndex > 0;
                for (int i = 0; i < cacheIndex && justHexDigits; ++i) {
                    justHexDigits = StringUtil.isHexDigit((char)name.charAt(i));
                }
                if (justHexDigits) {
                    return false;
                }
            }
            if (this.isMinifiedCopy(file)) {
                return false;
            }
            if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)this.MAX_JS_FILESIZE_LIMIT)) {
                return false;
            }
            for (JSIndexedFilesFilterProvider filter : this.additionalFilters) {
                if (filter.acceptInput(file)) continue;
                return false;
            }
            return true;
        }

        private boolean isMinifiedCopy(@NotNull VirtualFile file) {
            String devName;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JavaScriptIndex$1", "isMinifiedCopy"));
            }
            String name = file.getName();
            return !StringUtil.equals((CharSequence)name, (CharSequence)(devName = JSLibraryUtil.getDevVersionLocation(name))) && file.getParent() != null && file.getParent().findChild(devName) != null;
        }

        public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
            if (fileTypeSink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/lang/javascript/index/JavaScriptIndex$1", "registerFileTypesUsedForIndexing"));
            }
            for (FileType ft : JavaScriptIndex.getFileTypesForJSCompletion()) {
                fileTypeSink.consume((Object)ft);
            }
        }
    };
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.index.JavaScriptIndex");
    @NonNls
    static final String DHTML_XML_FILE_NAME = "DHTML.xml";
    public static final String ECMASCRIPT_JS2 = "ECMAScript.js2";
    public static final String E4X_JS2 = "E4X.js2";
    public static final String ECMASCRIPT_JS = "EcmaScript.js";
    public static final String LIB_D_TS = "lib.d.ts";
    public static final String LIB_ES6_D_TS = "lib.es6.d.ts";
    public static final String REACT_D_TS = "react.d.ts";
    public static final String LIB_ES7_D_TS = "lib.es7.d.ts";
    public static final Collection<String> LIBS_D_TS = ContainerUtil.newHashSet((Object[])new String[]{"lib.d.ts", "lib.es6.d.ts", "lib.es7.d.ts"});
    public static final Collection<String> CORE_LIBS_D_TS = ContainerUtil.newHashSet((Object[])new String[]{"lib.core.d.ts", "lib.core.es6.d.ts", "lib.core.es7.d.ts", "lib.webworker.d.ts", "lib.es5.d.ts", "lib.es2015.d.ts ", "lib.es2016.d.ts ", "lib.es2017.d.ts ", "lib.es2015.core.d.ts", "lib.es2016.core.d.ts", "lib.es2017.core.d.ts", "typescriptServices.d.ts", "lib.scriptHost.d.ts"});
    private static final int BASE_VERSION = 171;
    private static final int COMPUTED_TOTAL_VERSION = FrameworkIndexingHandler.computeTotalVersion(171);
    private final PsiModificationTracker myModificationTracker;
    private ScriptingLibraryManager myLibraryManager;
    private final Lock myCachesReadLock;
    private final Lock myCachesWriteLock;
    private final Map<GlobalSearchScope, Map<String, PsiElement>> myTopLevelResolveResult;
    private volatile long myModificationStamp;
    private final PsiManager myPsiManager;
    private static final NotNullLazyValue<Set<FileType>> ourFileTypesForJSCompletion = NotNullLazyValue.createValue(() -> {
        HashSet fileTypesForJSCompletion = new HashSet();
        fileTypesForJSCompletion.add(HtmlFileType.INSTANCE);
        for (FileType type : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            Language language;
            if (!(type instanceof LanguageFileType) || !(language = ((LanguageFileType)type).getLanguage()).isKindOf((Language)JavascriptLanguage.INSTANCE) && (!(language instanceof TemplateLanguage) || LanguageParserDefinitions.INSTANCE.forLanguage(language) == null)) continue;
            fileTypesForJSCompletion.add(type);
        }
        return fileTypesForJSCompletion;
    });

    @NotNull
    public static Set<FileType> getFileTypesForJSCompletion() {
        Set set = (Set)ourFileTypesForJSCompletion.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JavaScriptIndex", "getFileTypesForJSCompletion"));
        }
        return set;
    }

    public JavaScriptIndex(Project project, PsiManager psiManager, JSLibraryManager libraryManager) {
        super(project);
        ReentrantReadWriteLock ourLock = new ReentrantReadWriteLock();
        this.myCachesReadLock = ourLock.readLock();
        this.myCachesWriteLock = ourLock.writeLock();
        this.myTopLevelResolveResult = new THashMap();
        this.myPsiManager = psiManager;
        this.myLibraryManager = libraryManager;
        this.myModificationTracker = this.myPsiManager.getModificationTracker();
    }

    public static int getVersionStatic() {
        return COMPUTED_TOTAL_VERSION;
    }

    public static boolean isAcceptableFile(VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && ourIndexedFilesFilter.acceptInput(fileOrDir);
    }

    public void projectClosed() {
        this.clear();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("JavaScriptIndex" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JavaScriptIndex", "getComponentName"));
        }
        return "JavaScriptIndex";
    }

    private void doClear(long modificationCount) {
        this.myCachesWriteLock.lock();
        this.myLibraryManager = (ScriptingLibraryManager)ServiceManager.getService((Project)this.myProject, JSLibraryManager.class);
        this.myLibraryManager.clearCaches();
        try {
            this.myTopLevelResolveResult.clear();
            this.myModificationStamp = modificationCount;
        }
        finally {
            this.myCachesWriteLock.unlock();
        }
    }

    public void disposeComponent() {
        this.clear();
    }

    public static JavaScriptIndex getInstance(Project project) {
        return (JavaScriptIndex)((Object)project.getComponent(JavaScriptIndex.class));
    }

    public void clear() {
        this.doClear(this.myModificationTracker.getModificationCount());
    }

    public NavigationItem[] getFileByName(String name, boolean includeNonProjectItems) {
        return FilenameIndex.getFilesByName((Project)this.myProject, (String)name, (GlobalSearchScope)this.getCollectScope(includeNonProjectItems));
    }

    private GlobalSearchScope getCollectScope(boolean includeNonProjectItems) {
        return includeNonProjectItems ? JSResolveUtil.getJavaScriptSymbolsResolveScope(this.myProject) : ProjectScope.getContentScope((Project)this.myProject);
    }

    public final Project getProject() {
        return this.myProject;
    }

    public String[] getSymbolNames() {
        HashSet symbolNames = new HashSet();
        symbolNames.addAll(StubIndex.getInstance().getAllKeys(JSSymbolIndex2.KEY, this.myProject));
        symbolNames.addAll(StubIndex.getInstance().getAllKeys(JSNameIndex.KEY, this.myProject));
        return ArrayUtil.toStringArray((Collection)symbolNames);
    }

    @NotNull
    public NavigationItem[] getSymbolsByName(String name, boolean includeNonProjectItems) {
        NavigationItem[] navigationItemArray = this.processSymbols(name, includeNonProjectItems, false);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JavaScriptIndex", "getSymbolsByName"));
        }
        return navigationItemArray;
    }

    @NotNull
    private NavigationItem[] processSymbols(String name, boolean includeNonProjectItems, boolean justClasses) {
        GlobalSearchScope scope = this.getCollectScope(includeNonProjectItems);
        Collection<JSPsiElementBase> symbolNavItems = JSClassResolver.findElementsByNameIncludingImplicit(name, scope, justClasses);
        if (!justClasses) {
            Collection<JSQualifiedNamedElement> qualified = JSResolveUtil.findElementsByName(name, this.myProject, scope);
            Iterator<JSQualifiedNamedElement> q = qualified.iterator();
            while (q.hasNext()) {
                JSQualifiedNamedElement element = q.next();
                if (JavaScriptIndex.isFromSwc(element)) continue;
                q.remove();
            }
            symbolNavItems.addAll(qualified);
        }
        NavigationItem[] navigationItemArray = symbolNavItems.toArray(new NavigationItem[symbolNavItems.size()]);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JavaScriptIndex", "processSymbols"));
        }
        return navigationItemArray;
    }

    private static boolean isFromSwc(JSQualifiedNamedElement element) {
        return element.getContainingFile().getVirtualFile().getName().endsWith(".swf");
    }

    public String[] getNavigatableClassNames() {
        return this.getSymbolNames();
    }

    public NavigationItem[] getClassByName(String name, boolean includeNonProjectItems) {
        return this.processSymbols(name, includeNonProjectItems, true);
    }

    public PsiManager getPsiManager() {
        return this.myPsiManager;
    }

    public static String intern(String name) {
        return RecentStringHolder.ourSerializationManager.internString(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rememberTopLevelClassElement(String link, GlobalSearchScope scope, @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/index/JavaScriptIndex", "rememberTopLevelClassElement"));
        }
        this.myCachesWriteLock.lock();
        try {
            SoftValueHashMap map = this.myTopLevelResolveResult.get(scope);
            if (map == null) {
                map = new SoftValueHashMap();
                this.myTopLevelResolveResult.put(scope, (Map<String, PsiElement>)map);
            }
            map.put(link, psiElement);
        }
        finally {
            this.myCachesWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiElement recallClass(String link, GlobalSearchScope scope) {
        if (this.invalidateIfNeeded()) {
            return null;
        }
        try {
            this.myCachesReadLock.lock();
            Map<String, PsiElement> map = this.myTopLevelResolveResult.get(scope);
            if (map != null) {
                PsiElement psiElement = map.get(link);
                return psiElement;
            }
        }
        finally {
            this.myCachesReadLock.unlock();
        }
        return null;
    }

    boolean invalidateIfNeeded() {
        long count = this.myModificationTracker.getModificationCount();
        if (this.myModificationStamp != count) {
            this.doClear(count);
            return true;
        }
        return false;
    }

    private static final class RecentStringHolder {
        private static final SerializationManager ourSerializationManager = SerializationManager.getInstance();

        private RecentStringHolder() {
        }
    }
}

