/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSConstructorReturnsPrimitiveInspection
extends JSInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.constructor.returns.primitive.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReturnStatement(JSReturnStatement node) {
                JSTypeSource source;
                DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
                if (dialect != null && !dialect.isJavaScript()) {
                    return;
                }
                super.visitJSReturnStatement(node);
                JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
                if (function == null) {
                    return;
                }
                String name = function.getName();
                if (!JSSymbolUtil.isDefinitelyConstructor((PsiElement)function) && !JSSymbolUtil.isConstructorName(name)) {
                    return;
                }
                JSType returnType = function.getReturnType();
                if (returnType != null && (source = returnType.getSource()) != null && source.isExplicitlyDeclared()) {
                    return;
                }
                JSExpression expression = node.getExpression();
                JSType type = JSResolveUtil.getExpressionJSType(expression);
                if (type instanceof JSPrimitiveType && ((JSPrimitiveType)type).isPrimitive() || type instanceof JSNullType || type instanceof JSUndefinedType) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.constructor.returns.primitive.inspection.problem", (Object[])new Object[0]), new LocalQuickFix[]{new SetJSDocReturnTypeFix(type.getTypeText(JSType.TypeTextFormat.CODE))});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static class SetJSDocReturnTypeFix
    implements LocalQuickFix {
        private final String myType;

        private SetJSDocReturnTypeFix(String type) {
            this.myType = type;
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"js.constructor.returns.primitive.inspection.quickfix", (Object[])new Object[]{this.myType});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection$SetJSDocReturnTypeFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection$SetJSDocReturnTypeFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection$SetJSDocReturnTypeFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection$SetJSDocReturnTypeFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiFile file = element.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
            if (function != null) {
                List<String> tagsToCreate = Collections.singletonList("return {" + this.myType + "}");
                JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)function, tagsToCreate, null, null);
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                if (document != null) {
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                }
            }
        }
    }
}

