/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JSUnusedGlobalSymbolsInspection
extends JSInspection {
    public boolean myReportUnusedDefinitions;
    public boolean myReportUnusedProperties;
    private static ImplicitUsageProvider[] myExtensions = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME);

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.global.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (!JSResolveUtil.isSelfReference((PsiElement)node)) {
                    return;
                }
                JSNamedElement parent = (JSNamedElement)node.getParent();
                if (parent instanceof JSFunctionExpression) {
                    return;
                }
                this.checkUnused(parent);
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$1", "visitJSFunctionExpression"));
                }
                PsiElement parent = node.getParent();
                if (parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSCallExpression || parent instanceof JSArgumentList || parent instanceof JSReturnStatement || parent instanceof JSParenthesizedExpression && parent.getParent() instanceof JSCallExpression) {
                    return;
                }
                this.checkUnused((JSNamedElement)node);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$1", "visitJSFunctionDeclaration"));
                }
                this.checkUnused((JSNamedElement)node);
            }

            public void visitJSVariable(JSVariable node) {
                PsiElement nameIdentifier = node.getNameIdentifier();
                if (!(nameIdentifier instanceof JSReferenceExpression)) {
                    this.checkUnused((JSNamedElement)node);
                }
            }

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                JSExpression expression = node.getExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
                    boolean doCheck = JSUnusedGlobalSymbolsInspection.this.myReportUnusedDefinitions;
                    if (qualifier instanceof JSThisExpression || qualifier instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)qualifier).getReferencedName())) {
                        doCheck = true;
                    }
                    if (!doCheck) {
                        return;
                    }
                    PsiElement parent = node.getParent();
                    if (parent instanceof JSAssignmentExpression) {
                        PsiElement resolve;
                        JSReferenceExpression refExpr = (JSReferenceExpression)expression;
                        JSExpression rOperand = ((JSAssignmentExpression)parent).getROperand();
                        if (rOperand != null && ((resolve = refExpr.resolve()) == node || resolve == rOperand)) {
                            this.checkUnused((JSNamedElement)node);
                        }
                    }
                }
            }

            public void visitJSProperty(JSProperty node) {
                JSFunction value = node.tryGetFunctionInitializer();
                if (!JSUnusedGlobalSymbolsInspection.this.myReportUnusedProperties && value == null) {
                    return;
                }
                PsiElement nameIdentifier = node.getNameIdentifier();
                if (nameIdentifier == null || !StringUtil.isJavaIdentifier((String)nameIdentifier.getText())) {
                    return;
                }
                PsiPolyVariantReference reference = node.getPropertyNameReference();
                if (reference != null) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = reference.multiResolve(false)) {
                        if (!result.isValidResult() || result.getElement() == node) continue;
                        return;
                    }
                }
                this.checkUnused((JSNamedElement)node);
            }

            private void checkUnused(JSNamedElement namedElement) {
                if (namedElement instanceof JSPackageStatement) {
                    return;
                }
                if (namedElement instanceof JSFunction && !JSInheritanceUtil.iterateOverriddenMethodsUp((JSFunction)namedElement, (Processor<JSFunction>)CommonProcessors.alwaysFalse())) {
                    return;
                }
                PsiElement elementParent = namedElement.getParent();
                if (namedElement instanceof JSFunction && ((JSFunction)namedElement).isConstructor() && elementParent instanceof JSFile && elementParent.getContext() != null) {
                    return;
                }
                String name = namedElement.getName();
                if (name == null) {
                    return;
                }
                if (!JSUnusedLocalSymbolsInspection.isLocallyDefined(namedElement)) {
                    JSNamedElement elementToSearchUsages = namedElement;
                    if (elementToSearchUsages instanceof JSFunction) {
                        List implementedMethods;
                        JSFunction topOverriddenMethod;
                        JSFunction fun = (JSFunction)elementToSearchUsages;
                        if ("toString".equals(name)) {
                            return;
                        }
                        if (name.length() < 3) {
                            return;
                        }
                        JSAttributeList attrList = fun.getAttributeList();
                        if (attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) && (topOverriddenMethod = JSInheritanceUtil.findTopOverriddenMethod(fun)) != null) {
                            elementToSearchUsages = topOverriddenMethod;
                        }
                        Collection<Object> collection = implementedMethods = fun.isConstructor() ? Collections.emptyList() : JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)elementToSearchUsages);
                        if (!implementedMethods.isEmpty()) {
                            return;
                        }
                    }
                    Project project = elementToSearchUsages.getProject();
                    ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    VirtualFile file = elementToSearchUsages.getContainingFile().getVirtualFile();
                    if (file == null || projectFileIndex.isInLibraryClasses(file) || projectFileIndex.isInLibrarySource(file) || JSLibraryUtil.isProbableLibraryFile(file, project.getBaseDir())) {
                        return;
                    }
                    SearchScope scope = elementToSearchUsages.getUseScope();
                    if (!(scope instanceof GlobalSearchScope)) {
                        return;
                    }
                    if (!GlobalSearchScope.allScope((Project)project).contains(file)) {
                        return;
                    }
                    GlobalSearchScope scopeForSearch = JSUnusedGlobalSymbolsInspection.skipLibraryFiles(project, (GlobalSearchScope)scope);
                    PsiSearchHelper.SearchCostResult cheapEnough = PsiSearchHelper.SERVICE.getInstance((Project)project).isCheapEnoughToSearch(name, scopeForSearch, namedElement.getContainingFile(), this.progress);
                    if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                        return;
                    }
                    boolean unused = JSUnusedGlobalSymbolsInspection.calcUnused(elementToSearchUsages, (SearchScope)scopeForSearch);
                    if (unused) {
                        if (namedElement instanceof JSClass) {
                            JSFunction constructor = ((JSClass)namedElement).getConstructor();
                            if (constructor != null) {
                                unused = JSUnusedGlobalSymbolsInspection.calcUnused((JSNamedElement)constructor, (PsiElement)namedElement, (SearchScope)scopeForSearch);
                            }
                        } else if (namedElement instanceof JSFunction && ((JSFunction)namedElement).isConstructor() && elementParent instanceof JSClass) {
                            unused = JSUnusedGlobalSymbolsInspection.calcUnused((JSNamedElement)((JSClass)elementParent), (SearchScope)scopeForSearch);
                        }
                    }
                    if (unused) {
                        JSNamedElementKind namedElementKind = JSNamedElementKind.kind(namedElement, false);
                        ASTNode nameIdentifierNode = namedElement.findNameIdentifier();
                        if (nameIdentifierNode == null) {
                            return;
                        }
                        PsiElement nameIdentifier = nameIdentifierNode.getPsi();
                        FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(namedElementKind, name);
                        fix.registerElementRefForFix(nameIdentifier, null);
                        LocalQuickFix[] fixes = new LocalQuickFix[]{fix};
                        holder.registerProblem(nameIdentifier, JSUnusedLocalSymbolsInspection.unusedMessage(namedElementKind), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes);
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    public static boolean calcUnused(JSNamedElement element, SearchScope scope) {
        return JSUnusedGlobalSymbolsInspection.calcUnused(element, (PsiElement)element, scope);
    }

    private static boolean calcUnused(JSNamedElement element, PsiElement ignoreUsagesAmongChildrenOfThisElement, SearchScope scope) {
        for (ImplicitUsageProvider provider : myExtensions) {
            if (!provider.isImplicitUsage((PsiElement)element)) continue;
            return false;
        }
        boolean def = element instanceof JSDefinitionExpression;
        Query psiReferenceQuery = ReferencesSearch.search((PsiElement)element, (SearchScope)scope, (boolean)true);
        return psiReferenceQuery.forEach(psiReference -> {
            PsiElement parent;
            PsiElement psiElement = psiReference.getElement();
            if (JSResolveUtil.isSelfReference(psiElement) || JSUnusedGlobalSymbolsInspection.isSelfUsed(psiElement, ignoreUsagesAmongChildrenOfThisElement)) {
                return true;
            }
            return def && (parent = psiElement.getParent()) instanceof JSDefinitionExpression;
        });
    }

    private static boolean isSelfUsed(PsiElement psiElement, PsiElement ignoreUsagesAmongChildrenOfThisElement) {
        if (PsiTreeUtil.isAncestor((PsiElement)ignoreUsagesAmongChildrenOfThisElement, (PsiElement)psiElement, (boolean)false)) {
            if (ignoreUsagesAmongChildrenOfThisElement instanceof JSClass) {
                return true;
            }
            JSFunction callback = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSFunction.class);
            return callback == null || !PsiTreeUtil.isAncestor((PsiElement)ignoreUsagesAmongChildrenOfThisElement, (PsiElement)callback, (boolean)true);
        }
        return false;
    }

    public static GlobalSearchScope skipLibraryFiles(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "skipLibraryFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "skipLibraryFiles"));
        }
        final VirtualFile projectBaseDir = project.getBaseDir();
        return scope.intersectWith(new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$2", "contains"));
                }
                return !JSLibraryUtil.isProbableLibraryFile(file, projectBaseDir);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$2", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$2", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$2", "isSearchInModuleContent"));
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        });
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.report.unused.properties", (Object[])new Object[0]), "myReportUnusedProperties");
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.report.unused.definitions", (Object[])new Object[0]), "myReportUnusedDefinitions");
        return optionsPanel;
    }
}

