/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.intentions.AnonymousToNamedFunctionIntention;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSFunctionExpressionToArrowFunctionIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    public JSFunctionExpressionToArrowFunctionIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.arrow.function", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionExpressionToArrowFunctionIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSFunctionExpressionToArrowFunctionIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element) || !ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        JSFunctionExpression functionExpression = AnonymousToNamedFunctionIntention.getFunctionExpression(element);
        if (functionExpression == null) {
            return false;
        }
        if (!new NameChecker(functionExpression).check()) {
            return false;
        }
        boolean anonymousNotArrow = JSPsiImplUtils.isArrowFunction((JSFunction)functionExpression) == null;
        return anonymousNotArrow && PsiTreeUtil.findChildOfType((PsiElement)functionExpression, JSThisExpression.class) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSFunctionExpression arrowFunction;
        boolean emptyBody;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionExpressionToArrowFunctionIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSFunctionExpressionToArrowFunctionIntention", "invoke"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
            return;
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(element);
        JSFunctionExpression functionExpression = AnonymousToNamedFunctionIntention.getFunctionExpression(element);
        if (functionExpression == null || JSPsiImplUtils.isArrowFunction((JSFunction)functionExpression) != null || PsiTreeUtil.findChildOfType((PsiElement)functionExpression, JSThisExpression.class) != null) {
            return;
        }
        NameChecker nameChecker = new NameChecker(functionExpression);
        if (!nameChecker.check()) {
            return;
        }
        nameChecker.rebindReferencesIfNeeded();
        boolean wrapWithParenthesis = functionExpression.getParent() instanceof JSReferenceExpression;
        JSParameterList parameterList = functionExpression.getParameterList();
        JSBlockStatement functionExpressionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)functionExpression, JSBlockStatement.class);
        String attributesModifiersText = JSFunctionsHelper.getFunctionAttributesModifiersText((JSFunction)functionExpression);
        boolean bl = emptyBody = functionExpressionBody == null;
        if (emptyBody) {
            if (parameterList != null && parameterList.getParameters().length == 1) {
                arrowFunction = (JSFunctionExpression)JSChangeUtil.createExpressionFromText(project, attributesModifiersText + parameterList.getParameters()[0].getName() + " => {}").getPsi(JSFunctionExpression.class);
            } else {
                arrowFunction = (JSFunctionExpression)JSChangeUtil.createExpressionFromText(project, attributesModifiersText + "() => {}").getPsi(JSFunctionExpression.class);
                if (parameterList != null) {
                    JSChangeUtil.replaceElement((JSElement)arrowFunction.getParameterList(), (JSElement)parameterList);
                }
            }
        } else {
            String shortBodyText = JSFunctionExpressionToArrowFunctionIntention.getShortBodyText(functionExpressionBody);
            String bodyTemplateText = shortBodyText != null ? shortBodyText : "{}";
            boolean shortParameters = (parameterList == null ? 0 : parameterList.getParameters().length) == 1;
            String functionText = attributesModifiersText;
            if (shortParameters) {
                String parameterName = parameterList.getParameterVariables()[0].getName();
                functionText = functionText + parameterName + "=>" + bodyTemplateText;
            } else {
                functionText = functionText + "()=>" + bodyTemplateText;
            }
            arrowFunction = (JSFunctionExpression)((JSExpressionStatement)JSChangeUtil.createJSTreeFromText(project, functionText, dialect).getPsi(JSExpressionStatement.class)).getFirstChild();
            if (shortBodyText == null) {
                JSBlockStatement arrowFunctionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)arrowFunction, JSBlockStatement.class);
                JSChangeUtil.replaceStatement((JSStatement)arrowFunctionBody, (JSStatement)functionExpressionBody);
            }
            if (!shortParameters && parameterList != null) {
                JSChangeUtil.replaceElement((JSElement)arrowFunction.getParameterList(), (JSElement)parameterList);
            }
        }
        if (wrapWithParenthesis) {
            JSParenthesizedExpression brackets = (JSParenthesizedExpression)JSChangeUtil.createExpressionFromText(project, "(1)").getPsi(JSParenthesizedExpression.class);
            JSChangeUtil.replaceExpression(brackets.getInnerExpression(), (JSExpression)arrowFunction);
            JSChangeUtil.replaceExpression((JSExpression)functionExpression, (JSExpression)brackets);
        } else {
            JSChangeUtil.replaceExpression((JSExpression)functionExpression, (JSExpression)arrowFunction);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)arrowFunction.getContainingFile(), arrowFunction.getTextRange().getStartOffset(), arrowFunction.getTextRange().getEndOffset());
    }

    private static String getShortBodyText(@NotNull JSBlockStatement block) {
        JSSourceElement statement;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/lang/javascript/intentions/JSFunctionExpressionToArrowFunctionIntention", "getShortBodyText"));
        }
        List elements = ContainerUtil.filter((Object[])block.getChildren(), element -> JSChangeUtil.isStatementOrComment(element));
        if (elements.size() == 1 && elements.get(0) instanceof JSSourceElement && (statement = (JSSourceElement)elements.get(0)) instanceof JSReturnStatement && ((JSReturnStatement)statement).getExpression() != null) {
            JSExpression expression = ((JSReturnStatement)statement).getExpression();
            if (expression instanceof JSObjectLiteralExpression) {
                return "(" + expression.getText() + ")";
            }
            return expression.getText();
        }
        return null;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.arrow.function.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSFunctionExpressionToArrowFunctionIntention", "getFamilyName"));
        }
        return string;
    }

    private static class NameChecker {
        private final JSFunctionExpression functionExpression;
        private String myNewNameIfRenameNeeded;

        public NameChecker(JSFunctionExpression functionExpression) {
            this.functionExpression = functionExpression;
        }

        public boolean check() {
            ASTNode nameNode = JSPsiImplUtils.findNameIdentifierOfFunction(this.functionExpression.getNode(), true);
            if (nameNode == null) {
                return true;
            }
            JSQualifiedNamedElement assignedTo = this.functionExpression.getElementAssignedTo();
            if (assignedTo != null && Comparing.equal((String)assignedTo.getName(), (String)nameNode.getText())) {
                return true;
            }
            Collection references = ReferencesSearch.search((PsiElement)this.functionExpression, (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.functionExpression.getContainingFile())).findAll();
            if (assignedTo == null) {
                return references.isEmpty();
            }
            for (PsiReference reference : references) {
                if (!(reference instanceof PsiElement) || PsiTreeUtil.isAncestor((PsiElement)this.functionExpression, (PsiElement)((PsiElement)reference), (boolean)false)) continue;
                return false;
            }
            if (!references.isEmpty()) {
                this.myNewNameIfRenameNeeded = assignedTo.getName();
                return true;
            }
            return true;
        }

        public void rebindReferencesIfNeeded() {
            if (this.myNewNameIfRenameNeeded != null && this.functionExpression.getElementAssignedTo() != null) {
                Collection references = ReferencesSearch.search((PsiElement)this.functionExpression, (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.functionExpression.getContainingFile())).findAll();
                for (PsiReference reference : references) {
                    if (!(reference instanceof PsiElement)) continue;
                    reference.bindToElement((PsiElement)this.functionExpression.getElementAssignedTo());
                }
            }
        }
    }
}

