/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class JSFunctionsHelper {
    public static JSFunction createAnonymousFunction(@NotNull Project project, JSFunction function) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createAnonymousFunction"));
        }
        return JSFunctionsHelper.createFunction(project, function, "");
    }

    public static JSFunction createGetter(@NotNull Project project, @NotNull JSFunction sourceFunction, @NotNull String name, boolean isStatic) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createGetter"));
        }
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createGetter"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createGetter"));
        }
        String functionText = "class d{" + (isStatic ? "static " : "") + "get " + name + "(){}}";
        ES6Class aClass = (ES6Class)JSChangeUtil.createExpressionFromText(project, functionText).getPsi(ES6Class.class);
        JSFunction function = (JSFunction)PsiTreeUtil.getChildOfType((PsiElement)aClass, JSFunction.class);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    public static JSFunction createSetter(@NotNull Project project, @NotNull JSFunction sourceFunction, @NotNull String name, boolean isStatic) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createSetter"));
        }
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createSetter"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createSetter"));
        }
        String functionText = "class d{" + (isStatic ? "static " : "") + "set " + name + "(){}}";
        ES6Class aClass = (ES6Class)JSChangeUtil.createExpressionFromText(project, functionText).getPsi(ES6Class.class);
        JSFunction function = (JSFunction)PsiTreeUtil.getChildOfType((PsiElement)aClass, JSFunction.class);
        JSFunctionsHelper.moveParameters(sourceFunction, function);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    public static JSFunction createFunction(@NotNull Project project, @NotNull JSFunction sourceFunction, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createFunction"));
        }
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createFunction"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createFunction"));
        }
        String functionText = "(" + JSFunctionsHelper.getFunctionAttributesModifiersText(sourceFunction) + "function " + name + "(){})";
        JSParenthesizedExpression expression = (JSParenthesizedExpression)JSChangeUtil.createExpressionFromText(project, functionText).getPsi(JSParenthesizedExpression.class);
        JSFunction function = (JSFunction)expression.getInnerExpression();
        JSFunctionsHelper.moveParameters(sourceFunction, function);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    public static String getFunctionAttributesModifiersText(@NotNull JSFunction sourceFunction) {
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "getFunctionAttributesModifiersText"));
        }
        if (JSFunctionsHelper.hasAttributesOfModifiers(sourceFunction)) {
            return sourceFunction.getAttributeList().getText() + " ";
        }
        return "";
    }

    private static boolean hasAttributesOfModifiers(@NotNull JSFunction sourceFunction) {
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "hasAttributesOfModifiers"));
        }
        return sourceFunction.getAttributeList() != null && !StringUtil.isEmptyOrSpaces((String)sourceFunction.getAttributeList().getText());
    }

    public static void moveParameters(JSFunction source, JSFunction target) {
        if (source.getParameters().length > 0) {
            JSParameterList sourceParameterList = source.getParameterList();
            assert (target.getParameterList() != null);
            if (JSFunctionsHelper.noBracesAroundSingleParameter(sourceParameterList) && sourceParameterList.getParameters().length == 1) {
                if (JSFunctionsHelper.noBracesAroundSingleParameter(target.getParameterList())) {
                    target.getParameterList().deleteChildRange(target.getParameterList().getFirstChild(), target.getParameterList().getLastChild());
                    target.getParameterList().add(sourceParameterList.getParameters()[0].copy());
                } else {
                    target.getParameterList().addAfter(sourceParameterList.getParameters()[0].copy(), target.getParameterList().getFirstChild());
                }
            } else {
                JSChangeUtil.replaceElement((JSElement)target.getParameterList(), (JSElement)sourceParameterList.copy());
            }
        }
    }

    private static boolean noBracesAroundSingleParameter(JSParameterList sourceParameterList) {
        return sourceParameterList.getParameters().length > 0 && sourceParameterList.getFirstChild() == sourceParameterList.getParameters()[0];
    }

    public static void moveFunctionBody(JSFunction source, JSFunction target) {
        JSBlockStatement targetBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)target, JSBlockStatement.class);
        JSBlockStatement sourceBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)source, JSBlockStatement.class);
        if (sourceBlock != null) {
            JSChangeUtil.replaceStatement((JSStatement)targetBlock, (JSStatement)sourceBlock.copy());
        } else {
            Iterator iterator = PsiTreeUtil.childIterator((PsiElement)source, PsiElement.class);
            while (iterator.hasNext()) {
                PsiElement next = (PsiElement)iterator.next();
                if (next instanceof JSParameterList || next instanceof JSAttributeList || !(next instanceof JSElement)) continue;
                if (!(next instanceof JSStatement)) {
                    String returnText = "return 1" + JSCodeStyleSettings.getSemicolon(source.getContainingFile());
                    JSReturnStatement statement = (JSReturnStatement)JSChangeUtil.createStatementFromText(source.getProject(), returnText).getPsi(JSReturnStatement.class);
                    JSElement element = (JSElement)next;
                    element = element instanceof JSParenthesizedExpression && ((JSParenthesizedExpression)element).getInnerExpression() != null ? ((JSParenthesizedExpression)element).getInnerExpression() : element;
                    JSChangeUtil.replaceElement((JSElement)statement.getExpression(), element);
                    next = statement;
                }
                targetBlock.addAfter(next.copy(), targetBlock.getFirstChild());
                break;
            }
        }
    }
}

