/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringConcatenationToES6TemplateIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    private static final Set<Class<? extends JSExpression>> ACCEPTED_EXPRESSIONS = new HashSet<Class<? extends JSExpression>>();
    private static final Condition<PsiElement> BINARY_OR_CONDITIONAL_EXPRESSION_PREDICATE;

    public JSStringConcatenationToES6TemplateIntention() {
        this.setText(JSBundle.message((String)"js.replace.string.concatenation.with.es6.template", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        if (element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) {
            return JSStringConcatenationToES6TemplateIntention.findSuitableExpression(element, (Factory<ExpressionIterator>)((Factory)() -> new ExpressionIterator(true)));
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "invoke"));
        }
        JSStringConcatenationToES6TemplateIntention.findSuitableExpression(element, new TemplateAssembler(project, true));
    }

    @NotNull
    private static String unquoteUnescapeEscape(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "unquoteUnescapeEscape"));
        }
        String string = StringUtil.unquoteString((String)element.getText());
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!escaped) {
                if ('\\' == ch) {
                    escaped = true;
                    continue;
                }
                if ('`' == ch) {
                    sb.append("\\`");
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if ('`' == ch) {
                sb.append("\\`");
            } else if ('\"' != ch && '\'' != ch) {
                sb.append('\\');
            }
            sb.append(ch);
            escaped = false;
        }
        String string2 = sb.toString().replace("\\n", "\n");
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "unquoteUnescapeEscape"));
        }
        return string2;
    }

    private static boolean findSuitableExpression(@NotNull PsiElement element, @NotNull Factory<ExpressionIterator> factory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "findSuitableExpression"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "findSuitableExpression"));
        }
        List<JSExpression> list = JSStringConcatenationToES6TemplateIntention.findExpressionsList(element);
        if (list == null) {
            PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)element);
            if (host != null) {
                list = JSStringConcatenationToES6TemplateIntention.findExpressionsList((PsiElement)host);
            }
            if (list == null) {
                return JSStringConcatenationToES6TemplateIntention.tryLiteralVariant(element, factory);
            }
        }
        Collections.reverse(list);
        for (JSExpression expression : list) {
            ExpressionIterator expressionIterator = (ExpressionIterator)factory.create();
            if (!expressionIterator.iterateBinaryExpression(expression)) continue;
            return true;
        }
        return JSStringConcatenationToES6TemplateIntention.tryLiteralVariant(element, factory);
    }

    private static boolean tryLiteralVariant(@NotNull PsiElement element, @NotNull Factory<ExpressionIterator> factory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "tryLiteralVariant"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "tryLiteralVariant"));
        }
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral()) {
            return ((ExpressionIterator)factory.create()).forQuotedLiteral(element);
        }
        if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == JSTokenTypes.STRING_LITERAL && element.getParent() instanceof JSLiteralExpression) {
            return ((ExpressionIterator)factory.create()).forQuotedLiteral(element);
        }
        return false;
    }

    @Nullable
    private static List<JSExpression> findExpressionsList(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "findExpressionsList"));
        }
        return JSStringConcatenationToES6TemplateIntention.findExpressionListImpl(element, true);
    }

    @Nullable
    private static List<JSExpression> findExpressionListImpl(@NotNull PsiElement element, boolean adjustElement) {
        JSExpression parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "findExpressionListImpl"));
        }
        ArrayList<JSExpression> list = new ArrayList<JSExpression>();
        JSExpression previous = null;
        while ((parent = (JSExpression)PsiTreeUtil.findFirstParent((PsiElement)(previous == null ? element : previous.getParent()), BINARY_OR_CONDITIONAL_EXPRESSION_PREDICATE)) != null) {
            list.add(parent);
            previous = parent;
        }
        if (previous == null) {
            if (adjustElement) {
                return JSStringConcatenationToES6TemplateIntention.findExpressionListImpl(JSBaseIntroduceHandler.adjustElement(element.getTextRange().getStartOffset(), element), false);
            }
            return null;
        }
        return list;
    }

    private static boolean isConditionalOperand(IElementType type) {
        return type == JSTokenTypes.COLON || type == JSTokenTypes.QUEST;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.replace.string.concatenation.with.es6.template.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "getFamilyName"));
        }
        return string;
    }

    private static Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "getLanguage"));
        }
        JSLanguageDialect dialect = DialectDetector.getLanguageDialect(element);
        if (dialect != null) {
            return dialect;
        }
        return JavascriptLanguage.INSTANCE;
    }

    static {
        ACCEPTED_EXPRESSIONS.add(JSCallExpression.class);
        ACCEPTED_EXPRESSIONS.add(JSReferenceExpression.class);
        ACCEPTED_EXPRESSIONS.add(JSPostfixExpression.class);
        ACCEPTED_EXPRESSIONS.add(JSPrefixExpression.class);
        ACCEPTED_EXPRESSIONS.add(JSIndexedPropertyAccessExpression.class);
        BINARY_OR_CONDITIONAL_EXPRESSION_PREDICATE = element -> element instanceof JSBinaryExpression || element instanceof JSConditionalExpression;
    }

    private static class TemplateAssembler
    implements Factory<ExpressionIterator> {
        private final StringBuilder mySb;
        private final Project myProject;
        private final boolean myIsTopLevel;
        private boolean myInsideInterpolation;

        public TemplateAssembler(Project project, boolean isTopLevel) {
            this.myIsTopLevel = isTopLevel;
            this.mySb = new StringBuilder();
            this.myProject = project;
        }

        public ExpressionIterator create() {
            this.mySb.setLength(0);
            return new ExpressionIterator(this.myIsTopLevel){

                @Override
                public boolean forQuotedLiteral(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$TemplateAssembler$1", "forQuotedLiteral"));
                    }
                    Language dialect = JSStringConcatenationToES6TemplateIntention.getLanguage(element);
                    PsiFile dummy = PsiFileFactory.getInstance((Project)myProject).createFileFromText(dialect, (CharSequence)("`" + JSStringConcatenationToES6TemplateIntention.unquoteUnescapeEscape(element) + "`"));
                    element.replace(PsiTreeUtil.findChildOfType((PsiElement)dummy, JSLiteralExpression.class));
                    return true;
                }

                @Override
                protected void onLeafElement(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$TemplateAssembler$1", "onLeafElement"));
                    }
                    if (element instanceof JSLiteralExpression) {
                        mySb.append(JSStringConcatenationToES6TemplateIntention.unquoteUnescapeEscape(element));
                        return;
                    }
                    for (Class aClass : ACCEPTED_EXPRESSIONS) {
                        if (!aClass.isAssignableFrom(element.getClass())) continue;
                        this.appendInsideInterpolation(element);
                        return;
                    }
                    if (JSStringConcatenationToES6TemplateIntention.isConditionalOperand(element.getNode().getElementType())) {
                        mySb.append(element.getText());
                    }
                }

                @Override
                protected void onMatch(JSExpression expression) {
                    if (myIsTopLevel) {
                        PsiFile dummy = PsiFileFactory.getInstance((Project)myProject).createFileFromText(JSStringConcatenationToES6TemplateIntention.getLanguage((PsiElement)expression), (CharSequence)("`" + mySb.toString() + "`"));
                        expression.replace((JSExpression)PsiTreeUtil.findChildOfType((PsiElement)dummy, JSStringTemplateExpression.class));
                    }
                }

                @Override
                protected boolean onConditionalExpression(@NotNull JSConditionalExpression operand) {
                    if (operand == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$TemplateAssembler$1", "onConditionalExpression"));
                    }
                    if (myInsideInterpolation) {
                        return false;
                    }
                    TemplateAssembler assembler = new TemplateAssembler(myProject, false);
                    assembler.myInsideInterpolation = true;
                    ExpressionIterator expressionIterator = assembler.create();
                    expressionIterator.iterateBinaryExpression((JSExpression)operand);
                    this.appendInsideInterpolation((PsiElement)operand);
                    this.myReferenceFound |= expressionIterator.myReferenceFound;
                    this.myFoundQuotedLiteral |= expressionIterator.myFoundQuotedLiteral;
                    return true;
                }

                @Override
                protected boolean onParenthesizedExpression(JSParenthesizedExpression operand) {
                    if (operand.getInnerExpression() == null) {
                        return false;
                    }
                    TemplateAssembler assembler = new TemplateAssembler(myProject, false);
                    assembler.myInsideInterpolation = true;
                    ExpressionIterator expressionIterator = assembler.create();
                    expressionIterator.iterateBinaryExpression(operand.getInnerExpression());
                    if (expressionIterator.myNotPlusOperationSign || !expressionIterator.myFoundQuotedLiteral) {
                        this.appendInsideInterpolation((PsiElement)operand.getInnerExpression());
                        this.myReferenceFound |= expressionIterator.myReferenceFound;
                        this.myFoundQuotedLiteral |= expressionIterator.myFoundQuotedLiteral;
                        return true;
                    }
                    return false;
                }
            };
        }

        private void appendInsideInterpolation(PsiElement operand) {
            if (!this.myInsideInterpolation) {
                this.mySb.append("${").append(operand.getText()).append("}");
            } else {
                this.mySb.append(operand.getText());
            }
        }
    }

    private static class ExpressionIterator {
        protected boolean myFoundQuotedLiteral;
        protected boolean myReferenceFound;
        protected boolean myWrong;
        protected boolean myNotPlusOperationSign;
        protected final ArrayDeque<PsiElement> myQueue;
        private final boolean myIsTopLevel;

        public ExpressionIterator(boolean topLevel) {
            this.myIsTopLevel = topLevel;
            this.myQueue = new ArrayDeque();
        }

        public boolean forQuotedLiteral(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$ExpressionIterator", "forQuotedLiteral"));
            }
            return true;
        }

        public boolean iterateBinaryExpression(JSExpression element) {
            if (element == null) {
                return false;
            }
            this.myQueue.add((PsiElement)element);
            while (!this.myQueue.isEmpty()) {
                PsiElement expression = this.myQueue.removeFirst();
                if (expression instanceof JSBinaryExpression) {
                    JSBinaryExpression binary = (JSBinaryExpression)expression;
                    if (binary.getOperationSign() != JSTokenTypes.PLUS) {
                        if (this.myIsTopLevel) {
                            return false;
                        }
                        this.myNotPlusOperationSign = true;
                    }
                    if (!this.checkOperand((PsiElement)binary.getLOperand())) {
                        if (this.myWrong) {
                            return false;
                        }
                        this.addToQueue((PsiElement)binary.getROperand(), false);
                        this.addToQueue((PsiElement)binary.getLOperand(), true);
                        continue;
                    }
                    if (this.checkOperand((PsiElement)binary.getROperand())) continue;
                    if (this.myWrong) {
                        return false;
                    }
                    this.addToQueue((PsiElement)binary.getROperand(), true);
                    continue;
                }
                if (this.checkOperand(expression)) continue;
                if (this.myWrong) {
                    return false;
                }
                this.addToQueue(expression, true);
            }
            boolean result = this.myFoundQuotedLiteral;
            if (result) {
                this.onMatch(element);
            }
            return result;
        }

        protected void onMatch(JSExpression element) {
        }

        private void addToQueue(@Nullable PsiElement expression, boolean unRollParenthesizes) {
            if (expression == null) {
                return;
            }
            Object object = expression = unRollParenthesizes && expression instanceof JSParenthesizedExpression ? ((JSParenthesizedExpression)expression).getInnerExpression() : expression;
            if (expression == null) {
                return;
            }
            if (expression instanceof JSConditionalExpression) {
                this.myNotPlusOperationSign = true;
                JSConditionalExpression conditional = (JSConditionalExpression)expression;
                Pair<PsiElement, PsiElement> pair = JSChangeUtil.createConditionalPsiElements(expression.getProject());
                this.addIfNotNull((PsiElement)conditional.getElse());
                this.myQueue.addFirst((PsiElement)pair.getSecond());
                this.addIfNotNull((PsiElement)conditional.getThen());
                this.myQueue.addFirst((PsiElement)pair.getFirst());
                this.addIfNotNull((PsiElement)conditional.getCondition());
                return;
            }
            this.addIfNotNull(expression);
        }

        private void addIfNotNull(@Nullable PsiElement expression) {
            if (expression != null) {
                this.myQueue.addFirst(expression);
            }
        }

        private boolean checkOperand(PsiElement operand) {
            if (operand == null) {
                return false;
            }
            if (operand instanceof JSParenthesizedExpression) {
                return this.onParenthesizedExpression((JSParenthesizedExpression)operand);
            }
            if (operand instanceof JSBinaryExpression) {
                return false;
            }
            if (operand instanceof JSConditionalExpression) {
                return this.onConditionalExpression((JSConditionalExpression)operand);
            }
            if (operand instanceof JSLiteralExpression) {
                if (((JSLiteralExpression)operand).isQuotedLiteral()) {
                    this.myFoundQuotedLiteral = true;
                }
                this.onLeafElement(operand);
                return true;
            }
            for (Class aClass : ACCEPTED_EXPRESSIONS) {
                if (!aClass.isAssignableFrom(operand.getClass())) continue;
                this.myReferenceFound = true;
                this.onLeafElement(operand);
                return true;
            }
            if (JSStringConcatenationToES6TemplateIntention.isConditionalOperand(operand.getNode().getElementType())) {
                this.onLeafElement(operand);
                return true;
            }
            this.myWrong = true;
            return false;
        }

        protected boolean onConditionalExpression(@NotNull JSConditionalExpression operand) {
            if (operand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$ExpressionIterator", "onConditionalExpression"));
            }
            return false;
        }

        protected boolean onParenthesizedExpression(JSParenthesizedExpression operand) {
            if (operand.getInnerExpression() == null) {
                return true;
            }
            TemplateAssembler assembler = new TemplateAssembler(operand.getProject(), false);
            ExpressionIterator expressionIterator = assembler.create();
            expressionIterator.iterateBinaryExpression(operand.getInnerExpression());
            if (!expressionIterator.myFoundQuotedLiteral) {
                this.myReferenceFound |= expressionIterator.myReferenceFound;
                return true;
            }
            return false;
        }

        protected void onLeafElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$ExpressionIterator", "onLeafElement"));
            }
        }

        public boolean isFoundQuotedLiteral() {
            return this.myFoundQuotedLiteral;
        }
    }
}

