/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.PackageJsonDocumentDependencies;
import com.intellij.lang.javascript.modules.RecordModuleIntoDepPackageJsonQuickFix;
import com.intellij.lang.javascript.modules.RecordModuleIntoDevPackageJsonQuickFix;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmUsedModulesInstalledInspection
extends JSInspection {
    public static final String[] NODE_MODULES = new String[]{"node_modules"};
    private final PackageJsonDocumentDependencies myPackageJsonDocumentDependencies = PackageJsonDocumentDependencies.getInstance();

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6FromClause(ES6FromClause fromClause) {
                if (!DialectDetector.isJavaScript((PsiElement)fromClause)) {
                    return;
                }
                NpmUsedModulesInstalledInspection.this.check((PsiElement)fromClause, fromClause.getReferenceText(), holder, session, (Convertor<VirtualFile, VirtualFile>)moduleRoot -> {
                    PsiReference[] references;
                    for (PsiReference reference : references = fromClause.getReferences()) {
                        PsiElement resolve = reference.resolve();
                        if (resolve == null || !resolve.isValid() || resolve.getContainingFile() == null) continue;
                        return resolve.getContainingFile().getVirtualFile();
                    }
                    return null;
                });
            }

            public void visitJSCallExpression(JSCallExpression call) {
                if (!DialectDetector.isJavaScript((PsiElement)call.getContainingFile())) {
                    return;
                }
                Project project = session.getFile().getProject();
                if (!call.isRequireCall()) {
                    return;
                }
                if (!NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(session.getFile())) {
                    return;
                }
                JSExpression argument = call.getArguments()[0];
                if (argument instanceof JSLiteralExpression) {
                    JSModuleBaseReference reference = this.getNodeModuleReference(argument);
                    if (reference == null) {
                        return;
                    }
                    NpmUsedModulesInstalledInspection.this.check((PsiElement)argument, StringUtil.unquoteString((String)argument.getText()), holder, session, (Convertor<VirtualFile, VirtualFile>)moduleRoot -> {
                        PsiElement resolve = ((PsiReference)reference).resolve();
                        if (resolve == null || !resolve.isValid()) {
                            return null;
                        }
                        VirtualFile file = resolve.getContainingFile().getVirtualFile();
                        if (!DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType())) {
                            return null;
                        }
                        return NodeModuleUtil.canBeRequired(project, moduleRoot, resolve.getContainingFile(), true) != null ? file : null;
                    });
                }
            }

            private JSModuleBaseReference getNodeModuleReference(JSExpression argument) {
                PsiReference[] references;
                for (PsiReference reference : references = argument.getReferences()) {
                    if (!(reference instanceof JSModuleBaseReference)) continue;
                    return (JSModuleBaseReference)reference;
                }
                return null;
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Check require() reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getDisplayName"));
        }
        return "Check require() reference";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    private void check(@Nullable PsiElement element, @Nullable String referenceText, ProblemsHolder holder, LocalInspectionToolSession session, @NotNull Convertor<VirtualFile, VirtualFile> resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "check"));
        }
        if (referenceText == null || element == null) {
            return;
        }
        if ((referenceText = referenceText.trim()).startsWith("./") || referenceText.startsWith("../")) {
            return;
        }
        String moduleName = NpmUsedModulesInstalledInspection.getModuleName(referenceText);
        if (NpmUsedModulesInstalledInspection.notInstallableModuleName(moduleName)) {
            return;
        }
        if (NodeJsCoreLibraryManager.isCoreModuleName(moduleName)) {
            return;
        }
        VirtualFile coreModule = NodeJsCoreLibraryManager.getInstance(holder.getProject()).findCoreModuleFileByName(moduleName);
        if (coreModule != null) {
            return;
        }
        if (this.myPackageJsonDocumentDependencies.isBeingInstalled(moduleName)) {
            return;
        }
        Collection packageJsonFiles = FilenameIndex.getVirtualFilesByName((Project)element.getProject(), (String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)element.getProject()));
        packageJsonFiles = ContainerUtil.filter((Collection)packageJsonFiles, file -> !JSLibraryUtil.isProbableLibraryFile(file));
        boolean inPackageJson = false;
        boolean isInstalled = false;
        if (!packageJsonFiles.isEmpty()) {
            for (VirtualFile packageJsonFile : packageJsonFiles) {
                VirtualFile resolveFile;
                VirtualFile moduleRoot = packageJsonFile.getParent();
                if (moduleRoot == null || !packageJsonFile.isValid()) continue;
                boolean notInPackageJson = NpmUsedModulesInstalledInspection.moduleNotInPackageJson(holder.getProject(), moduleName, packageJsonFile);
                if (!notInPackageJson) {
                    inPackageJson = true;
                }
                if ((resolveFile = (VirtualFile)resolver.convert((Object)moduleRoot)) != null && !JSLibraryUtil.hasDirectoryInPath(resolveFile, NODE_MODULES, null)) {
                    return;
                }
                boolean bl = isInstalled = resolveFile != null;
                if (!inPackageJson || !isInstalled) continue;
                return;
            }
        }
        if (!isInstalled && packageJsonFiles.isEmpty()) {
            VirtualFile resolveFile = (VirtualFile)resolver.convert((Object)element.getProject().getBaseDir());
            if (resolveFile != null && !JSLibraryUtil.hasDirectoryInPath(resolveFile, NODE_MODULES, null)) {
                return;
            }
            boolean bl = isInstalled = resolveFile != null;
        }
        if (packageJsonFiles.isEmpty() && !isInstalled) {
            return;
        }
        if (isInstalled) {
            if (!inPackageJson) {
                holder.registerProblem(element, JSBundle.message((String)"npm.modules.inspection.content.of.require.not.in.dependencies.warning", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RecordModuleIntoDepPackageJsonQuickFix(moduleName, packageJsonFiles), new RecordModuleIntoDevPackageJsonQuickFix(moduleName, packageJsonFiles)});
            }
        } else {
            ArrayList<InstallNodeModuleQuickFix> fixes = new ArrayList<InstallNodeModuleQuickFix>();
            if (!inPackageJson) {
                fixes.add(new InstallNodeModuleQuickFix(moduleName, true, false, false, packageJsonFiles));
                fixes.add(new InstallNodeModuleQuickFix(moduleName, true, false, true, packageJsonFiles));
            }
            fixes.add(new InstallNodeModuleQuickFix(moduleName, false, false, false, packageJsonFiles));
            if (!packageJsonFiles.isEmpty()) {
                fixes.add(new InstallNodeModuleQuickFix(moduleName, false, true, false, packageJsonFiles));
            }
            holder.registerProblem(element, JSBundle.message((String)"npm.modules.inspection.content.of.require.module.not.installed.warning", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(new LocalQuickFix[fixes.size()]));
        }
    }

    private static boolean resolved(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "resolved"));
        }
        PsiElement element = reference.resolve();
        return element != null && element.isValid();
    }

    @NotNull
    public static String getModuleName(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
        }
        String path = StringUtil.unquoteString((String)text);
        String[] strings = path.split("/");
        if (strings.length > 1) {
            if (strings[0].startsWith("@")) {
                String string = strings[0] + "/" + strings[1];
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
            }
            return "";
        }
        String string = strings.length == 0 ? "" : strings[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
        }
        return string;
    }

    public static boolean notInstallableModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "notInstallableModuleName"));
        }
        if (StringUtil.isEmptyOrSpaces((String)moduleName)) {
            return true;
        }
        boolean haveNamePartInWord = false;
        for (int i = 0; i < moduleName.length(); ++i) {
            char ch = moduleName.charAt(i);
            if (ch == '@' && i > 0) {
                return true;
            }
            boolean namePart = Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '@';
            haveNamePartInWord |= namePart;
            if (namePart || ch == '.' || ch == '/') continue;
            return true;
        }
        return !haveNamePartInWord;
    }

    public static boolean moduleNotInPackageJson(Project project, String name, VirtualFile packageJsonFile) {
        PackageJsonDocumentDependencies.Dependencies dependencies = PackageJsonDocumentDependencies.getInstance().getForFile(project, packageJsonFile);
        if (dependencies != null) {
            return !dependencies.getDependencies().containsKey(name) && !dependencies.getDevDependencies().containsKey(name) && !dependencies.getOptionalDependencies().containsKey(name);
        }
        return false;
    }
}

