/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSNonXmlTokensParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.lang.javascript.parsing.JSXmlTokensParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JavaScriptParser<E extends ExpressionParser, S extends StatementParser, F extends FunctionParser, T extends JSPsiTypeParser> {
    private final JSLanguageDialect myDialect;
    protected final PsiBuilder builder;
    protected E myExpressionParser;
    protected S myStatementParser;
    protected F myFunctionParser;
    protected T myTypeParser;
    protected JSXmlParser myXmlParser;

    public JavaScriptParser(JSLanguageDialect dialect, PsiBuilder builder) {
        this.builder = builder;
        this.myDialect = dialect;
        this.myExpressionParser = new ExpressionParser<JavaScriptParser>(this);
        this.myStatementParser = new StatementParser<JavaScriptParser>(this);
        this.myFunctionParser = new FunctionParser<JavaScriptParser>(this);
        this.myTypeParser = new JSPsiTypeParser<JavaScriptParser>(this);
        this.myXmlParser = dialect != null && !dialect.getOptionHolder().hasFeature(JSLanguageFeature.E4X) ? JSXmlParser.DUMMY : (dialect != null && dialect.getOptionHolder().hasFeature(JSLanguageFeature.GENERICS) ? new JSNonXmlTokensParser<JavaScriptParser>(this) : new JSXmlTokensParser<JavaScriptParser>(this));
    }

    public void parseJS(IElementType root) {
        PsiBuilder.Marker rootMarker = this.builder.mark();
        this.builder.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)this.myDialect);
        JavaScriptParserBase.ForceContext forceContext = (JavaScriptParserBase.ForceContext)((Object)this.builder.getUserData(JavaScriptParserBase.FORCE_CONTEXT_KEY));
        if (forceContext != null) {
            if (forceContext == JavaScriptParserBase.ForceContext.Parameter && this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else {
                ((JSPsiTypeParser)this.myTypeParser).parseType();
            }
            while (!this.builder.eof()) {
                ((StatementParser)this.getStatementParser()).parseStatement();
            }
        } else {
            while (!this.builder.eof()) {
                ((StatementParser)this.getStatementParser()).parseSourceElement();
            }
        }
        rootMarker.done(root);
    }

    public E getExpressionParser() {
        return this.myExpressionParser;
    }

    public S getStatementParser() {
        return this.myStatementParser;
    }

    public F getFunctionParser() {
        return this.myFunctionParser;
    }

    public T getTypeParser() {
        return this.myTypeParser;
    }

    public JSXmlParser getXmlParser() {
        return this.myXmlParser;
    }

    public boolean isIdentifierToken(IElementType tokenType) {
        if (((JavaScriptParserBase)this.myExpressionParser).isGwt()) {
            return JSKeywordSets.GWT_IDENTIFIER_TOKENS_SET.contains(tokenType);
        }
        return JSKeywordSets.JS_IDENTIFIER_TOKENS_SET.contains(tokenType);
    }

    public JSLanguageDialect getDialect() {
        return this.myDialect;
    }

    public void buildTokenElement(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/parsing/JavaScriptParser", "buildTokenElement"));
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        marker.done(type);
    }
}

