/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSClassBase<StubT extends JSQualifiedStub<?>>
extends JSQualifiedNamedElementBaseImpl<StubT>
implements JSClass<StubT> {
    @Nullable
    private volatile Map<String, Object> myName2FunctionMap;
    @Nullable
    private volatile Map<String, JSField> myName2FieldsMap;
    private static final ClassesUserDataCache ourImplementsListCache = new ImplementsClassesUserDataCache("implements.list.cache");
    private static final ClassesUserDataCache ourExtendsListCache = new ExtendsClassesUserDataCache("extends.list.cache");
    public static final String ES6_CONSTRUCTOR = "constructor";

    protected JSClassBase(ASTNode node) {
        super(node);
    }

    public JSClassBase(StubT stub, IStubElementType<StubT, ?> aClass) {
        super(stub, aClass);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSClass((JSClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    protected Object clone() {
        JSClassBase o = (JSClassBase)((Object)super.clone());
        o.clearCaches();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearCaches() {
        JSClassBase jSClassBase = this;
        synchronized (jSClassBase) {
            this.clearCachesSync();
        }
    }

    protected void clearCachesSync() {
        this.myName2FunctionMap = null;
        this.myName2FieldsMap = null;
    }

    @NotNull
    public JSFunction[] getFunctions() {
        JSQualifiedStub classStub = (JSQualifiedStub)this.getStub();
        if (classStub != null) {
            JSFunction[] jSFunctionArray = (JSFunction[])this.getStubChildrenByType((StubElement)classStub, JSFunction.ARRAY_FACTORY, JSElementTypes.FUNCTION_DECLARATIONS);
            if (jSFunctionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getFunctions"));
            }
            return jSFunctionArray;
        }
        ArrayList functions = new ArrayList();
        this.gatherDeclarations(functions, JSFunction.class);
        JSFunction[] jSFunctionArray = functions.toArray(new JSFunction[functions.size()]);
        if (jSFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getFunctions"));
        }
        return jSFunctionArray;
    }

    @Nullable
    public JSFunction findFunctionByName(@Nullable String functionName) {
        if (functionName == null) {
            return null;
        }
        Map<String, Object> name2FunctionMap = this.getFunctionsMap();
        Object o = name2FunctionMap.get(functionName);
        if (o instanceof JSFunction) {
            return (JSFunction)o;
        }
        if (o instanceof JSFunction[]) {
            return ((JSFunction[])o)[0];
        }
        return null;
    }

    @NotNull
    public JSField[] getFields() {
        JSQualifiedStub classStub = (JSQualifiedStub)this.getStub();
        ArrayList fields = new ArrayList(3);
        if (classStub != null) {
            for (JSVarStatement var : (JSVarStatement[])this.getStubChildrenByType((StubElement)classStub, JSVarStatement[]::new, JSElementTypes.VAR_STATEMENTS)) {
                JSVariable[] variables = var.getVariables();
                Arrays.stream(variables).forEach(el -> {
                    if (el instanceof JSField) {
                        fields.add((JSField)el);
                    }
                });
            }
        } else {
            this.gatherDeclarations(fields, JSField.class);
        }
        JSField[] jSFieldArray = fields.toArray(new JSField[fields.size()]);
        if (jSFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getFields"));
        }
        return jSFieldArray;
    }

    @NotNull
    public Iterable<? extends JSElement> getMembers() {
        Iterable iterable = ContainerUtil.concat((Object[][])new JSQualifiedNamedElement[][]{this.getFields(), this.getFunctions()});
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getMembers"));
        }
        return iterable;
    }

    private <E extends PsiElement> void gatherDeclarations(final List<E> elements, final Class<E> clazz) {
        this.processDeclarations(new ResolveProcessor(null){
            {
                super(name);
                this.setToProcessHierarchy(false);
                this.setSkipImplicitDeclarations(true);
                this.setLocalResolve(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase$1", "execute"));
                }
                if (clazz.isInstance(element)) {
                    elements.add(clazz.cast(element));
                }
                return true;
            }

            @Override
            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase$1", "getHint"));
                }
                return null;
            }

            @Override
            public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase$1", "handleEvent"));
                }
            }
        }, ResolveState.initial(), (PsiElement)this, (PsiElement)this);
    }

    @Nullable
    public JSField findFieldByName(String name) {
        return this.initFields().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final Map<String, JSField> initFields() {
        THashMap name2FieldsMap = this.myName2FieldsMap;
        if (name2FieldsMap == null) {
            JSClassBase jSClassBase = this;
            synchronized (jSClassBase) {
                name2FieldsMap = this.myName2FieldsMap;
                if (name2FieldsMap == null) {
                    name2FieldsMap = new THashMap();
                    for (JSField field : this.getFields()) {
                        String name = field.getName();
                        if (name != null) {
                            name2FieldsMap.put(name, field);
                        }
                        this.updateStateForField(field);
                    }
                    this.myName2FieldsMap = name2FieldsMap;
                }
            }
        }
        THashMap tHashMap = name2FieldsMap;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "initFields"));
        }
        return tHashMap;
    }

    protected Map<String, Object> getFunctionsMap() {
        return this.initFunctions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final Map<String, Object> initFunctions() {
        THashMap name2FunctionMap = this.myName2FunctionMap;
        if (name2FunctionMap == null) {
            JSClassBase jSClassBase = this;
            synchronized (jSClassBase) {
                name2FunctionMap = this.myName2FunctionMap;
                if (name2FunctionMap == null) {
                    name2FunctionMap = new THashMap();
                    for (JSFunction function : this.getFunctions()) {
                        String name = this.getMethodName(function);
                        if (name != null) {
                            Object o = name2FunctionMap.get(name);
                            if (o == null) {
                                name2FunctionMap.put(name, function);
                            } else if (o instanceof JSFunction) {
                                name2FunctionMap.put(name, new JSFunction[]{(JSFunction)o, function});
                            } else if (o instanceof JSFunction[]) {
                                name2FunctionMap.put(name, ArrayUtil.append((Object[])((JSFunction[])o), (Object)function));
                            }
                        }
                        this.updateStateForFunction(function);
                    }
                    this.myName2FunctionMap = name2FunctionMap;
                }
            }
        }
        THashMap tHashMap = name2FunctionMap;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "initFunctions"));
        }
        return tHashMap;
    }

    protected String getMethodName(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getMethodName"));
        }
        return function.getName();
    }

    protected void updateStateForField(@NotNull JSField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "updateStateForField"));
        }
    }

    protected void updateStateForFunction(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "updateStateForFunction"));
        }
    }

    @NotNull
    public Collection<JSClass> getImplicitlyDeclaredInterfaces() {
        List<JSClass> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getImplicitlyDeclaredInterfaces"));
        }
        return list;
    }

    public JSFunction findFunctionByNameAndKind(String name, JSFunction.FunctionKind kind) {
        if (name == null) {
            return null;
        }
        Map<String, Object> name2FunctionMap = this.getFunctionsMap();
        Object o = name2FunctionMap.get(name);
        if (o instanceof JSFunction) {
            JSFunction function = (JSFunction)o;
            return function.getKind() == kind ? function : null;
        }
        if (o instanceof JSFunction[]) {
            for (JSFunction fun : (JSFunction[])o) {
                if (fun.getKind() != kind) continue;
                return fun;
            }
        }
        return null;
    }

    @NotNull
    public JSClass[] getSupers() {
        ArrayList<JSClass> superClasses = new ArrayList<JSClass>(this.getClassesFromReferenceList(this.getExtendsList(), ListType.EXTEND));
        superClasses.addAll(this.getClassesFromReferenceList(this.getImplementsList(), ListType.IMPLEMENTS));
        JSClass[] jSClassArray = superClasses.toArray(new JSClass[superClasses.size()]);
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getSupers"));
        }
        return jSClassArray;
    }

    private List<JSClass> getClassesFromReferenceList(@Nullable JSReferenceList extendsList, @NotNull ListType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getClassesFromReferenceList"));
        }
        Object element = extendsList != null ? extendsList : this;
        return (type == ListType.EXTEND ? ourExtendsListCache : ourImplementsListCache).calculate(this, extendsList, (PsiElement)element);
    }

    public String getName() {
        JSQualifiedStub classStub = (JSQualifiedStub)this.getStub();
        if (classStub != null) {
            return classStub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            String name = ((JSReferenceExpression)node.getPsi()).getReferenceName();
            return ActionScriptResolveUtil.replaceInternalName(name);
        }
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        String oldName;
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "setName"));
        }
        if ((newName = newName.substring(newName.lastIndexOf(46) + 1)).equals(oldName = this.getName())) {
            return this;
        }
        ASTNode child = this.findNameIdentifier();
        if (child != null) {
            JSExpression qualifier;
            String qName = newName;
            if (child.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && (qualifier = ((JSReferenceExpression)child.getPsi()).getQualifier()) != null) {
                qName = qualifier.getText() + "." + newName;
            }
            this.getNode().replaceChild(child, JSChangeUtil.createExpressionFromText(this.getProject(), qName));
        }
        return this;
    }

    @NonNls
    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSQualifiedStub stub = (JSQualifiedStub)this.getStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        JSNamespace fromJSDoc = JSDocumentationUtils.getNamespaceFromJSDoc((JSNamedElement)this);
        if (fromJSDoc.isExplicitlyDeclared()) {
            return fromJSDoc.getQualifiedName();
        }
        return JSPsiImplUtils.getNamespace((JSNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return JSClassBase.findNameIdentifier(this.getNode());
    }

    public static ASTNode findNameIdentifier(ASTNode node) {
        return node.findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
    }

    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    public int getTextOffset() {
        ASTNode node = this.findNameIdentifier();
        return node == null ? super.getTextOffset() : node.getStartOffset();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        boolean toProcessInHierarchy;
        boolean toProcessMembers;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "processDeclarations"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "processDeclarations"));
        }
        ResolveProcessor resolveProcessor = processor instanceof ResolveProcessor ? (ResolveProcessor)processor : null;
        boolean toProcessClass = this.needProcessClass(resolveProcessor, place);
        if ((toProcessClass || lastParent == null) && !processor.execute((PsiElement)this, substitutor)) {
            return false;
        }
        if (lastParent == null) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        boolean bl = toProcessMembers = resolveProcessor == null || !resolveProcessor.isToSkipClassDeclarationOnce() && resolveProcessor.isToProcessMembers();
        if (toProcessMembers) {
            if (!this.processMembers(processor, substitutor, lastParent, place)) {
                return false;
            }
        } else {
            resolveProcessor.setToSkipClassDeclarationsOnce(false);
        }
        boolean bl2 = toProcessInHierarchy = processor instanceof ResolveProcessor && ((ResolveProcessor)processor).isToProcessHierarchy();
        if (!toProcessInHierarchy || ((ResolveProcessor)processor).checkVisited(this)) {
            return true;
        }
        JSClass[] superClasses = this.getSuperClassesForProcess(place);
        processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_STARTED, (Object)this);
        for (JSClass clazz : superClasses) {
            if (clazz.processDeclarations(processor, substitutor, lastParent, place)) continue;
            return false;
        }
        processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_FINISHED, (Object)this);
        return true;
    }

    protected JSClass[] getSuperClassesForProcess(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getSuperClassesForProcess"));
        }
        return this.getSuperClasses();
    }

    protected boolean needProcessClass(@Nullable ResolveProcessor resolveProcessor, @Nullable PsiElement place) {
        return resolveProcessor != null && resolveProcessor.isTypeContext();
    }

    public JSReferenceList getExtendsList() {
        return (JSReferenceList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.DEFAULT_EXTENDS_LIST);
    }

    public JSReferenceList getImplementsList() {
        return (JSReferenceList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.IMPLEMENTS_LIST);
    }

    protected boolean processMembers(PsiScopeProcessor processor, ResolveState substitutor, PsiElement lastParent, PsiElement place) {
        return JSResolveUtil.processDeclarationsInScope(this, processor, substitutor, lastParent, place);
    }

    @NotNull
    public JSClass[] getSuperClasses() {
        JSReferenceList extendsList = this.getExtendsList();
        List<JSClass> supers = this.getClassesFromReferenceList(extendsList, ListType.EXTEND);
        JSClass[] jSClassArray = supers.toArray(new JSClass[supers.size()]);
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getSuperClasses"));
        }
        return jSClassArray;
    }

    protected Icon getBaseIcon() {
        JSIconProvider customIconProvider;
        PsiElement container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)this, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
        JSIconProvider iconProvider = JSIconProvider.DEFAULT_INSTANCE;
        if (container != null && (customIconProvider = (JSIconProvider)JSIconProvider.INSTANCE.forLanguage(container.getLanguage())) != null) {
            iconProvider = customIconProvider;
        }
        return this.isInterface() ? iconProvider.getInterfaceIcon() : iconProvider.getClassIcon();
    }

    @Nullable
    public Icon getIcon(int flags) {
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType type = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        Icon icon = this.isInterface() ? this.getBaseIcon() : JSStubElementImpl.blendModifierFlags(this.getBaseIcon(), attributeList, true);
        return ElementBase.iconWithVisibilityIfNeeded((int)flags, (Icon)icon, (Icon)type.getIcon());
    }

    @NotNull
    public JSClass[] getImplementedInterfaces() {
        JSReferenceList implementsList = this.getImplementsList();
        List<JSClass> classes = this.getClassesFromReferenceList(implementsList, ListType.IMPLEMENTS);
        JSClass[] jSClassArray = !classes.isEmpty() ? classes.toArray(new JSClass[classes.size()]) : JSClass.EMPTY_ARRAY;
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getImplementedInterfaces"));
        }
        return jSClassArray;
    }

    public JSFunction getConstructor() {
        return this.findFunctionByName(ES6_CONSTRUCTOR);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @NotNull
    protected <E extends PsiElement> E[] getStubChildrenByType(StubElement<?> stub, ArrayFactory<E> f, TokenSet set) {
        PsiElement[] psiElementArray = stub.getChildrenByType(set, f);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getStubChildrenByType"));
        }
        return psiElementArray;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getAccessType"));
        }
        return accessType;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "getJSContext"));
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.CLASS;
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase", "isClassOrInterface"));
        }
        return classOrInterface;
    }

    private static class ClassesUserDataCache
    extends UserDataCache<ParameterizedCachedValue<JSInheritanceUtil.CacheByEnforcedResolveScope<List<JSClass>>, Object>, JSClassBase, Object> {
        private ClassesUserDataCache(@NonNls String keyName) {
            super(keyName);
        }

        protected ParameterizedCachedValue<JSInheritanceUtil.CacheByEnforcedResolveScope<List<JSClass>>, Object> compute(JSClassBase jsClassBase, Object p) {
            return CachedValuesManager.getManager((Project)jsClassBase.getProject()).createParameterizedCachedValue((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<JSInheritanceUtil.CacheByEnforcedResolveScope<List<JSClass>>, Object>(){

                public CachedValueProvider.Result<JSInheritanceUtil.CacheByEnforcedResolveScope<List<JSClass>>> compute(final Object list) {
                    return new CachedValueProvider.Result((Object)new JSInheritanceUtil.CacheByEnforcedResolveScope<List<JSClass>>(){

                        @Override
                        protected List<JSClass> computeForScope(@Nullable GlobalSearchScope scope) {
                            return this.doCompute(list);
                        }
                    }, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
        }

        protected boolean resolveUnqualified(JSReferenceList extendsList) {
            return true;
        }

        protected List<JSClass> doCompute(Object object) {
            if (object instanceof JSClass) {
                return Collections.emptyList();
            }
            return Arrays.asList(((JSReferenceList)object).getReferencedClasses());
        }

        public List<JSClass> calculate(JSClassBase owner, JSReferenceList extendsList, PsiElement element) {
            return (List)((JSInheritanceUtil.CacheByEnforcedResolveScope)((ParameterizedCachedValue)this.get((UserDataHolder)owner, extendsList)).getValue((Object)element)).compute();
        }
    }

    private static class ImplementsClassesUserDataCache
    extends ClassesUserDataCache {
        private ImplementsClassesUserDataCache(@NonNls String keyName) {
            super(keyName);
        }

        @Override
        protected List<JSClass> doCompute(Object extendsList) {
            PsiElement element;
            List<JSClass> clazzList = super.doCompute(extendsList);
            JSClass clazz = extendsList instanceof JSClass ? (JSClass)extendsList : (JSClass)JSResolveUtil.findParent((PsiElement)extendsList);
            if (ActionScriptClassBase.isImplicitlyDeclaringEventDispatcher(clazz) && (element = JSClassResolver.findClassFromNamespace("flash.events.IEventDispatcher", (PsiElement)clazz)) instanceof JSClass) {
                boolean toAdd = true;
                if (!clazzList.isEmpty()) {
                    for (JSClass presentClass : clazzList) {
                        if (presentClass != element) continue;
                        toAdd = false;
                        break;
                    }
                }
                if (toAdd) {
                    clazzList = new ArrayList<JSClass>(clazzList);
                    clazzList.add((JSClass)element);
                }
            }
            return clazzList;
        }

        @Override
        protected boolean resolveUnqualified(JSReferenceList extendsList) {
            PsiFile containingFile = extendsList.getContainingFile();
            if (containingFile instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)containingFile)) {
                return false;
            }
            return super.resolveUnqualified(extendsList);
        }
    }

    private static class ExtendsClassesUserDataCache
    extends ClassesUserDataCache {
        private ExtendsClassesUserDataCache(@NonNls String keyName) {
            super(keyName);
        }

        @Override
        protected List<JSClass> doCompute(Object extendsList) {
            if (extendsList instanceof JSClass) {
                JSClass jsClass = (JSClass)extendsList;
                ArrayList<JSClass> supers = new ArrayList<JSClass>(1);
                if (!"Object".equals(jsClass.getQualifiedName())) {
                    if (DialectDetector.isTypeScript((PsiElement)jsClass)) {
                        return TypeScriptClassResolver.getInstance().findObjectClasses(jsClass);
                    }
                    PsiElement element = JSClassResolver.findClassFromNamespace("Object", (PsiElement)jsClass);
                    if (element instanceof JSClass) {
                        supers.add((JSClass)element);
                    }
                }
                return supers;
            }
            return super.doCompute(extendsList);
        }
    }

    static enum ListType {
        EXTEND,
        IMPLEMENTS;

    }
}

