/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringPropertyReference
extends PsiPolyVariantReferenceBase<JSDestructuringProperty> {
    public JSDestructuringPropertyReference(@NotNull JSDestructuringProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference", "<init>"));
        }
        super((PsiElement)property, true);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(((JSDestructuringProperty)this.getElement()).getContainingFile(), this, new JSResolveUtil.Resolver<JSDestructuringPropertyReference>(){

            @Override
            public ResolveResult[] doResolve() {
                JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)JSDestructuringPropertyReference.this.getElement();
                JSInitializerOwner element = destructuringProperty.getDestructuringElement();
                if (!(element instanceof JSVariable)) {
                    return ResolveResult.EMPTY_ARRAY;
                }
                JSVariable jsVariable = (JSVariable)element;
                JSTypeEvaluationResult type = JSTypeEvaluator.getElementType((PsiElement)jsVariable);
                if (type == null) {
                    return ResolveResult.EMPTY_ARRAY;
                }
                ArrayList results = ContainerUtil.newArrayList();
                List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> typeResults = type.getResults();
                for (JSTypeEvaluationResult.JSTypeEvaluationResultElement resultElement : typeResults) {
                    PsiElement source = resultElement.getSource();
                    if (source == null || jsVariable == source || source == PsiUtilCore.NULL_PSI_ELEMENT || !resultElement.getEvaluationContext().isJSElementsToApplyEmpty()) continue;
                    results.add(new JSResolveResult(source));
                }
                return results.toArray(ResolveResult.EMPTY_ARRAY);
            }
        });
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    protected TextRange calculateDefaultRangeInElement() {
        JSDestructuringProperty element = (JSDestructuringProperty)this.getElement();
        if (element instanceof JSDestructuringPropertyBase) {
            PsiElement identifier = ((JSDestructuringPropertyBase)element).getNameIdentifierForPropertyOrNestedElement();
            if (identifier == null) {
                return ((JSDestructuringProperty)this.getElement()).getTextRange();
            }
            int startOffsetInParent = identifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + identifier.getTextLength());
        }
        return new TextRange(0, element.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.notNullize((String)((JSDestructuringProperty)this.myElement).getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        JSDestructuringProperty element = (JSDestructuringProperty)this.getElement();
        element.setName(newElementName);
        return element;
    }

    public boolean isReferenceTo(PsiElement element) {
        return super.isReferenceTo(element);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference", "bindToElement"));
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

