/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSStubbedStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSVarStatementBase
extends JSStubbedStatementImpl<JSVarStatementStub>
implements JSVarStatement,
JSAttributeListOwner {
    public static final TokenSet VARIABLES_AND_DESTRUCTURING_CONTAINERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.VARIABLES, JSElementTypes.DESTRUCTURING_CONTAINERS});

    public JSVarStatementBase(ASTNode node) {
        super(node);
    }

    public JSVarStatementBase(JSVarStatementStub node, IStubElementType type) {
        super(node, type);
    }

    @NotNull
    public abstract JSVariable[] getVariables();

    public void declareVariable(String name, JSExpression initializer) {
        throw new UnsupportedOperationException("TODO: implement");
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSVarStatementBase", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSVarStatement((JSVarStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVarStatementBase", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSVarStatementBase", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSVarStatementBase", "processDeclarations"));
        }
        if (this.shouldDirectProcessVariables(processor, lastParent)) {
            return this.processVariables(processor, state, lastParent, place);
        }
        return JSResolveUtil.processDeclarationsInScope(this, processor, state, null, place);
    }

    protected boolean shouldDirectProcessVariables(@NotNull PsiScopeProcessor processor, PsiElement lastParent) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVarStatementBase", "shouldDirectProcessVariables"));
        }
        return lastParent != null || !(processor instanceof ResolveProcessor) || ((ResolveProcessor)processor).getName() == null;
    }

    private boolean processVariables(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        JSVariable[] vars;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVarStatementBase", "processVariables"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSVarStatementBase", "processVariables"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSVarStatementBase", "processVariables"));
        }
        for (JSVariable var : vars = this.getVariables()) {
            if (lastParent == var) break;
            if (var.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        for (JSVariable v : this.getVariables()) {
            ((JSVariableBaseImpl)v).clearCaches();
        }
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    public JSVarStatement.VarKeyword getVarKeyword() {
        return null;
    }
}

