/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JSVarStatementImpl
extends JSVarStatementBase {
    public JSVarStatementImpl(ASTNode node) {
        super(node);
    }

    public JSVarStatementImpl(JSVarStatementStub node) {
        super(node, (IStubElementType)JSStubElementTypes.VAR_STATEMENT);
    }

    @Override
    public void declareVariable(String name, JSExpression initializer) {
        throw new UnsupportedOperationException("TODO: implement");
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (ActionScriptResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)this)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    @NotNull
    public JSVariable[] getVariables() {
        JSElement[] variables = (JSElement[])this.getStubOrPsiChildren(VARIABLES_AND_DESTRUCTURING_CONTAINERS, JSElement.ARRAY_FACTORY);
        ArrayList result = ContainerUtil.newArrayList();
        for (JSElement element : variables) {
            if (element instanceof JSVariable) {
                result.add((JSVariable)element);
                continue;
            }
            if (!(element instanceof JSDestructuringContainer)) continue;
            JSDestructuringContainer destructuringContainer = (JSDestructuringContainer)element;
            Collection<PsiElement> descendants = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)destructuringContainer, JSExtendedLanguagesTokenSetProvider.VARIABLES);
            for (PsiElement descendant : descendants) {
                result.add((JSVariable)descendant);
            }
        }
        JSVariable[] jSVariableArray = result.toArray(new JSVariable[result.size()]);
        if (jSVariableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "getVariables"));
        }
        return jSVariableArray;
    }

    @Override
    protected boolean shouldDirectProcessVariables(@NotNull PsiScopeProcessor processor, PsiElement lastParent) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "shouldDirectProcessVariables"));
        }
        if (super.shouldDirectProcessVariables(processor, lastParent)) {
            return true;
        }
        ASTNode firstChild = this.getNode().getFirstChildNode();
        return firstChild != null && (firstChild.getElementType() == JSTokenTypes.LET_KEYWORD || firstChild.getElementType() == JSTokenTypes.CONST_KEYWORD);
    }

    @Override
    public JSVarStatement.VarKeyword getVarKeyword() {
        ASTNode keyword = this.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS);
        if (keyword == null) {
            return null;
        }
        IElementType elementType = keyword.getElementType();
        if (elementType == JSTokenTypes.VAR_KEYWORD) {
            return JSVarStatement.VarKeyword.VAR;
        }
        if (elementType == JSTokenTypes.LET_KEYWORD) {
            return JSVarStatement.VarKeyword.LET;
        }
        if (elementType == JSTokenTypes.CONST_KEYWORD) {
            return JSVarStatement.VarKeyword.CONST;
        }
        assert (false) : "unsupported var keyword " + keyword.getElementType().toString();
        return null;
    }
}

