/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionHelper;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionResultSink
extends ResultSink {
    private JSType mySmartCompletionExpectedType;
    @Nullable
    private Condition<PsiElement> myPlaceFilter;
    private TIntArrayList myNestingLevels = new TIntArrayList();
    private int myCurrentNestingLevel = 0;
    private int myThisClassVariantsStart = -1;
    private int myThisClassVariantsEnd = -1;
    protected ProcessingContext mySmartCompletionInheritanceProcessingContext;
    private String myReferencedParameterName;
    private String myQualifiedNameToSkip;
    private final PrefixMatcher myPrefixMatcher;
    private int myGlobalDeclarationsStart = Integer.MAX_VALUE;

    public CompletionResultSink(PsiElement place) {
        super(place);
        if (place != null) {
            ResolveProcessor.ProcessingOptions processingOptions = (ResolveProcessor.ProcessingOptions)place.getContainingFile().getOriginalFile().getUserData(ResolveProcessor.PROCESSING_OPTIONS);
            Condition<PsiElement> condition = this.myPlaceFilter = processingOptions != null ? processingOptions.getFilter() : null;
        }
        if (place instanceof JSReferenceExpression) {
            PsiElement originalParent;
            JSParameterItem param;
            PsiElement parent;
            JSType expectedType;
            Function<PsiElement, Boolean> f;
            if (this.myPlaceFilter == null && (f = CompletionResultSink.buildSimpleCompletionFilter(place)) != null) {
                this.myPlaceFilter = psiElement -> (Boolean)f.fun(psiElement);
            }
            if (this.isActionScript() && JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction() && (expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)place)) != null) {
                this.mySmartCompletionExpectedType = expectedType;
                this.mySmartCompletionInheritanceProcessingContext = JSSmartCompletionVariantsHandler.initProcessingContext(place);
            }
            if ((parent = place.getParent()) instanceof JSArgumentList && (param = JSResolveUtil.findParameterForUsedArgument((JSExpression)((JSReferenceExpression)place), (JSArgumentList)parent)) != null) {
                this.myReferencedParameterName = param.getName();
            }
            if (JSResolveUtil.isSelfReference(parent, place) && (originalParent = PsiUtilBase.getOriginalElement((PsiElement)parent, JSQualifiedNamedElement.class)) instanceof JSQualifiedNamedElement) {
                this.myQualifiedNameToSkip = ((JSQualifiedNamedElement)originalParent).getQualifiedName();
            }
        }
        this.myPrefixMatcher = JSCompletionContributor.getInstance().getPrefixMatcher();
    }

    @Override
    public String getName() {
        return null;
    }

    public void setSmartCompletionInheritanceProcessingContext(ProcessingContext smartCompletionInheritanceProcessingContext) {
        this.mySmartCompletionInheritanceProcessingContext = smartCompletionInheritanceProcessingContext;
    }

    public ProcessingContext getSmartCompletionInheritanceProcessingContext() {
        return this.mySmartCompletionInheritanceProcessingContext;
    }

    @Override
    public boolean accepts(PsiElement element) {
        if (this.myPlaceFilter != null && !this.myPlaceFilter.value((Object)element)) {
            return false;
        }
        return super.accepts(element);
    }

    @Override
    public boolean addResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        if (this.mySmartCompletionExpectedType != null && !JSSmartCompletionVariantsHandler.isAcceptableVariant(element, this.mySmartCompletionExpectedType, this.mySmartCompletionInheritanceProcessingContext)) {
            return true;
        }
        this.myNestingLevels.add(this.myCurrentNestingLevel);
        return super.addResult(element, state, resolveProcessor);
    }

    public static Condition<PsiElement> createFilter(@Nullable Condition<JSClass> classFilter) {
        if (classFilter == null) {
            return Conditions.alwaysTrue();
        }
        return psiElement -> psiElement instanceof JSPackageWrapper || psiElement instanceof JSClass && classFilter.value((Object)((JSClass)psiElement));
    }

    public void setPlaceFilter(Condition<PsiElement> placeFilter) {
        this.myPlaceFilter = placeFilter;
    }

    private static boolean typeCanBePresentInNew(@Nullable JSType type) {
        if (type == null || type instanceof JSAnyType) {
            return false;
        }
        return type.getTypeText().equals("Class");
    }

    private void flushMyThisClassVariantsEnd() {
        if (this.myThisClassVariantsEnd == -1) {
            List<PsiElement> results = this.getResults();
            if (results == null) {
                this.myThisClassVariantsEnd = 0;
            } else {
                int classVariantsEnd = results.size();
                if (results.get(classVariantsEnd - 1) instanceof JSClass) {
                    --classVariantsEnd;
                }
                this.myThisClassVariantsEnd = classVariantsEnd;
            }
        }
    }

    @Nullable
    private static Function<PsiElement, Boolean> buildSimpleCompletionFilter(PsiElement place) {
        Function result = null;
        PsiElement parent = place.getParent();
        if (parent instanceof JSReferenceListMember) {
            boolean acceptOnlyInterfaces;
            boolean acceptOnlyClasses;
            if (JSElementTypes.EXTENDS_LISTS.contains((parent = parent.getParent()).getNode().getElementType())) {
                PsiElement element2 = parent.getParent();
                if (element2 instanceof JSClass) {
                    if (((JSClass)element2).isInterface()) {
                        acceptOnlyClasses = false;
                        acceptOnlyInterfaces = true;
                    } else {
                        acceptOnlyClasses = true;
                        acceptOnlyInterfaces = false;
                    }
                } else {
                    acceptOnlyClasses = false;
                    acceptOnlyInterfaces = false;
                }
            } else {
                acceptOnlyClasses = false;
                acceptOnlyInterfaces = true;
            }
            if (acceptOnlyInterfaces || acceptOnlyClasses) {
                result = element -> {
                    if (element instanceof JSClass) {
                        JSAttributeList attributeList;
                        JSClass clazz = (JSClass)element;
                        boolean isInterface = clazz.isInterface();
                        if (acceptOnlyClasses && isInterface || acceptOnlyInterfaces && !isInterface) {
                            return Boolean.FALSE;
                        }
                        if (acceptOnlyClasses && (attributeList = clazz.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
                            return Boolean.FALSE;
                        }
                    }
                    return Boolean.TRUE;
                };
            }
        } else if (ResolveProcessor.completeConstructorName(place)) {
            result = element -> {
                if (element instanceof JSClass && ((JSClass)element).isInterface()) {
                    return Boolean.FALSE;
                }
                if (!(!(element instanceof JSFunction) || !(element.getParent() instanceof JSClass) || ((JSFunction)element).isConstructor() || ((JSFunction)element).isGetProperty() && CompletionResultSink.typeCanBePresentInNew(((JSFunction)element).getReturnType()))) {
                    return Boolean.FALSE;
                }
                if (element instanceof JSVariable && !CompletionResultSink.typeCanBePresentInNew(((JSVariable)element).getType()) && element.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            };
        }
        return result;
    }

    public List<LookupElement> getResultsAsObjects() {
        List<PsiElement> processorResults = this.getResults();
        return processorResults == null ? Collections.emptyList() : this.resultsToLookupElements(processorResults);
    }

    public List<LookupElement> resultsToLookupElements(List<PsiElement> processorResults) {
        int numberOfVariants = processorResults.size();
        ArrayList<LookupElement> objects = new ArrayList<LookupElement>(numberOfVariants);
        Set<String> variantsFromSmartCompletion = JSCompletionContributor.getInstance().getAlreadyUsedClassesSet();
        THashSet processedCandidateNames = new THashSet(numberOfVariants);
        THashMap typeScriptCompleteMatches = ContainerUtil.newTroveMap();
        if (variantsFromSmartCompletion != null) {
            processedCandidateNames.addAll(variantsFromSmartCompletion);
        }
        for (int i = 0; i < numberOfVariants; ++i) {
            boolean typeScript;
            String qName;
            PsiElement resolve;
            PsiElement namedElement = processorResults.get(i);
            String name = ResolveProcessor.getName(namedElement);
            if (namedElement instanceof ES6ImportExportSpecifier && (resolve = ((PsiReference)namedElement).resolve()) != null) {
                namedElement = resolve;
            }
            if (name == null || !BasicJavascriptNamesValidator.isUnqualifiedType(name) || namedElement instanceof ImplicitJSVariableImpl && "use strict".equals(name)) continue;
            if (this.place != null && this.place.getParent() instanceof JSNewExpression && namedElement instanceof JSFunction && ((JSFunction)namedElement).isConstructor()) {
                qName = ((JSClass)namedElement.getParent()).getQualifiedName() + "." + ((JSFunction)namedElement).getName();
            } else {
                String string = qName = namedElement instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)namedElement).getQualifiedName() : name;
            }
            if (this.myQualifiedNameToSkip != null && this.myQualifiedNameToSkip.equals(qName)) continue;
            int nestingLevel = this.myNestingLevels.get(i);
            if ("arguments".equals(name) && namedElement instanceof ImplicitJSVariableImpl) {
                nestingLevel = -1;
            }
            if (namedElement instanceof JSProperty) {
                int max = 0;
                for (int j = 0; j < this.myNestingLevels.size(); ++j) {
                    max = Math.max(max, this.myNestingLevels.getQuick(i));
                }
                nestingLevel = max;
            }
            boolean sameClass = (typeScript = DialectDetector.isTypeScript(namedElement)) ? nestingLevel == 0 : i >= this.myThisClassVariantsStart && (i < this.myThisClassVariantsEnd || this.myThisClassVariantsEnd == -1) || namedElement instanceof JSProperty;
            boolean matchesReferencedParameterName = this.myReferencedParameterName != null && this.myReferencedParameterName.equals(name);
            JSLookupPriority priority = null;
            if (this.place != null) {
                priority = JSDialectSpecificHandlersFactory.forElement(this.place).getSpecificCompletionVariantPriority(namedElement);
            }
            if (priority == null) {
                if (typeScript) {
                    boolean fromTheSameFile;
                    boolean bl = fromTheSameFile = i < this.myGlobalDeclarationsStart;
                    priority = this.place instanceof JSReferenceExpression && ((JSReferenceExpression)this.place).getQualifier() == null && !fromTheSameFile && nestingLevel == 0 ? JSLookupPriority.TOP_LEVEL_SYMBOLS_FROM_OTHER_FILES : (fromTheSameFile ? JSLookupPriority.getSameFileValue(matchesReferencedParameterName, nestingLevel) : JSLookupPriority.getSameTypeValue(false, BaseJSSymbolProcessor.MatchType.COMPLETE, nestingLevel));
                } else {
                    priority = JSLookupPriority.getSameFileValue(matchesReferencedParameterName, nestingLevel);
                }
                if (typeScript && namedElement instanceof JSImplicitElement && nestingLevel == 0 && ((JSImplicitElement)namedElement).hasMinorImportance()) {
                    priority = JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false);
                }
            }
            if (typeScript && VariantsProcessor.wasCompleteMatch(priority.getPriorityValue())) {
                Pair levelToContext;
                boolean hasSameNameObject;
                boolean isClassContext;
                PsiElement currentContext = namedElement.getContext();
                String nameForMerge = qName;
                boolean bl = isClassContext = currentContext instanceof JSClass || currentContext instanceof TypeScriptObjectType;
                if (isClassContext) {
                    nameForMerge = name;
                }
                boolean bl2 = hasSameNameObject = (levelToContext = (Pair)typeScriptCompleteMatches.get(nameForMerge)) != null;
                if (!processedCandidateNames.add(qName) && !hasSameNameObject) continue;
                if (levelToContext == null) {
                    typeScriptCompleteMatches.put(nameForMerge, Pair.create((Object)nestingLevel, (Object)currentContext));
                }
                if (hasSameNameObject) {
                    boolean overloadDeclaration;
                    PsiElement storedContext = (PsiElement)levelToContext.second;
                    Integer storedLevel = (Integer)levelToContext.first;
                    boolean bl3 = overloadDeclaration = hasSameNameObject && (storedContext == currentContext || isClassContext && storedLevel.equals(nestingLevel));
                    if (hasSameNameObject && !overloadDeclaration) {
                        continue;
                    }
                }
            } else if (!processedCandidateNames.add(qName)) continue;
            objects.add(this.createLookupItem(namedElement, name, sameClass, priority));
        }
        return objects;
    }

    protected LookupElement createLookupItem(PsiElement namedElement, String name, boolean sameClass, @NotNull JSLookupPriority priority) {
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink", "createLookupItem"));
        }
        for (JSCompletionHelper helper : (JSCompletionHelper[])Extensions.getExtensions(JSCompletionHelper.EP_NAME)) {
            LookupElement lookupElement = helper.createLookupElement(namedElement, name, sameClass, priority);
            if (lookupElement == null) continue;
            return lookupElement;
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(namedElement, name, priority, sameClass, this.isActionScript());
    }

    @Override
    public void startingParent(PsiElement parent, ResolveProcessor resolveProcessor) {
        if (parent instanceof JSClass) {
            int scopeBound;
            List<PsiElement> results = super.getResults();
            int n = results == null ? 0 : (scopeBound = !results.isEmpty() && results.get(results.size() - 1) == parent ? results.size() - 1 : results.size());
            if (scopeBound > 0 && !DialectDetector.isTypeScript(parent)) {
                ++this.myCurrentNestingLevel;
            }
            if (this.myThisClassVariantsStart == -1) {
                int n2 = this.myThisClassVariantsStart = results != null ? results.size() : 0;
                if (!resolveProcessor.isToProcessMembers()) {
                    this.flushMyThisClassVariantsEnd();
                }
            } else {
                this.flushMyThisClassVariantsEnd();
            }
        } else if (parent instanceof JSFunction) {
            ++this.myCurrentNestingLevel;
        }
    }

    @Override
    public boolean skipTopLevelItems() {
        return this.place instanceof JSReferenceExpression && !JSResolveUtil.isExprInTypeContext((JSReferenceExpression)this.place) && this.myPrefixMatcher != null && this.myPrefixMatcher.getPrefix().length() == 0 && !(this.place.getContainingFile() instanceof PsiCodeFragment);
    }

    @Override
    public boolean needTopLevelClassName(String name) {
        return this.myPrefixMatcher == null || this.myPrefixMatcher.prefixMatches(name);
    }

    @Override
    public int getNestingLevel() {
        return this.myCurrentNestingLevel;
    }

    @Override
    public void setNestingLevel(int nestingLevel) {
        this.myCurrentNestingLevel = nestingLevel;
    }

    @Override
    public void startGlobalDeclarations() {
        List<PsiElement> results = this.getResults();
        this.myGlobalDeclarationsStart = results != null ? results.size() : 0;
    }
}

