/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluateContext
implements JSEvaluationResultContext {
    @Nullable
    public final PsiFile targetFile;
    private final Set<String> visitedTypes = new THashSet();
    @NotNull
    private final List<Pair<PsiElement, JSEvaluationPlace>> processingItems;
    @NotNull
    private final Set<PsiElement> processingItemsSet;
    private PsiElement source;
    private JSReferenceExpression myProcessedExpression;
    private final Deque<JSElement> myJSElementsToApply;
    private boolean myTypeIsGuessed;
    protected boolean myPrototypeWasReferenced;
    protected boolean myConstructorWasReferenced;
    @Nullable
    private PsiFile myJSModule;

    public JSEvaluateContext(@Nullable PsiFile _targetFile) {
        this(_targetFile, null);
    }

    public JSEvaluateContext(@Nullable PsiFile _targetFile, @Nullable JSEvaluateContext parentContext) {
        this.targetFile = _targetFile;
        this.myJSElementsToApply = new ArrayDeque<JSElement>(5);
        this.processingItems = parentContext != null ? parentContext.processingItems : new SmartList();
        this.processingItemsSet = parentContext != null ? parentContext.processingItemsSet : new THashSet();
    }

    @NotNull
    public static JSEvaluateContext fromEvaluationResultContext(@NotNull JSEvaluationResultContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
        }
        if (context instanceof JSEvaluateContext) {
            JSEvaluateContext jSEvaluateContext = (JSEvaluateContext)context;
            if (jSEvaluateContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
            }
            return jSEvaluateContext;
        }
        JSEvaluateContext result = new JSEvaluateContext(null);
        for (JSElement element : context.getJSElementsToApply()) {
            result.pushJSElementToApply(element);
        }
        result.setTypeIsGuessed(context.isTypeGuessed());
        result.setPrototypeWasReferenced(context.wasPrototypeReferenced());
        result.setConstructorWasReferenced(context.wasConstructorReferenced());
        result.myJSModule = context.getJSModule();
        JSEvaluateContext jSEvaluateContext = result;
        if (jSEvaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
        }
        return jSEvaluateContext;
    }

    public boolean isAlreadyProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "isAlreadyProcessingItem"));
        }
        return this.isAlreadyProcessingItem(element, JSEvaluationPlace.DEFAULT);
    }

    public boolean isAlreadyProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluationPlace place) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "isAlreadyProcessingItem"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "isAlreadyProcessingItem"));
        }
        if (!this.processingItemsSet.contains(element)) {
            return false;
        }
        for (int i = this.processingItems.size() - 1; i >= 0; --i) {
            Pair<PsiElement, JSEvaluationPlace> pair = this.processingItems.get(i);
            if (element.equals(pair.first) && place.equals(pair.second)) {
                return true;
            }
            if (((JSEvaluationPlace)((Object)pair.second)).ordinal() >= place.ordinal()) continue;
            return false;
        }
        return false;
    }

    @Nullable
    public JSReferenceExpression getProcessedExpression() {
        return this.myProcessedExpression;
    }

    public void setProcessedExpression(@Nullable JSReferenceExpression processedExpression) {
        this.myProcessedExpression = processedExpression;
    }

    public void addProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "addProcessingItem"));
        }
        this.addProcessingItem(element, JSEvaluationPlace.DEFAULT);
    }

    public void addProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluationPlace place) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "addProcessingItem"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "addProcessingItem"));
        }
        this.processingItemsSet.add(element);
        this.processingItems.add((Pair<PsiElement, JSEvaluationPlace>)Pair.create((Object)element, (Object)((Object)place)));
    }

    public void removeProcessingItem(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "removeProcessingItem"));
        }
        this.removeProcessingItem(element, JSEvaluationPlace.DEFAULT);
    }

    public void removeProcessingItem(@NotNull PsiElement element, @NotNull JSEvaluationPlace place) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "removeProcessingItem"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "removeProcessingItem"));
        }
        Pair<PsiElement, JSEvaluationPlace> removed = this.processingItems.remove(this.processingItems.size() - 1);
        assert (((PsiElement)removed.first).equals(element) && ((JSEvaluationPlace)((Object)removed.second)).equals((Object)place)) : "wrong element removed";
    }

    public PsiElement getSource() {
        return this.source;
    }

    public void setSource(PsiElement source) {
        this.source = source;
    }

    public boolean alreadyProcessed(String type) {
        return this.visitedTypes.contains(type);
    }

    public boolean ensureProcessed(String type) {
        return !this.visitedTypes.add(type);
    }

    @NotNull
    public JSElement popJSElementToApply() {
        JSElement jSElement = this.myJSElementsToApply.pop();
        if (jSElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "popJSElementToApply"));
        }
        return jSElement;
    }

    @Override
    @Nullable
    public JSElement peekJSElementToApply() {
        return this.myJSElementsToApply.peek();
    }

    public void pushJSElementToApply(@NotNull JSElement elementToApply) {
        if (elementToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToApply", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "pushJSElementToApply"));
        }
        this.myJSElementsToApply.push(elementToApply);
    }

    @Override
    public boolean isJSElementsToApplyEmpty() {
        return this.myJSElementsToApply.isEmpty();
    }

    @Override
    public boolean isTypeGuessed() {
        return this.myTypeIsGuessed;
    }

    public void setTypeIsGuessed(boolean typeIsGuessed) {
        this.myTypeIsGuessed = typeIsGuessed;
    }

    @Override
    public boolean wasPrototypeReferenced() {
        return this.myPrototypeWasReferenced;
    }

    public void setPrototypeWasReferenced(boolean prototypeWasReferenced) {
        this.myPrototypeWasReferenced = prototypeWasReferenced;
    }

    @Override
    public boolean wasConstructorReferenced() {
        return this.myConstructorWasReferenced;
    }

    public void setConstructorWasReferenced(boolean constructorWasReferenced) {
        this.myConstructorWasReferenced = constructorWasReferenced;
    }

    @NotNull
    public Deque<JSElement> getJSElementsToApply() {
        Deque<JSElement> deque = this.myJSElementsToApply;
        if (deque == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "getJSElementsToApply"));
        }
        return deque;
    }

    @Override
    @Nullable
    public PsiFile getJSModule() {
        return this.myJSModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withJSModule(@Nullable PsiFile jsModule, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withJSModule"));
        }
        PsiFile jsModuleBefore = this.getJSModule();
        try {
            this.myJSModule = jsModule;
            runnable.run();
        }
        finally {
            this.myJSModule = jsModuleBefore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withCombinedContext(@NotNull JSEvaluationResultContext context, @NotNull Runnable runnable) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withCombinedContext"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withCombinedContext"));
        }
        int sizeBefore = this.myJSElementsToApply.size();
        PsiFile jsModuleBefore = this.myJSModule;
        boolean typeIsGuessedBefore = this.myTypeIsGuessed;
        boolean prototypeWasReferencedBefore = this.myPrototypeWasReferenced;
        try {
            for (JSElement element : context.getJSElementsToApply()) {
                this.pushJSElementToApply(element);
            }
            this.myJSModule = context.getJSModule();
            this.myTypeIsGuessed |= context.isTypeGuessed();
            this.myPrototypeWasReferenced |= context.wasPrototypeReferenced();
            runnable.run();
        }
        finally {
            while (this.myJSElementsToApply.size() > sizeBefore) {
                this.popJSElementToApply();
            }
            this.myJSModule = jsModuleBefore;
            this.myTypeIsGuessed = typeIsGuessedBefore;
            this.myPrototypeWasReferenced = prototypeWasReferencedBefore;
        }
    }

    @Override
    public boolean isEquivalentTo(JSEvaluationResultContext other) {
        return JSEvaluationResultContext.JSEvaluationResultContextImpl.areEvaluationContextsEquivalent(this, other);
    }

    public static enum JSEvaluationPlace {
        TYPEOF_TYPE,
        DEFAULT,
        FORCE_EVALUATE_TYPE,
        REFERENCE_EXPRESSION;

    }
}

