/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSEvaluationResultContext {
    public static final JSEvaluationResultContext EMPTY = new JSEvaluationResultContextImpl(Collections.emptyList(), false, false, false, null);

    @Nullable
    public JSElement peekJSElementToApply();

    public boolean isJSElementsToApplyEmpty();

    public boolean isTypeGuessed();

    public boolean wasPrototypeReferenced();

    public boolean wasConstructorReferenced();

    public Collection<JSElement> getJSElementsToApply();

    public boolean isEquivalentTo(JSEvaluationResultContext var1);

    @Nullable
    public PsiFile getJSModule();

    public static class JSEvaluationResultContextImpl
    implements JSEvaluationResultContext {
        private final List<JSElement> myJSElementsToApply;
        private final boolean myPrototypeWasReferenced;
        private final boolean myConstructorWasReferenced;
        private final boolean myTypeIsGuessed;
        @Nullable
        private final PsiFile myJSModule;

        private JSEvaluationResultContextImpl(Collection<JSElement> jsElementsToApply, boolean prototypeWasReferenced, boolean constructorWasReferenced, boolean typeIsGuessed, @Nullable PsiFile jsModule) {
            this.myJSElementsToApply = ContainerUtil.immutableList((Object[])jsElementsToApply.toArray(new JSElement[jsElementsToApply.size()]));
            this.myPrototypeWasReferenced = prototypeWasReferenced;
            this.myConstructorWasReferenced = constructorWasReferenced;
            this.myTypeIsGuessed = typeIsGuessed;
            this.myJSModule = jsModule;
        }

        @NotNull
        public static JSEvaluationResultContext copyFrom(@Nullable JSEvaluationResultContext other) {
            if (other == null || other.isJSElementsToApplyEmpty() && !other.wasPrototypeReferenced() && !other.wasConstructorReferenced() && !other.isTypeGuessed() && other.getJSModule() == null) {
                JSEvaluationResultContext jSEvaluationResultContext = EMPTY;
                if (jSEvaluationResultContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl", "copyFrom"));
                }
                return jSEvaluationResultContext;
            }
            JSEvaluationResultContextImpl jSEvaluationResultContextImpl = new JSEvaluationResultContextImpl(other.getJSElementsToApply(), other.wasPrototypeReferenced(), other.wasConstructorReferenced(), other.isTypeGuessed(), other.getJSModule());
            if (jSEvaluationResultContextImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl", "copyFrom"));
            }
            return jSEvaluationResultContextImpl;
        }

        @Override
        @Nullable
        public JSElement peekJSElementToApply() {
            return this.myJSElementsToApply.get(this.myJSElementsToApply.size() - 1);
        }

        @Override
        public boolean isJSElementsToApplyEmpty() {
            return this.myJSElementsToApply.isEmpty();
        }

        @Override
        public boolean isTypeGuessed() {
            return this.myTypeIsGuessed;
        }

        @Override
        public boolean wasPrototypeReferenced() {
            return this.myPrototypeWasReferenced;
        }

        @Override
        public boolean wasConstructorReferenced() {
            return this.myConstructorWasReferenced;
        }

        @Override
        public Collection<JSElement> getJSElementsToApply() {
            return this.myJSElementsToApply;
        }

        @Override
        @Nullable
        public PsiFile getJSModule() {
            return this.myJSModule;
        }

        @Override
        public boolean isEquivalentTo(@NotNull JSEvaluationResultContext other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl", "isEquivalentTo"));
            }
            return JSEvaluationResultContextImpl.areEvaluationContextsEquivalent(this, other);
        }

        public static boolean areEvaluationContextsEquivalent(@NotNull JSEvaluationResultContext obj1, @NotNull JSEvaluationResultContext obj2) {
            if (obj1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj1", "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl", "areEvaluationContextsEquivalent"));
            }
            if (obj2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj2", "com/intellij/lang/javascript/psi/resolve/JSEvaluationResultContext$JSEvaluationResultContextImpl", "areEvaluationContextsEquivalent"));
            }
            return obj1.wasPrototypeReferenced() == obj2.wasPrototypeReferenced() && obj1.isTypeGuessed() == obj2.isTypeGuessed() && obj1.getJSElementsToApply().equals(obj2.getJSElementsToApply()) && obj1.getJSModule() == obj2.getJSModule();
        }
    }
}

