/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSGlobalQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSNameIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceIncludingLocalMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSNamedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.types.JSPackageStatementElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSQualifiedObjectStubBase<T extends JSQualifiedNamedElement>
extends JSNamedObjectStubBase<T>
implements JSQualifiedStub<T> {
    private static final BooleanStructureElement NAMESPACE_EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement DEPRECATED_FLAG = new BooleanStructureElement();
    private static final EnumStructureElement<JSAttributeList.AccessType> ACCESS_TYPE_FLAG = new EnumStructureElement<JSAttributeList.AccessType>(JSAttributeList.AccessType.class);
    private static final EnumStructureElement<JSContext> CONTEXT_FLAG = new EnumStructureElement<JSContext>(JSContext.class);
    private static final BooleanStructureElement IS_CLASS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_NAMESPACE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_EXPORTED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_NAMESPACE_LOCAL_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSNamedObjectStubBase.FLAGS_STRUCTURE, NAMESPACE_EXPLICITLY_DECLARED_FLAG, DEPRECATED_FLAG, ACCESS_TYPE_FLAG, CONTEXT_FLAG, IS_CLASS_FLAG, IS_INTERFACE_FLAG, HAS_NAMESPACE_FLAG, IS_EXPORTED_FLAG, IS_NAMESPACE_LOCAL_FLAG);
    @Nullable
    protected final JSQualifiedName myNamespace;

    protected JSQualifiedObjectStubBase(T qualifiedObject, StubElement parent, @NotNull JSStubElementType<?, T> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        super(qualifiedObject, parent, elementType);
        this.myNamespace = qualifiedObject.getJSNamespace().getQualifiedName();
        this.writeFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG, qualifiedObject.isNamespaceExplicitlyDeclared());
        this.writeFlag(ACCESS_TYPE_FLAG, qualifiedObject.getAccessType());
        this.writeFlag(DEPRECATED_FLAG, qualifiedObject.isDeprecated());
        this.writeFlag(CONTEXT_FLAG, qualifiedObject.getJSContext());
        JSElementBase.ClassOrInterface classOrInterface = qualifiedObject.isClassOrInterface();
        this.writeFlag(IS_CLASS_FLAG, classOrInterface == JSElementBase.ClassOrInterface.CLASS);
        this.writeFlag(IS_INTERFACE_FLAG, classOrInterface == JSElementBase.ClassOrInterface.INTERFACE);
        this.writeFlag(HAS_NAMESPACE_FLAG, this.myNamespace != null);
        this.writeFlag(IS_EXPORTED_FLAG, qualifiedObject.isExported());
        this.writeFlag(IS_NAMESPACE_LOCAL_FLAG, qualifiedObject.getJSNamespace().isLocal());
    }

    protected JSQualifiedObjectStubBase(String name, String qName, StubElement parent, @NotNull JSContext jsContext, @NotNull JSAttributeList.AccessType accessType, @NotNull IStubElementType elementType) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        super(name, parent, elementType);
        JSQualifiedNameImpl qualifiedName = qName != null ? JSQualifiedNameImpl.fromQualifiedName(qName) : null;
        this.myNamespace = qualifiedName != null ? qualifiedName.getParent() : null;
        this.writeFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG, true);
        this.writeFlag(ACCESS_TYPE_FLAG, JSAttributeList.AccessType.PACKAGE_LOCAL);
        this.writeFlag(DEPRECATED_FLAG, false);
        this.writeFlag(CONTEXT_FLAG, jsContext);
        this.writeFlag(ACCESS_TYPE_FLAG, accessType);
        this.writeFlag(HAS_NAMESPACE_FLAG, this.myNamespace != null);
        this.writeFlag(IS_EXPORTED_FLAG, false);
        this.writeFlag(IS_NAMESPACE_LOCAL_FLAG, false);
    }

    protected JSQualifiedObjectStubBase(StubInputStream dataStream, StubElement parentStub, @NotNull IStubElementType elementType) throws IOException {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        super(dataStream, parentStub, elementType);
        this.myNamespace = this.readFlag(HAS_NAMESPACE_FLAG) != false ? JSQualifiedNameImpl.deserialize(dataStream) : null;
    }

    @Override
    public void index(IndexSink sink) {
        Language language;
        super.index(sink);
        String name = this.getName();
        String fqn = this.getQualifiedName();
        if (name != null && this.doIndexName() && ((language = StubTreeUtil.getJSLanguage(this)) == JavaScriptSupportLoader.ECMA_SCRIPT_L4 || language != JavascriptLanguage.INSTANCE && !(language instanceof JSLanguageDialect))) {
            sink.occurrence(JSNameIndex.KEY, (Object)name);
        }
        if (fqn != null && this.doIndexQualifiedName()) {
            sink.occurrence(JSQualifiedElementIndex.KEY, (Object)fqn.hashCode());
            if (this.doIndexForGlobalQualifiedName()) {
                sink.occurrence(JSGlobalQualifiedElementIndex.KEY, (Object)fqn.hashCode());
            }
        }
        if (name != null && this.readFlag(IS_SYMBOL_FLAG).booleanValue()) {
            JSQualifiedName namespaceIncludingLocal;
            JSQualifiedName namespace = this.getNamespace();
            if (namespace != null || this.isNamespaceExplicitlyDeclared()) {
                if (namespace != null) {
                    sink.occurrence(JSNamespaceMembersIndex.KEY, (Object)namespace.getQualifiedName());
                } else if (this.isGlobalNamespace()) {
                    sink.occurrence(JSNamespaceMembersIndex.KEY, (Object)"");
                }
            }
            if ((namespaceIncludingLocal = this.getJSNamespace().getQualifiedName()) != null) {
                sink.occurrence(JSNamespaceIncludingLocalMembersIndex.KEY, (Object)namespaceIncludingLocal.getQualifiedName());
            }
            assert (fqn != null) : ((Object)((Object)this)).getClass();
            sink.occurrence(JSSymbolQualifiedNamesIndex.KEY, (Object)fqn.hashCode());
        }
        if (name != null && (this.readFlag(IS_CLASS_FLAG).booleanValue() || this.readFlag(IS_INTERFACE_FLAG).booleanValue())) {
            sink.occurrence(JSClassIndex.KEY, (Object)JSClassIndex.getNameToIndex(name, this.readFlag(IS_INTERFACE_FLAG)));
        }
    }

    protected boolean doIndexName() {
        return false;
    }

    protected boolean doIndexQualifiedName() {
        return false;
    }

    protected boolean isGlobalNamespace() {
        return StubTreeUtil.isFromGlobalNamespace((StubElement)this);
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = this.readFlag(IS_INTERFACE_FLAG) != false ? JSElementBase.ClassOrInterface.INTERFACE : (this.readFlag(IS_CLASS_FLAG) != false ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "isClassOrInterface"));
        }
        return classOrInterface;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_NAMESPACE_FLAG).booleanValue()) {
            assert (this.myNamespace != null) : ((Object)((Object)this)).getClass();
            JSQualifiedNameImpl.serialize(this.myNamespace, dataStream);
        }
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(this.myNamespace, this.getJSContext(), this.isNamespaceExplicitlyDeclared(), this.readFlag(IS_NAMESPACE_LOCAL_FLAG));
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "getJSNamespace"));
        }
        return jSNamespaceImpl;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.readFlag(IS_NAMESPACE_LOCAL_FLAG) != false ? null : this.myNamespace;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.readFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG);
    }

    protected boolean doIndexForGlobalQualifiedName() {
        return false;
    }

    public String getQualifiedName() {
        if (this.myName == null) {
            return null;
        }
        String name = this.myName.getString();
        if (name == null) {
            return null;
        }
        String prefix = this.myNamespace != null ? this.myNamespace.getQualifiedName() + "." : "";
        return prefix + name;
    }

    protected static boolean isUnderPackageOrUnderFile(StubElement stub) {
        StubElement parentStub = stub.getParentStub();
        if (parentStub == null) {
            return false;
        }
        IStubElementType stubType = parentStub.getStubType();
        return stubType instanceof JSPackageStatementElementType || stubType == null;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.readFlag(ACCESS_TYPE_FLAG);
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "getAccessType"));
        }
        return accessType;
    }

    public boolean isExported() {
        return this.readFlag(IS_EXPORTED_FLAG);
    }

    public boolean isDeprecated() {
        return this.readFlag(DEPRECATED_FLAG);
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.readFlag(CONTEXT_FLAG);
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "getJSContext"));
        }
        return jSContext;
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "getFlagsStructure"));
        }
        return flagsStructure;
    }
}

