/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCompositeTypeBaseImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    private final List<JSType> myTypes;

    public static boolean isEmptyType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "isEmptyType"));
        }
        return type instanceof JSUndefinedType || type instanceof JSNullType;
    }

    public JSCompositeTypeBaseImpl(JSTypeSource source, JSType ... _types) {
        super(source);
        ArrayList list = new ArrayList(_types.length);
        Collections.addAll(list, _types);
        this.myTypes = Collections.unmodifiableList(list);
    }

    public JSCompositeTypeBaseImpl(JSTypeSource source, Collection<JSType> _types) {
        super(source);
        ArrayList<JSType> list = new ArrayList<JSType>(_types);
        this.myTypes = Collections.unmodifiableList(list);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.CODE && !this.isTypeScript()) {
            if ("*" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "getTypeText"));
            }
            return "*";
        }
        StringBuilder b = new StringBuilder();
        for (JSType t : this.myTypes) {
            boolean shouldWrap;
            if (t == null) continue;
            if (b.length() != 0) {
                b.append(this.getTypeSeparator());
            }
            boolean bl = shouldWrap = t instanceof JSUnionOrIntersectionType && ((Object)((Object)this)).getClass() != t.getClass() || t instanceof JSFunctionTypeImpl;
            if (shouldWrap) {
                b.append("(");
            }
            b.append(this.getNestedTypePresentation(format, t));
            if (!shouldWrap) continue;
            b.append(")");
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "getTypeText"));
        }
        return string;
    }

    protected String getNestedTypePresentation(JSType.TypeTextFormat format, JSType t) {
        return t.getTypeText(format);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "isEquivalentToImpl"));
        }
        if (type instanceof JSCompositeTypeBaseImpl && type.getClass() == ((Object)((Object)this)).getClass()) {
            Iterator<JSType> iterator = ((JSCompositeTypeBaseImpl)type).getTypes().iterator();
            for (JSType jsType : this.getTypes()) {
                if (iterator.hasNext() && jsType.isEquivalentTo(iterator.next(), processingContext, allowResolve)) continue;
                return false;
            }
            return !iterator.hasNext();
        }
        return false;
    }

    @NotNull
    public List<JSType> getTypes() {
        List<JSType> list = this.myTypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "getTypes"));
        }
        return list;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSCompositeBaseType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        for (JSType type : this.myTypes) {
            type.accept(visitor);
        }
    }

    protected abstract String getTypeSeparator();

    @Override
    @NotNull
    protected final JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "copyTypeHierarchy"));
        }
        ArrayList newTypes = ContainerUtil.newArrayList();
        List<JSType> oldTypes = this.getTypes();
        for (JSType jsType : oldTypes) {
            newTypes.add(JSTypeUtils.transformTypeHierarchySafe(jsType, childTransform));
        }
        if (ContainerUtil.equalsIdentity((List)newTypes, oldTypes)) {
            JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this;
            if (jSCompositeTypeBaseImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "copyTypeHierarchy"));
            }
            return jSCompositeTypeBaseImpl;
        }
        JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this.createType(newTypes, this.getSource());
        if (jSCompositeTypeBaseImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "copyTypeHierarchy"));
        }
        return jSCompositeTypeBaseImpl;
    }

    protected abstract JSCompositeTypeBaseImpl createType(@NotNull List<JSType> var1, @NotNull JSTypeSource var2);

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "copyWithNewSource"));
        }
        JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this.createType(this.getTypes(), source);
        if (jSCompositeTypeBaseImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl", "copyWithNewSource"));
        }
        return jSCompositeTypeBaseImpl;
    }

    @Nullable
    protected JSType getSimpleCompositeTypeResult() {
        List<JSType> types = this.getTypes();
        if (types.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types, null);
        }
        if (types.isEmpty()) {
            return JSAnyType.get(this.getSource().getSourceElement(), this.isExplicitlyDeclared());
        }
        return null;
    }

    protected Collection<JSRecordType> getNestedTypesAsRecordType() {
        return ContainerUtil.map(this.getTypes(), JSType::asRecordType);
    }
}

