/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDecoratedTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @NotNull
    private final Set<TypeDecoration> myDecorations;

    public JSDecoratedTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull Set<TypeDecoration> decorations) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "<init>"));
        }
        if (decorations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorations", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "<init>"));
        }
        super(source);
        this.myType = type;
        this.myDecorations = Collections.unmodifiableSet(decorations);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean wrapInBrackets;
        if (format == JSType.TypeTextFormat.CODE) {
            String string = this.myType.getTypeText(format);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "getTypeText"));
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        if (this.myDecorations.contains((Object)TypeDecoration.NOTNULL)) {
            builder.append("!");
        }
        if (this.myDecorations.contains((Object)TypeDecoration.NULLABLE)) {
            builder.append("?");
        }
        boolean bl = wrapInBrackets = (this.myDecorations.contains((Object)TypeDecoration.NOTNULL) || this.myDecorations.contains((Object)TypeDecoration.NULLABLE)) && JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
        if (wrapInBrackets) {
            builder.append("(");
        }
        builder.append(this.myType.getTypeText(format));
        if (wrapInBrackets) {
            builder.append(")");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (this.myDecorations.contains((Object)TypeDecoration.NOTNULL)) {
            if (elementType instanceof JSNullType || elementType instanceof JSDecoratedTypeImpl && ((JSDecoratedTypeImpl)elementType).myDecorations.contains((Object)TypeDecoration.NULLABLE)) {
                return false;
            }
        } else if (this.myDecorations.contains((Object)TypeDecoration.NULLABLE) && elementType instanceof JSNullType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        JSTypeCastUtil.AssignableResult assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext);
        if (assignableResult.isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult3;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "isEquivalentToImpl"));
        }
        if (type instanceof JSDecoratedTypeImpl) {
            JSDecoratedTypeImpl decoratedType = (JSDecoratedTypeImpl)type;
            return this.myDecorations.equals(decoratedType.getDecorations()) && this.myType.isEquivalentTo(decoratedType.getType(), processingContext, allowResolve);
        }
        return false;
    }

    @NotNull
    public Set<TypeDecoration> getDecorations() {
        Set<TypeDecoration> set = this.myDecorations;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "getDecorations"));
        }
        return set;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "getType"));
        }
        return jSType;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSDecoratedType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType newType;
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "copyTypeHierarchy"));
        }
        JSType oldType = this.getType();
        if (oldType == (newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform))) {
            JSDecoratedTypeImpl jSDecoratedTypeImpl = this;
            if (jSDecoratedTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "copyTypeHierarchy"));
            }
            return jSDecoratedTypeImpl;
        }
        JSDecoratedTypeImpl jSDecoratedTypeImpl = new JSDecoratedTypeImpl(this.getSource(), newType, this.getDecorations());
        if (jSDecoratedTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "copyTypeHierarchy"));
        }
        return jSDecoratedTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "copyWithNewSource"));
        }
        JSDecoratedTypeImpl jSDecoratedTypeImpl = new JSDecoratedTypeImpl(source, this.getType(), this.getDecorations());
        if (jSDecoratedTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "copyWithNewSource"));
        }
        return jSDecoratedTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.myType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl", "substitute"));
        }
        return jSType;
    }

    public static enum TypeDecoration {
        NULLABLE,
        NOTNULL;

    }
}

